/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.h2.bnf.Bnf;
import org.h2.bnf.Rule;
import org.h2.bnf.Sentence;
import org.h2.command.Parser;
import org.h2.message.Message;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbSchema;
import org.h2.server.web.DbTableOrView;
import org.h2.util.StringUtils;

public class DbContextRule
implements Rule {
    DbContents contents;
    int type;
    static final int COLUMN = 0;
    static final int TABLE = 1;
    static final int TABLE_ALIAS = 2;
    public static final int NEW_TABLE_ALIAS = 3;
    public static final int COLUMN_ALIAS = 4;
    public static final int SCHEMA = 5;
    private static final boolean SUGGEST_TABLE_ALIAS = false;

    DbContextRule(DbContents dbContents, int n) {
        this.contents = dbContents;
        this.type = n;
    }

    public String toString() {
        switch (this.type) {
            case 5: {
                return "schema";
            }
            case 1: {
                return "table";
            }
            case 3: {
                return "nt";
            }
            case 2: {
                return "t";
            }
            case 4: {
                return "c";
            }
            case 0: {
                return "column";
            }
        }
        return "?";
    }

    public String name() {
        return null;
    }

    public String random(Bnf bnf, int n) {
        return null;
    }

    public Rule last() {
        return this;
    }

    public void setLinks(HashMap hashMap) {
    }

    public void addNextTokenList(Sentence sentence) {
        switch (this.type) {
            case 5: {
                this.addSchema(sentence);
                break;
            }
            case 1: {
                this.addTable(sentence);
                break;
            }
            case 3: {
                this.addNewTableAlias(sentence);
                break;
            }
            case 2: {
                this.addTableAlias(sentence);
                break;
            }
            case 0: 
            case 4: {
                this.addColumn(sentence);
                break;
            }
        }
    }

    private void addTableAlias(Sentence sentence) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = sentence.query;
        String string2 = StringUtils.toUpperEnglish(string.trim());
        HashMap hashMap = sentence.getAliases();
        HashSet<String> hashSet = new HashSet<String>();
        if (hashMap != null) {
            object4 = hashMap.entrySet().iterator();
            while (object4.hasNext()) {
                object3 = (Map.Entry)object4.next();
                object2 = (String)object3.getKey();
                object = (DbTableOrView)object3.getValue();
                hashSet.add(StringUtils.toUpperEnglish(((DbTableOrView)object).name));
                if (string2.length() != 0 && !((String)object2).startsWith(string2) || string2.length() >= ((String)object2).length()) continue;
                sentence.add((String)object2 + ".", ((String)object2).substring(string2.length()) + ".", 0);
            }
        }
        if ((object4 = sentence.getTables()) != null) {
            object3 = ((HashSet)object4).iterator();
            while (object3.hasNext()) {
                object2 = (DbTableOrView)object3.next();
                object = StringUtils.toUpperEnglish(((DbTableOrView)object2).name);
                if (hashSet.contains(object) || string2.length() != 0 && !((String)object).startsWith(string2) || string2.length() >= ((String)object).length()) continue;
                sentence.add((String)object + ".", ((String)object).substring(string2.length()) + ".", 0);
            }
        }
    }

    private void addNewTableAlias(Sentence sentence) {
        String string = sentence.query;
    }

    private void addSchema(Sentence sentence) {
        String string = sentence.query;
        String string2 = StringUtils.toUpperEnglish(string);
        if (string2.trim().length() == 0) {
            string2 = string2.trim();
        }
        DbSchema[] dbSchemaArray = this.contents.schemas;
        for (int i = 0; i < dbSchemaArray.length; ++i) {
            DbSchema dbSchema = dbSchemaArray[i];
            if (dbSchema == this.contents.defaultSchema || string2.length() != 0 && !StringUtils.toUpperEnglish(dbSchema.name).startsWith(string2) || string2.length() >= dbSchema.quotedName.length()) continue;
            sentence.add(dbSchema.quotedName + ".", dbSchema.quotedName.substring(string2.length()) + ".", 0);
        }
    }

    private void addTable(Sentence sentence) {
        String string;
        String string2 = sentence.query;
        DbSchema dbSchema = sentence.getLastMatchedSchema();
        if (dbSchema == null) {
            dbSchema = this.contents.defaultSchema;
        }
        if ((string = StringUtils.toUpperEnglish(string2)).trim().length() == 0) {
            string = string.trim();
        }
        DbTableOrView[] dbTableOrViewArray = dbSchema.tables;
        for (int i = 0; i < dbTableOrViewArray.length; ++i) {
            DbTableOrView dbTableOrView = dbTableOrViewArray[i];
            if (string.length() != 0 && !StringUtils.toUpperEnglish(dbTableOrView.name).startsWith(string) || string.length() >= dbTableOrView.quotedName.length()) continue;
            sentence.add(dbTableOrView.quotedName, dbTableOrView.quotedName.substring(string.length()), 0);
        }
    }

    private void addColumn(Sentence sentence) {
        String string;
        String string2 = string = sentence.query;
        String string3 = "";
        if (string.trim().length() == 0) {
            string2 = null;
            if (sentence.text.trim().endsWith(".")) {
                return;
            }
        } else {
            string2 = StringUtils.toUpperEnglish(string.trim());
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            } else {
                string3 = StringUtils.toUpperEnglish(string.trim());
                string2 = null;
            }
        }
        HashSet hashSet = null;
        HashMap hashMap = sentence.getAliases();
        if (string2 == null && sentence.getTables() != null) {
            hashSet = sentence.getTables();
        }
        DbTableOrView dbTableOrView = null;
        if (string2 != null && hashMap != null && hashMap.get(string2) != null) {
            dbTableOrView = (DbTableOrView)hashMap.get(string2);
            string2 = StringUtils.toUpperEnglish(dbTableOrView.name);
        }
        if (string2 == null) {
            if (hashSet == null && hashMap == null) {
                return;
            }
            if (hashSet != null && hashSet.size() > 1 || hashMap != null && hashMap.size() > 1) {
                return;
            }
        }
        if (dbTableOrView == null) {
            DbTableOrView[] dbTableOrViewArray = this.contents.defaultSchema.tables;
            for (int i = 0; i < dbTableOrViewArray.length; ++i) {
                DbTableOrView dbTableOrView2 = dbTableOrViewArray[i];
                String string4 = StringUtils.toUpperEnglish(dbTableOrView2.name);
                if (string2 != null && !string2.equals(string4) || hashSet != null && !hashSet.contains(dbTableOrView2)) continue;
                dbTableOrView = dbTableOrView2;
                break;
            }
        }
        if (dbTableOrView != null) {
            for (int i = 0; i < dbTableOrView.columns.length; ++i) {
                String string5 = dbTableOrView.columns[i].name;
                if (!StringUtils.toUpperEnglish(string5).startsWith(string3) || string3.length() >= string5.length()) continue;
                sentence.add(string5, string5.substring(string3.length()), 0);
            }
        }
    }

    public boolean matchRemove(Sentence sentence) {
        String string;
        if (sentence.query.length() == 0) {
            return false;
        }
        switch (this.type) {
            case 5: {
                string = this.matchSchema(sentence);
                break;
            }
            case 1: {
                string = this.matchTable(sentence);
                break;
            }
            case 3: {
                string = this.matchTableAlias(sentence, true);
                break;
            }
            case 2: {
                string = this.matchTableAlias(sentence, false);
                break;
            }
            case 4: {
                string = this.matchColumnAlias(sentence, false);
                break;
            }
            case 0: {
                string = this.matchColumn(sentence);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        if (string == null) {
            return false;
        }
        sentence.setQuery(string);
        return true;
    }

    public String matchSchema(Sentence sentence) {
        String string = sentence.query;
        String string2 = sentence.queryUpper;
        DbSchema[] dbSchemaArray = this.contents.schemas;
        String string3 = null;
        DbSchema dbSchema = null;
        for (int i = 0; i < dbSchemaArray.length; ++i) {
            DbSchema dbSchema2 = dbSchemaArray[i];
            String string4 = StringUtils.toUpperEnglish(dbSchema2.name);
            if (!string2.startsWith(string4) || string3 != null && string4.length() <= string3.length()) continue;
            string3 = string4;
            dbSchema = dbSchema2;
        }
        sentence.setLastMatchedSchema(dbSchema);
        if (string3 == null) {
            return null;
        }
        string = string.substring(string3.length());
        return string;
    }

    public String matchTable(Sentence sentence) {
        String string = sentence.query;
        String string2 = sentence.queryUpper;
        DbSchema dbSchema = sentence.getLastMatchedSchema();
        if (dbSchema == null) {
            dbSchema = this.contents.defaultSchema;
        }
        DbTableOrView[] dbTableOrViewArray = dbSchema.tables;
        String string3 = null;
        DbTableOrView dbTableOrView = null;
        for (int i = 0; i < dbTableOrViewArray.length; ++i) {
            DbTableOrView dbTableOrView2 = dbTableOrViewArray[i];
            String string4 = StringUtils.toUpperEnglish(dbTableOrView2.name);
            if (!string2.startsWith(string4) || string3 != null && string4.length() <= string3.length()) continue;
            string3 = string4;
            dbTableOrView = dbTableOrView2;
        }
        if (string3 == null) {
            return null;
        }
        sentence.addTable(dbTableOrView);
        string = string.substring(string3.length());
        return string;
    }

    public String matchColumnAlias(Sentence sentence, boolean bl) {
        char c;
        int n;
        String string = sentence.query;
        String string2 = sentence.queryUpper;
        if (string.indexOf(32) < 0) {
            return null;
        }
        for (n = 0; n < string2.length() && ((c = string2.charAt(n)) == '_' || Character.isLetterOrDigit(c)); ++n) {
        }
        if (n == 0) {
            return null;
        }
        String string3 = string2.substring(0, n);
        if (Parser.isKeyword(string3)) {
            return null;
        }
        return string.substring(string3.length());
    }

    public String matchTableAlias(Sentence sentence, boolean bl) {
        HashMap hashMap;
        char c;
        int n;
        String string = sentence.query;
        String string2 = sentence.queryUpper;
        if (string.indexOf(32) < 0) {
            return null;
        }
        for (n = 0; n < string2.length() && ((c = string2.charAt(n)) == '_' || Character.isLetterOrDigit(c)); ++n) {
        }
        if (n == 0) {
            return null;
        }
        String string3 = string2.substring(0, n);
        if (Parser.isKeyword(string3)) {
            return null;
        }
        if (bl) {
            sentence.addAlias(string3, sentence.getLastTable());
        }
        if ((hashMap = sentence.getAliases()) != null && hashMap.containsKey(string3) || sentence.getLastTable() == null) {
            if (bl && string.length() == string3.length()) {
                return string;
            }
            string = string.substring(string3.length());
            return string;
        }
        HashSet hashSet = sentence.getTables();
        if (hashSet != null) {
            String string4 = null;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                DbTableOrView dbTableOrView = (DbTableOrView)iterator.next();
                String string5 = StringUtils.toUpperEnglish(dbTableOrView.name);
                if (!string3.startsWith(string5) || string4 != null && string5.length() <= string4.length()) continue;
                sentence.setLastMatchedTable(dbTableOrView);
                string4 = string5;
            }
            if (string4 != null) {
                string = string.substring(string4.length());
                return string;
            }
        }
        return null;
    }

    public String matchColumn(Sentence sentence) {
        Object object;
        String string = sentence.query;
        String string2 = sentence.queryUpper;
        HashSet hashSet = sentence.getTables();
        Object object2 = null;
        DbTableOrView dbTableOrView = sentence.getLastMatchedTable();
        if (dbTableOrView != null && dbTableOrView.columns != null) {
            for (int i = 0; i < dbTableOrView.columns.length; ++i) {
                String string3 = StringUtils.toUpperEnglish(dbTableOrView.columns[i].name);
                if (!string2.startsWith(string3)) continue;
                object = string.substring(string3.length());
                if (object2 != null && ((String)object).length() >= ((String)object2).length()) continue;
                object2 = object;
            }
        }
        DbTableOrView[] dbTableOrViewArray = this.contents.defaultSchema.tables;
        for (int i = 0; i < dbTableOrViewArray.length; ++i) {
            object = dbTableOrViewArray[i];
            if (object != dbTableOrView && hashSet != null && !hashSet.contains(object) || object == null || ((DbTableOrView)object).columns == null) continue;
            for (int j = 0; j < ((DbTableOrView)object).columns.length; ++j) {
                String string4 = StringUtils.toUpperEnglish(((DbTableOrView)object).columns[j].name);
                if (!string2.startsWith(string4)) continue;
                String string5 = string.substring(string4.length());
                if (object2 != null && string5.length() >= ((String)object2).length()) continue;
                object2 = string5;
            }
        }
        return object2;
    }
}

