/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.SuspectEvent;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class GroupRequestTest
extends TestCase {
    Address a1;
    Address a2;
    Vector<Address> dests = null;

    public GroupRequestTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = new IpAddress("127.0.0.1", 1111);
        this.a2 = new IpAddress("127.0.0.1", 2222);
        this.dests = new Vector(2);
        this.dests.add(this.a1);
        this.dests.add(this.a2);
    }

    protected void tearDown() throws Exception {
        this.dests.clear();
        super.tearDown();
    }

    public void testMessageTimeout() throws Exception {
        this._testMessageTimeout(true);
    }

    public void testMessageReception() throws Exception {
        this._testMessageReception(true);
        this._testMessageReception(false);
    }

    public void testMessageReceptionWithSuspect() throws Exception {
        this._testMessageReceptionWithSuspect(true);
        this._testMessageReceptionWithSuspect(false);
    }

    public void testMessageReceptionWithViewChange() throws Exception {
        this._testMessageReceptionWithViewChange(true);
        this._testMessageReceptionWithViewChange(false);
    }

    public void testMessageReceptionWithViewChangeMemberLeft() throws Exception {
        this._testMessageReceptionWithViewChangeMemberLeft(true);
        this._testMessageReceptionWithViewChangeMemberLeft(false);
    }

    private void _testMessageTimeout(boolean async) throws Exception {
        int destCount = 10;
        long timeout = destCount * 300;
        long delay = 75L;
        Object[] responses = new Message[destCount];
        this.dests = new Vector();
        for (int i = 0; i < destCount; ++i) {
            IpAddress addr = new IpAddress("127.0.0.1", Integer.parseInt(String.valueOf(i) + i + i + i));
            this.dests.add(addr);
            responses[i] = new Message(null, (Address)addr, new Long(i));
        }
        MyDelayedTransport tp = new MyDelayedTransport(async, responses, 75L);
        GroupRequest req = new GroupRequest(new Message(), tp, this.dests, 2, timeout, this.dests.size());
        tp.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        GroupRequestTest.assertTrue((boolean)rc);
        GroupRequestTest.assertEquals((int)0, (int)req.getSuspects().size());
        GroupRequestTest.assertTrue((boolean)req.isDone());
        RspList results = req.getResults();
        GroupRequestTest.assertEquals((int)this.dests.size(), (int)results.size());
    }

    private void _testMessageReception(boolean async) throws Exception {
        Object[] responses = new Message[]{new Message(null, this.a1, new Long(1L)), new Message(null, this.a2, new Long(2L))};
        MyTransport transport = new MyTransport(async, responses);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, 2, 0L, 2);
        transport.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        GroupRequestTest.assertTrue((boolean)rc);
        GroupRequestTest.assertEquals((int)0, (int)req.getSuspects().size());
        GroupRequestTest.assertTrue((boolean)req.isDone());
        RspList results = req.getResults();
        GroupRequestTest.assertEquals((int)2, (int)results.size());
    }

    private void _testMessageReceptionWithSuspect(boolean async) throws Exception {
        Object[] responses = new Object[]{new Message(null, this.a1, new Long(1L)), new SuspectEvent(this.a2)};
        MyTransport transport = new MyTransport(async, responses);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, 2, 0L, 2);
        transport.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        GroupRequestTest.assertTrue((boolean)rc);
        GroupRequestTest.assertEquals((int)1, (int)req.getSuspects().size());
        GroupRequestTest.assertTrue((boolean)req.isDone());
        RspList results = req.getResults();
        GroupRequestTest.assertEquals((int)2, (int)results.size());
    }

    private void _testMessageReceptionWithViewChange(boolean async) throws Exception {
        Vector<Address> new_dests = new Vector<Address>();
        new_dests.add(this.a1);
        new_dests.add(this.a2);
        new_dests.add(new IpAddress("127.0.0.1", 3333));
        Object[] responses = new Object[]{new Message(null, this.a1, new Long(1L)), new View(new IpAddress("127.0.0.1", 9999), 322649L, new_dests), new Message(null, this.a2, new Long(2L))};
        MyTransport transport = new MyTransport(async, responses);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, 2, 0L, 2);
        transport.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        GroupRequestTest.assertTrue((boolean)rc);
        GroupRequestTest.assertEquals((String)("suspects are " + req.getSuspects()), (int)0, (int)req.getSuspects().size());
        GroupRequestTest.assertTrue((boolean)req.isDone());
        RspList results = req.getResults();
        GroupRequestTest.assertEquals((int)2, (int)results.size());
    }

    private void _testMessageReceptionWithViewChangeMemberLeft(boolean async) throws Exception {
        Vector<Address> new_dests = new Vector<Address>();
        new_dests.add(this.a2);
        Object[] responses = new Object[]{new Message(null, this.a2, new Long(1L)), new View(new IpAddress("127.0.0.1", 9999), 322649L, new_dests)};
        MyTransport transport = new MyTransport(async, responses);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, 2, 0L, 2);
        transport.setGroupRequest(req);
        System.out.println("group request before execution: " + req);
        boolean rc = req.execute();
        System.out.println("group request after execution: " + req);
        GroupRequestTest.assertTrue((boolean)rc);
        GroupRequestTest.assertEquals((String)("suspects are " + req.getSuspects()), (int)1, (int)req.getSuspects().size());
        GroupRequestTest.assertTrue((boolean)req.isDone());
        RspList results = req.getResults();
        GroupRequestTest.assertEquals((int)2, (int)results.size());
    }

    public static Test suite() {
        return new TestSuite(GroupRequestTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)GroupRequestTest.suite());
    }

    private static final class MyDelayedTransport
    extends MyTransport {
        long delay;

        public MyDelayedTransport(boolean async, Object[] responses) {
            super(async, responses);
        }

        public MyDelayedTransport(boolean async, Object[] responses, long delay) {
            super(async, responses);
            this.delay = delay;
        }

        void sendResponses() {
            if (this.responses != null) {
                for (int i = 0; i < this.responses.length; ++i) {
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    Object obj = this.responses[i];
                    if (obj == null) {
                        System.err.println("object was null");
                        continue;
                    }
                    if (obj instanceof Message) {
                        Message msg = (Message)obj;
                        Address sender = msg.getSrc();
                        Object retval = null;
                        try {
                            retval = Util.objectFromByteBuffer(msg.getBuffer());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.request.receiveResponse(retval, sender);
                        continue;
                    }
                    if (obj instanceof SuspectEvent) {
                        this.request.suspect((Address)((SuspectEvent)obj).getMember());
                        continue;
                    }
                    if (obj instanceof View) {
                        this.request.viewChange((View)obj);
                        continue;
                    }
                    System.err.println("Object needs to be Message, SuspectEvent or View");
                }
            }
        }
    }

    protected static class MyTransport
    implements Transport {
        GroupRequest request;
        boolean async = true;
        Object[] responses = null;

        public MyTransport(boolean async, Object[] responses) {
            this.async = async;
            this.responses = responses;
        }

        public void setGroupRequest(GroupRequest r) {
            this.request = r;
        }

        public void send(Message msg) throws Exception {
            if (this.async) {
                new Thread(){

                    public void run() {
                        MyTransport.this.sendResponses();
                    }
                }.start();
            } else {
                this.sendResponses();
            }
        }

        public Object receive(long timeout) throws Exception {
            return null;
        }

        void sendResponses() {
            if (this.responses != null) {
                for (int i = 0; i < this.responses.length; ++i) {
                    Object obj = this.responses[i];
                    if (obj == null) {
                        System.err.println("object was null");
                        continue;
                    }
                    if (obj instanceof Message) {
                        Message msg = (Message)obj;
                        Address sender = msg.getSrc();
                        Object retval = null;
                        try {
                            retval = Util.objectFromByteBuffer(msg.getBuffer());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.request.receiveResponse(retval, sender);
                        continue;
                    }
                    if (obj instanceof SuspectEvent) {
                        this.request.suspect((Address)((SuspectEvent)obj).getMember());
                        continue;
                    }
                    if (obj instanceof View) {
                        this.request.viewChange((View)obj);
                        continue;
                    }
                    System.err.println("Object needs to be Message, SuspectEvent or View");
                }
            }
        }
    }
}

