/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.Global;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.mux.MuxChannel;
import org.jgroups.mux.MuxHeader;
import org.jgroups.mux.ServiceInfo;
import org.jgroups.protocols.pbcast.FLUSH;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.FIFOMessageQueue;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multiplexer
implements UpHandler {
    private final ConcurrentMap<String, MuxChannel> services = new ConcurrentHashMap<String, MuxChannel>();
    private final JChannel channel;
    static final Log log = LogFactory.getLog(Multiplexer.class);
    static final String SEPARATOR = "::";
    static final short SEPARATOR_LEN = (short)"::".length();
    static final String NAME = "MUX";
    private boolean flush_present = true;
    private boolean blocked = false;
    private ExecutorService thread_pool;
    private FIFOMessageQueue<String, Runnable> fifo_queue = new FIFOMessageQueue();
    View view = null;
    Address local_addr = null;
    private final Map<String, Boolean> state_transfer_listeners = new HashMap<String, Boolean>();
    private final Map<String, List<Address>> service_state = new HashMap<String, List<Address>>();
    private final Promise service_state_promise = new Promise();
    private final Map<Address, Set<String>> service_responses = new HashMap<Address, Set<String>>();
    private long SERVICES_RSP_TIMEOUT = 10000L;

    public Multiplexer() {
        this.channel = null;
        this.flush_present = this.isFlushPresent();
        if (Global.getPropertyAsBoolean("jgroups.mux.enabled", true)) {
            this.thread_pool = Multiplexer.createThreadPool();
        }
    }

    public Multiplexer(JChannel channel) {
        this.channel = channel;
        this.channel.setUpHandler(this);
        this.channel.setOpt(0, Boolean.TRUE);
        this.flush_present = this.isFlushPresent();
        if (Global.getPropertyAsBoolean("jgroups.mux.enabled", true)) {
            this.thread_pool = Multiplexer.createThreadPool();
        }
    }

    public Set getApplicationIds() {
        return this.services != null ? Collections.unmodifiableSet(this.services.keySet()) : null;
    }

    public Set<String> getServiceIds() {
        return this.services != null ? Collections.unmodifiableSet(this.services.keySet()) : null;
    }

    public long getServicesResponseTimeout() {
        return this.SERVICES_RSP_TIMEOUT;
    }

    public void setServicesResponseTimeout(long services_rsp_timeout) {
        this.SERVICES_RSP_TIMEOUT = services_rsp_timeout;
    }

    public View getServiceView(String service_id) {
        List<Address> hosts = this.service_state.get(service_id);
        if (hosts == null) {
            return null;
        }
        return this.generateServiceView(hosts);
    }

    public boolean stateTransferListenersPresent() {
        return this.state_transfer_listeners != null && !this.state_transfer_listeners.isEmpty();
    }

    public synchronized void registerForStateTransfer(String appl_id, String substate_id) {
        String key = appl_id;
        if (substate_id != null && substate_id.length() > 0) {
            key = key + SEPARATOR + substate_id;
        }
        this.state_transfer_listeners.put(key, Boolean.FALSE);
    }

    public synchronized boolean getState(Address target, String id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        Collection<Boolean> values;
        boolean all_true;
        if (this.state_transfer_listeners.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Boolean> entry : this.state_transfer_listeners.entrySet()) {
            boolean match;
            String key = entry.getKey();
            int index = key.indexOf(SEPARATOR);
            if (index > -1) {
                String tmp = key.substring(0, index);
                match = id.equals(tmp);
            } else {
                match = id.equals(key);
            }
            if (!match) continue;
            entry.setValue(Boolean.TRUE);
            break;
        }
        if (!(all_true = Util.all(values = this.state_transfer_listeners.values(), Boolean.TRUE))) {
            return true;
        }
        boolean rc = false;
        HashSet<String> keys = new HashSet<String>(this.state_transfer_listeners.keySet());
        rc = this.fetchServiceStates(target, keys, timeout);
        this.state_transfer_listeners.clear();
        return rc;
    }

    protected static ThreadPoolExecutor createThreadPool() {
        int min_threads = 1;
        int max_threads = 4;
        long keep_alive = 30000L;
        ThreadFactory factory = new ThreadFactory(){
            AtomicInteger num = new AtomicInteger(1);
            ThreadGroup mux_threads = new ThreadGroup(Util.getGlobalThreadGroup(), "MultiplexerThreads");

            public Thread newThread(Runnable command) {
                Thread ret = new Thread(this.mux_threads, command, "Multiplexer-" + this.num.incrementAndGet());
                ret.setDaemon(true);
                return ret;
            }
        };
        min_threads = Global.getPropertyAsInteger("jgroups.mux.min_threads", min_threads);
        max_threads = Global.getPropertyAsInteger("jgroups.mux.max_threads", max_threads);
        keep_alive = Global.getPropertyAsLong("jgroups.mux.keepalive_time", keep_alive);
        return new ThreadPoolExecutor(min_threads, max_threads, keep_alive, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), factory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected void shutdownThreadPool() {
        if (this.thread_pool != null && !this.thread_pool.isShutdown()) {
            this.thread_pool.shutdownNow();
            try {
                this.thread_pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean fetchServiceStates(Address target, Set<String> keys, long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        boolean all_rcs = true;
        for (String stateId : keys) {
            boolean rc = this.channel.getState(target, stateId, timeout);
            if (rc) continue;
            all_rcs = false;
        }
        return all_rcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchServiceInformation() throws Exception {
        while (true) {
            boolean is_coord;
            Address coord = this.getCoordinator();
            Address local_address = this.channel != null ? this.channel.getLocalAddress() : null;
            boolean bl = is_coord = coord != null && local_address != null && local_address.equals(coord);
            if (is_coord) {
                if (!log.isTraceEnabled()) break;
                log.trace((Object)"I'm coordinator, will not fetch service state information");
                break;
            }
            ServiceInfo si = new ServiceInfo(1, null, null, null);
            MuxHeader hdr = new MuxHeader(si);
            Message state_req = new Message(coord, null, null);
            state_req.putHeader(NAME, hdr);
            this.service_state_promise.reset();
            this.channel.send(state_req);
            try {
                byte[] state = (byte[])this.service_state_promise.getResultWithTimeout(2000L);
                if (state != null) {
                    Map new_state = (Map)Util.objectFromByteBuffer(state);
                    Map<String, List<Address>> map = this.service_state;
                    synchronized (map) {
                        this.service_state.clear();
                        this.service_state.putAll(new_state);
                    }
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)("service state was set successfully (" + this.service_state.size() + " entries)"));
                    break;
                }
                if (!log.isWarnEnabled()) break;
                log.warn((Object)"received service state was null");
            }
            catch (TimeoutException e) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("timed out waiting for service state from " + coord + ", retrying"));
                continue;
            }
            break;
        }
    }

    public void sendServiceUpMessage(String service, Address host, boolean bypassFlush) throws Exception {
        this.sendServiceMessage((byte)3, service, host, bypassFlush, null);
        if (this.local_addr != null && host != null && this.local_addr.equals(host)) {
            this.handleServiceUp(service, host, false);
        }
    }

    public void sendServiceDownMessage(String service, Address host, boolean bypassFlush) throws Exception {
        this.sendServiceMessage((byte)4, service, host, bypassFlush, null);
        if (this.local_addr != null && host != null && this.local_addr.equals(host)) {
            this.handleServiceDown(service, host, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                MuxHeader hdr = (MuxHeader)msg.getHeader(NAME);
                if (hdr == null) {
                    log.error((Object)("MuxHeader not present - discarding message " + msg));
                    return null;
                }
                Address sender = msg.getSrc();
                if (hdr.info != null) {
                    try {
                        this.handleServiceStateRequest(hdr.info, sender);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break;
                        log.error((Object)"failure in handling service state request", (Throwable)e);
                    }
                    break;
                }
                MuxChannel mux_ch = (MuxChannel)this.services.get(hdr.id);
                if (mux_ch == null) {
                    log.warn((Object)("service " + hdr.id + " not currently running, discarding message " + msg));
                    return null;
                }
                return this.passToMuxChannel(mux_ch, evt, this.fifo_queue, sender, hdr.id, false);
            }
            case 6: {
                Vector<Address> old_members = this.view != null ? this.view.getMembers() : null;
                this.view = (View)evt.getArg();
                Vector<Address> new_members = this.view != null ? this.view.getMembers() : null;
                Vector<Address> left_members = Util.determineLeftMembers(old_members, new_members);
                if (this.view instanceof MergeView) {
                    final MergeView temp_merge_view = (MergeView)this.view.clone();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("received a MergeView: " + temp_merge_view + ", adjusting the service view"));
                    }
                    try {
                        Thread merge_handler = new Thread(){

                            public void run() {
                                block2: {
                                    try {
                                        Multiplexer.this.handleMergeView(temp_merge_view);
                                    }
                                    catch (Exception e) {
                                        if (!log.isErrorEnabled()) break block2;
                                        log.error((Object)"problems handling merge view", (Throwable)e);
                                    }
                                }
                            }
                        };
                        merge_handler.setName("merge handler view_change");
                        merge_handler.setDaemon(false);
                        merge_handler.start();
                    }
                    catch (Exception e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"failed handling merge view", (Throwable)e);
                        }
                    }
                } else {
                    Map<Address, Set<String>> temp_merge_view = this.service_responses;
                    synchronized (temp_merge_view) {
                        this.service_responses.clear();
                    }
                }
                if (left_members.isEmpty()) break;
                this.adjustServiceViews(left_members);
                break;
            }
            case 9: {
                Address suspected_mbr = (Address)evt.getArg();
                Map<Address, Set<String>> map = this.service_responses;
                synchronized (map) {
                    this.service_responses.put(suspected_mbr, null);
                    this.service_responses.notifyAll();
                }
                this.passToAllMuxChannels(evt);
                break;
            }
            case 17: 
            case 72: {
                return this.handleStateRequest(evt);
            }
            case 20: 
            case 71: {
                this.handleStateResponse(evt);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.passToAllMuxChannels(evt);
                break;
            }
            case 10: {
                this.blocked = true;
                if (!this.services.isEmpty()) {
                    this.passToAllMuxChannels(evt, true, true);
                }
                this.waitUntilThreadPoolHasNoRunningTasks(1000L);
                return null;
            }
            case 75: {
                if (this.blocked) {
                    this.blocked = false;
                }
                this.passToAllMuxChannels(evt);
                break;
            }
            default: {
                this.passToAllMuxChannels(evt);
            }
        }
        return null;
    }

    private int waitUntilThreadPoolHasNoRunningTasks(long timeout) {
        int num_threads = 0;
        long end_time = System.currentTimeMillis() + timeout;
        while (this.fifo_queue != null && (num_threads = this.fifo_queue.size()) > 0 && System.currentTimeMillis() < end_time) {
            Util.sleep(100L);
        }
        return num_threads;
    }

    public Channel createMuxChannel(JChannelFactory f, String id, String stack_name) throws Exception {
        if (this.services.containsKey(id)) {
            throw new Exception("service ID \"" + id + "\" is already registered, cannot register duplicate ID");
        }
        MuxChannel ch = new MuxChannel(f, this.channel, id, stack_name, this);
        this.services.put(id, ch);
        return ch;
    }

    private void passToAllMuxChannels(Event evt) {
        this.passToAllMuxChannels(evt, false, true);
    }

    private void passToAllMuxChannels(Event evt, boolean block, boolean bypass_thread_pool) {
        for (Map.Entry entry : this.services.entrySet()) {
            String service_name = (String)entry.getKey();
            MuxChannel ch = (MuxChannel)entry.getValue();
            this.passToMuxChannel(ch, evt, this.fifo_queue, null, service_name, block, bypass_thread_pool);
        }
    }

    public MuxChannel remove(String id) {
        return (MuxChannel)this.services.remove(id);
    }

    public void disconnect() {
        boolean all_disconnected = true;
        for (MuxChannel mux_ch : this.services.values()) {
            if (!mux_ch.isConnected()) continue;
            all_disconnected = false;
            break;
        }
        if (all_disconnected) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"disconnecting underlying JChannel as all MuxChannels are disconnected");
            }
            this.channel.disconnect();
        }
    }

    public void unregister(String appl_id) {
        this.services.remove(appl_id);
    }

    public boolean close() {
        boolean all_closed = true;
        for (MuxChannel mux_ch : this.services.values()) {
            if (!mux_ch.isOpen()) continue;
            all_closed = false;
            break;
        }
        if (all_closed) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"closing underlying JChannel as all MuxChannels are closed");
            }
            this.channel.close();
            this.services.clear();
            this.shutdownThreadPool();
        }
        return all_closed;
    }

    public void closeAll() {
        for (MuxChannel mux_ch : this.services.values()) {
            mux_ch.setConnected(false);
            mux_ch.setClosed(true);
            mux_ch.closeMessageQueue(true);
        }
        this.shutdownThreadPool();
    }

    public boolean shutdown() {
        boolean all_closed = true;
        for (MuxChannel mux_ch : this.services.values()) {
            if (!mux_ch.isOpen()) continue;
            all_closed = false;
            break;
        }
        if (all_closed) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"shutting down underlying JChannel as all MuxChannels are closed");
            }
            this.channel.shutdown();
            this.services.clear();
            this.shutdownThreadPool();
        }
        return all_closed;
    }

    private boolean isFlushPresent() {
        return this.channel.getProtocolStack().findProtocol("FLUSH") != null;
    }

    private void sendServiceState() throws Exception {
        byte[] data = Util.objectToByteBuffer(new HashSet(this.services.keySet()));
        this.sendServiceMessage((byte)5, null, this.channel.getLocalAddress(), true, data);
    }

    private Address getLocalAddress() {
        if (this.local_addr != null) {
            return this.local_addr;
        }
        if (this.channel != null) {
            this.local_addr = this.channel.getLocalAddress();
        }
        return this.local_addr;
    }

    private Address getCoordinator() {
        Vector<Address> members;
        View v;
        if (this.channel != null && (v = this.channel.getView()) != null && (members = v.getMembers()) != null && !members.isEmpty()) {
            return members.firstElement();
        }
        return null;
    }

    public Address getStateProvider(Address preferredTarget, String service_id) {
        Address result = null;
        List<Address> hosts = this.service_state.get(service_id);
        if (hosts != null && !hosts.isEmpty()) {
            result = hosts.contains(preferredTarget) ? preferredTarget : hosts.get(0);
        }
        return result;
    }

    private void sendServiceMessage(byte type, String service, Address host, boolean bypassFlush, byte[] payload) throws Exception {
        if (host == null) {
            host = this.getLocalAddress();
        }
        if (host == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("local_addr is null, cannot send ServiceInfo." + ServiceInfo.typeToString(type) + " message"));
            }
            return;
        }
        ServiceInfo si = new ServiceInfo(type, service, host, payload);
        MuxHeader hdr = new MuxHeader(si);
        Message service_msg = new Message();
        service_msg.putHeader(NAME, hdr);
        if (bypassFlush && this.flush_present) {
            service_msg.putHeader("FLUSH", new FLUSH.FlushHeader(6));
        }
        this.channel.send(service_msg);
    }

    private Object handleStateRequest(Event evt) {
        String id;
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        String original_id = id = info.state_id;
        Address requester = info.target;
        try {
            int index = id.indexOf(SEPARATOR);
            if (index > -1) {
                info.state_id = id.substring(index + SEPARATOR_LEN);
                id = id.substring(0, index);
            } else {
                info.state_id = null;
            }
            MuxChannel mux_ch = (MuxChannel)this.services.get(id);
            if (mux_ch == null) {
                throw new IllegalArgumentException("didn't find service with ID=" + id + " to fetch state from");
            }
            StateTransferInfo ret = (StateTransferInfo)this.passToMuxChannel(mux_ch, evt, this.fifo_queue, requester, id, true);
            if (ret != null) {
                ret.state_id = original_id;
            }
            return ret;
        }
        catch (Throwable ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"failed returning the application state, will return null", ex);
            }
            return new StateTransferInfo(null, original_id, 0L, null);
        }
    }

    private void handleStateResponse(Event evt) {
        String substate_id;
        String appl_id;
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        Address state_sender = info.target;
        String tmp = info.state_id;
        if (tmp == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("state is null, not passing up: " + info));
            }
            return;
        }
        int index = tmp.indexOf(SEPARATOR);
        if (index > -1) {
            appl_id = tmp.substring(0, index);
            substate_id = tmp.substring(index + SEPARATOR_LEN);
        } else {
            appl_id = tmp;
            substate_id = null;
        }
        MuxChannel mux_ch = (MuxChannel)this.services.get(appl_id);
        if (mux_ch == null) {
            log.error((Object)("didn't find service with ID=" + appl_id + " to fetch state from"));
        } else {
            StateTransferInfo tmp_info = info.copy();
            tmp_info.state_id = substate_id;
            Event tmpEvt = new Event(evt.getType(), tmp_info);
            this.passToMuxChannel(mux_ch, tmpEvt, this.fifo_queue, state_sender, appl_id, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceStateRequest(ServiceInfo info, Address sender) throws Exception {
        switch (info.type) {
            case 1: {
                byte[] state;
                Map<String, List<Address>> map = this.service_state;
                synchronized (map) {
                    state = Util.objectToByteBuffer(this.service_state);
                }
                ServiceInfo si = new ServiceInfo(2, null, null, state);
                MuxHeader hdr = new MuxHeader(si);
                Message state_rsp = new Message(sender);
                state_rsp.putHeader(NAME, hdr);
                this.channel.send(state_rsp);
                break;
            }
            case 2: {
                this.service_state_promise.setResult(info.state);
                break;
            }
            case 3: {
                this.handleServiceUp(info.service, info.host, true);
                break;
            }
            case 4: {
                this.handleServiceDown(info.service, info.host, true);
                break;
            }
            case 5: {
                this.handleServicesRsp(sender, info.state);
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)("service request type " + info.type + " not known"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServicesRsp(Address sender, byte[] state) throws Exception {
        Set s = (Set)Util.objectFromByteBuffer(state);
        Map<Address, Set<String>> map = this.service_responses;
        synchronized (map) {
            Set<String> tmp = this.service_responses.get(sender);
            if (tmp == null) {
                tmp = new HashSet<String>();
            }
            tmp.addAll(s);
            this.service_responses.put(sender, tmp);
            if (log.isTraceEnabled()) {
                log.trace((Object)("received service response: " + sender + "(" + s.toString() + ")"));
            }
            this.service_responses.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceDown(String service, Address host, boolean received) {
        Address local_address;
        View service_view;
        ArrayList<Address> hosts_copy;
        boolean removed = false;
        if (received && host != null && this.local_addr != null && this.local_addr.equals(host)) {
            return;
        }
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            List<Address> hosts = this.service_state.get(service);
            if (hosts == null) {
                return;
            }
            removed = hosts.remove(host);
            hosts_copy = new ArrayList<Address>(hosts);
        }
        if (removed && (service_view = this.generateServiceView(hosts_copy)) != null) {
            MuxChannel ch = (MuxChannel)this.services.get(service);
            if (ch != null) {
                Event view_evt = new Event(6, service_view);
                if (ch.isConnected()) {
                    this.passToMuxChannel(ch, view_evt, this.fifo_queue, null, service, false);
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("service " + service + " not found, cannot dispatch service view " + service_view));
            }
        }
        if ((local_address = this.getLocalAddress()) != null && host != null && host.equals(local_address)) {
            this.unregister(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceUp(String service, Address host, boolean received) {
        View service_view;
        ArrayList<Address> hosts_copy;
        boolean added = false;
        if (received && host != null && this.local_addr != null && this.local_addr.equals(host)) {
            return;
        }
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            List<Address> hosts = this.service_state.get(service);
            if (hosts == null) {
                hosts = new ArrayList<Address>();
                this.service_state.put(service, hosts);
            }
            if (!hosts.contains(host)) {
                hosts.add(host);
                added = true;
            }
            hosts_copy = new ArrayList<Address>(hosts);
        }
        if (added && (service_view = this.generateServiceView(hosts_copy)) != null) {
            MuxChannel ch = (MuxChannel)this.services.get(service);
            if (ch != null) {
                Event view_evt = new Event(6, service_view);
                this.passToMuxChannel(ch, view_evt, this.fifo_queue, null, service, false);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("service " + service + " not found, cannot dispatch service view " + service_view));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMergeView(MergeView view) throws Exception {
        int num_members = view.size();
        HashMap<Address, Set<String>> copy = null;
        this.sendServiceState();
        Map<Address, Set<String>> map = this.service_responses;
        synchronized (map) {
            block7: {
                long start = System.currentTimeMillis();
                try {
                    for (long time_to_wait = this.SERVICES_RSP_TIMEOUT; time_to_wait > 0L && Multiplexer.numResponses(this.service_responses) < num_members; time_to_wait -= System.currentTimeMillis() - start) {
                        this.service_responses.wait(time_to_wait);
                    }
                    copy = new HashMap<Address, Set<String>>(this.service_responses);
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)("failed fetching a list of services from other members in the cluster, cannot handle merge view " + view), (Throwable)ex);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("merging service state, my service_state: " + this.service_state + ", received responses: " + copy));
        }
        this.mergeServiceState(view, copy);
        this.service_responses.clear();
    }

    private static int numResponses(Map m) {
        int num = 0;
        Collection values = m.values();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            if (it.next() == null) continue;
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeServiceState(MergeView view, Map<Address, Set<String>> copy) {
        HashSet<String> modified_services = new HashSet<String>();
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            for (Map.Entry<Address, Set<String>> entry : copy.entrySet()) {
                Address host = entry.getKey();
                Set<String> service_list = entry.getValue();
                if (service_list == null) continue;
                for (String service : service_list) {
                    boolean was_modified;
                    List<Address> my_services = this.service_state.get(service);
                    if (my_services == null) {
                        my_services = new ArrayList<Address>();
                        this.service_state.put(service, my_services);
                    }
                    if (!(was_modified = my_services.add(host))) continue;
                    modified_services.add(service);
                }
            }
        }
        for (String service : modified_services) {
            MuxChannel ch = (MuxChannel)this.services.get(service);
            List<Address> hosts = this.service_state.get(service);
            Vector<Address> membersCopy = new Vector<Address>(view.getMembers());
            membersCopy.retainAll(hosts);
            MergeView v = new MergeView(view.getVid(), membersCopy, view.getSubgroups());
            this.passToMuxChannel(ch, new Event(6, v), this.fifo_queue, null, service, false);
        }
    }

    private void adjustServiceViews(Vector left_members) {
        if (left_members != null) {
            for (int i = 0; i < left_members.size(); ++i) {
                try {
                    this.adjustServiceView((Address)left_members.elementAt(i));
                    continue;
                }
                catch (Throwable t) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"failed adjusting service views", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustServiceView(Address host) {
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            for (Map.Entry<String, List<Address>> entry : this.service_state.entrySet()) {
                Address local_address;
                View service_view;
                String service = entry.getKey();
                List<Address> hosts = entry.getValue();
                if (hosts == null) continue;
                if (hosts.remove(host) && (service_view = this.generateServiceView(new ArrayList<Address>(hosts))) != null) {
                    MuxChannel ch = (MuxChannel)this.services.get(service);
                    if (ch != null) {
                        Event view_evt = new Event(6, service_view);
                        if (ch.isConnected()) {
                            this.passToMuxChannel(ch, view_evt, this.fifo_queue, null, service, false);
                        }
                    } else if (log.isTraceEnabled()) {
                        log.trace((Object)("service " + service + " not found, cannot dispatch service view " + service_view));
                    }
                }
                if ((local_address = this.getLocalAddress()) == null || host == null || !host.equals(local_address)) continue;
                this.unregister(service);
            }
        }
    }

    private View generateServiceView(List hosts) {
        Vector<Address> members = new Vector<Address>(this.view.getMembers());
        members.retainAll(hosts);
        return new View(this.view.getVid(), members);
    }

    private Object passToMuxChannel(MuxChannel ch, Event evt, FIFOMessageQueue<String, Runnable> queue, Address sender, String dest, boolean block) {
        return this.passToMuxChannel(ch, evt, queue, sender, dest, block, false);
    }

    private Object passToMuxChannel(MuxChannel ch, Event evt, FIFOMessageQueue<String, Runnable> queue, Address sender, String dest, boolean block, boolean bypass_thread_pool) {
        if (this.thread_pool == null || bypass_thread_pool) {
            return ch.up(evt);
        }
        Task task = new Task(ch, evt, queue, sender, dest, block);
        ExecuteTask execute_task = new ExecuteTask(this.fifo_queue);
        try {
            this.fifo_queue.put(sender, dest, task);
            this.thread_pool.execute(execute_task);
            if (block) {
                try {
                    return task.exchanger.exchange(null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public void addServiceIfNotPresent(String id, MuxChannel ch) {
        this.services.putIfAbsent(id, ch);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecuteTask
    implements Runnable {
        FIFOMessageQueue<String, Runnable> queue;

        public ExecuteTask(FIFOMessageQueue<String, Runnable> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                Runnable task = this.queue.take();
                task.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Task
    implements Runnable {
        Exchanger<Object> exchanger;
        MuxChannel channel;
        Event evt;
        FIFOMessageQueue<String, Runnable> queue;
        Address sender;
        String dest;

        Task(MuxChannel channel, Event evt, FIFOMessageQueue<String, Runnable> queue, Address sender, String dest, boolean result_expected) {
            this.channel = channel;
            this.evt = evt;
            this.queue = queue;
            this.sender = sender;
            this.dest = dest;
            if (result_expected) {
                this.exchanger = new Exchanger();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object retval = this.channel.up(this.evt);
                if (this.exchanger != null) {
                    this.exchanger.exchange(retval);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.queue.done(this.sender, this.dest);
            }
        }
    }
}

