/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.GossipClient;
import org.jgroups.stack.IpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPGOSSIP
extends Discovery {
    Vector initial_hosts = null;
    GossipClient gossip_client = null;
    long gossip_refresh_rate = 20000L;
    static final Vector EMPTY_VECTOR = new Vector();
    static final String name = "TCPGOSSIP";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("gossip_refresh_rate");
        if (str != null) {
            this.gossip_refresh_rate = Integer.parseInt(str);
            props.remove("gossip_refresh_rate");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            try {
                this.initial_hosts = this.createInitialHosts(str);
            }
            catch (UnknownHostException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"failed creating initial hosts", (Throwable)ex);
                }
                return false;
            }
        }
        if (this.initial_hosts == null || this.initial_hosts.isEmpty()) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"initial_hosts must contain the address of at least one GossipRouter");
            }
            return false;
        }
        return super.setProperties(props);
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.gossip_client == null) {
            this.gossip_client = new GossipClient(this.initial_hosts, this.gossip_refresh_rate);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.gossip_client != null) {
            this.gossip_client.stop();
            this.gossip_client = null;
        }
    }

    @Override
    public void destroy() {
        if (this.gossip_client != null) {
            this.gossip_client.destroy();
            this.gossip_client = null;
        }
    }

    @Override
    public void handleConnect() {
        if (this.group_addr == null || this.local_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"group_addr or local_addr is null, cannot register with GossipRouter(s)");
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("registering " + this.local_addr + " under " + this.group_addr + " with GossipRouter"));
            }
            this.gossip_client.register(this.group_addr, this.local_addr);
        }
    }

    @Override
    public void sendGetMembersRequest() {
        List tmp_mbrs;
        if (this.group_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"[FIND_INITIAL_MBRS]: group_addr is null, cannot get mbrship");
            }
            this.up_prot.up(new Event(13, EMPTY_VECTOR));
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"fetching members from GossipRouter(s)");
        }
        if ((tmp_mbrs = this.gossip_client.getMembers(this.group_addr)) == null || tmp_mbrs.isEmpty()) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"[FIND_INITIAL_MBRS]: gossip client found no members");
            }
            this.up_prot.up(new Event(13, EMPTY_VECTOR));
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("consolidated mbrs from GossipRouter(s) are " + tmp_mbrs));
        }
        PingHeader hdr = new PingHeader(1, null);
        Message msg = new Message(null);
        msg.setFlag((byte)1);
        msg.putHeader(name, hdr);
        for (Address mbr_addr : tmp_mbrs) {
            Message copy = msg.copy();
            copy.setDest(mbr_addr);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("[FIND_INITIAL_MBRS] sending PING request to " + copy.getDest()));
            }
            this.down_prot.down(new Event(1, copy));
        }
    }

    private Vector<Address> createInitialHosts(String l) throws UnknownHostException {
        Vector<Address> tmp = new Vector<Address>();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                int port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                IpAddress addr = new IpAddress(host, port);
                tmp.addElement(addr);
            }
            catch (NumberFormatException e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exeption is " + e));
            }
        }
        return tmp;
    }
}

