/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Message;
import org.jgroups.stack.NakReceiverWindow;

public class NakReceiverWindowTest
extends TestCase {
    public NakReceiverWindowTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void test1() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 0L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 0L ? 1 : 0) != 0);
    }

    public void test2() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 100L);
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 0L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 0L ? 1 : 0) != 0);
    }

    public void test3() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(1L, new Message());
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 1L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 1L ? 1 : 0) != 0);
        win.add(2L, new Message());
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 1L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 2L ? 1 : 0) != 0);
    }

    public void test4() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(2L, new Message());
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 0L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 0L ? 1 : 0) != 0);
    }

    public void test5() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 100L);
        win.add(101L, new Message());
        win.add(100L, new Message());
        NakReceiverWindowTest.assertEquals((long)100L, (long)win.getLowestSeen());
        NakReceiverWindowTest.assertEquals((long)101L, (long)win.getHighestSeen());
    }

    public void test6() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 100L);
        win.add(101L, new Message());
        win.add(100L, new Message());
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 100L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 101L ? 1 : 0) != 0);
    }

    public void test7() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        win.stable(4L);
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 1L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 4L ? 1 : 0) != 0);
    }

    public void test8() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        win.add(6L, new Message());
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 4L ? 1 : 0) != 0);
    }

    public void test9() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        win.add(6L, new Message());
        while (win.remove() != null) {
        }
        win.stable(6L);
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 4L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 4L ? 1 : 0) != 0);
    }

    public void test10() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 1L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 4L ? 1 : 0) != 0);
    }

    public void test10a() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        while (win.remove() != null) {
        }
        win.stable(4L);
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 4L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 4L ? 1 : 0) != 0);
    }

    public void test11() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        while (win.remove() != null) {
        }
        win.reset();
        NakReceiverWindowTest.assertTrue((win.getLowestSeen() == 0L ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue((win.getHighestSeen() == 0L ? 1 : 0) != 0);
    }

    public void test12() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(1L, new Message(null, null, new Integer(1)));
        win.add(2L, new Message(null, null, new Integer(2)));
        win.add(3L, new Message(null, null, new Integer(3)));
        NakReceiverWindowTest.assertTrue(((Integer)win.remove().getObject() == 1 ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue(((Integer)win.remove().getObject() == 2 ? 1 : 0) != 0);
        NakReceiverWindowTest.assertTrue(((Integer)win.remove().getObject() == 3 ? 1 : 0) != 0);
    }

    public void test13() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        NakReceiverWindowTest.assertEquals((long)1L, (long)win.getLowestSeen());
        NakReceiverWindowTest.assertEquals((long)4L, (long)win.getHighestSeen());
        win.remove();
        win.remove();
        win.add(5L, new Message());
        win.add(6L, new Message());
        NakReceiverWindowTest.assertEquals((long)1L, (long)win.getLowestSeen());
        NakReceiverWindowTest.assertEquals((long)6L, (long)win.getHighestSeen());
        win.stable(2L);
        NakReceiverWindowTest.assertEquals((long)2L, (long)win.getLowestSeen());
    }

    public void testUpdateHighestSeen() {
        this.add(1000);
        this.add(2000);
        this.add(3000);
        this.add(4000);
        this.add(5000);
        this.add(10000);
        this.add(15000);
        this.add(20000);
        this.add(30000);
    }

    public void test1000() {
        this.add(1000);
    }

    public void test10000() {
        this.add(10000);
    }

    void add(int num_msgs) {
        NakReceiverWindow win = new NakReceiverWindow(null, 1L);
        long start = System.currentTimeMillis();
        for (int i = 1; i < 1 + num_msgs; ++i) {
            win.add(i, new Message());
        }
        long stop = System.currentTimeMillis();
        double time_per_msg = (double)(stop - start) / (double)num_msgs;
        System.out.println("-- time for " + num_msgs + " msgs: " + (stop - start) + ", " + time_per_msg + " ms/msg");
    }

    public static Test suite() {
        TestSuite s = new TestSuite(NakReceiverWindowTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)NakReceiverWindowTest.suite());
    }
}

