/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.osgi;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.persistence.Persistence;
import javax.persistence.osgi.ProviderTrackerCustomizer;
import javax.persistence.spi.PersistenceProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
Persistence.ProviderResolver {
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    private BundleContext ctx;
    private ServiceTracker serviceTracker;

    public void start(BundleContext context) throws Exception {
        this.log("Persistence bundle starting...");
        this.ctx = context;
        Persistence.setProviderResolver(this);
        ProviderTrackerCustomizer customizer = new ProviderTrackerCustomizer(this.ctx);
        this.serviceTracker = new ServiceTracker(this.ctx, PERSISTENCE_PROVIDER, (ServiceTrackerCustomizer)customizer);
        this.serviceTracker.open();
        this.log("Persistence bundle started.");
    }

    public void stop(BundleContext context) throws Exception {
        this.log("Persistence bundle stopping...");
        this.serviceTracker.close();
        this.serviceTracker = null;
        Persistence.resetProviders();
        this.log("Persistence bundle stopped.");
    }

    @Override
    public Collection<PersistenceProvider> findAllProviders() throws IOException {
        this.log("OSGi - Find all providers.");
        HashSet<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
        ServiceReference[] refs = null;
        try {
            refs = this.ctx.getServiceReferences(PERSISTENCE_PROVIDER, null);
        }
        catch (InvalidSyntaxException invEx) {
            // empty catch block
        }
        if (refs != null) {
            for (ServiceReference ref : refs) {
                providers.add((PersistenceProvider)this.ctx.getService(ref));
            }
        }
        return providers;
    }

    private void log(String message) {
        System.out.println(message);
    }
}

