/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class UtilTest
extends TestCase {
    public UtilTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testWriteStreamable() throws IOException, IllegalAccessException, InstantiationException {
        Message m = new Message(null, null, (Serializable)((Object)"Hello"));
        ViewId vid = new ViewId(null, 12345L);
        ViewId vid2 = new ViewId(new IpAddress("127.0.0.1", 5555), 35623L);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeGenericStreamable(m, dos);
        Util.writeGenericStreamable(vid, dos);
        Util.writeGenericStreamable(vid2, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        Message m2 = (Message)Util.readGenericStreamable(dis);
        ViewId v3 = (ViewId)Util.readGenericStreamable(dis);
        ViewId v4 = (ViewId)Util.readGenericStreamable(dis);
        UtilTest.assertNotNull((Object)m2.getBuffer());
        UtilTest.assertEquals((int)m.getLength(), (int)m2.getLength());
        UtilTest.assertNotNull((Object)v3);
        UtilTest.assertEquals((Object)vid, (Object)v3);
        UtilTest.assertNotNull((Object)v4);
        UtilTest.assertEquals((Object)vid2, (Object)v4);
    }

    public void testWriteViewIdWithNullCoordinator() throws IOException, IllegalAccessException, InstantiationException {
        ViewId vid = new ViewId(null, 12345L);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeGenericStreamable(vid, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        ViewId v4 = (ViewId)Util.readGenericStreamable(dis);
        UtilTest.assertEquals((Object)vid, (Object)v4);
    }

    public void testWriteView() throws IOException, IllegalAccessException, InstantiationException {
        ViewId vid = new ViewId(null, 12345L);
        Vector<IpAddress> members = new Vector<IpAddress>();
        IpAddress a1 = new IpAddress("localhost", 1234);
        IpAddress a2 = new IpAddress("127.0.0.1", 4444);
        IpAddress a3 = new IpAddress("thishostdoesnexist", 6666);
        IpAddress a4 = new IpAddress("www.google.com", 7777);
        members.add(a1);
        members.add(a2);
        members.add(a3);
        members.add(a4);
        View v = new View(vid, members);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeGenericStreamable(v, dos);
        Util.writeStreamable(v, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        View v2 = (View)Util.readGenericStreamable(dis);
        UtilTest.assertEquals((Object)v, (Object)v2);
        v2 = (View)Util.readStreamable(View.class, dis);
        UtilTest.assertEquals((Object)v, (Object)v2);
    }

    public void testWriteString() throws IOException {
        String s1 = "Bela Ban";
        String s2 = "Michelle Ban";
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeString(s1, dos);
        Util.writeString(s2, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        String s3 = Util.readString(dis);
        String s4 = Util.readString(dis);
        UtilTest.assertEquals((String)s1, (String)s3);
        UtilTest.assertEquals((String)s2, (String)s4);
    }

    public void writeAddress() throws IOException, IllegalAccessException, InstantiationException {
        IpAddress a1 = new IpAddress("localhost", 1234);
        IpAddress a2 = new IpAddress("127.0.0.1", 4444);
        IpAddress a3 = new IpAddress("thishostdoesnexist", 6666);
        IpAddress a4 = new IpAddress("www.google.com", 7777);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeAddress(a1, dos);
        Util.writeAddress(a2, dos);
        Util.writeAddress(a3, dos);
        Util.writeAddress(a4, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        UtilTest.assertEquals((Object)a1, (Object)Util.readAddress(dis));
        UtilTest.assertEquals((Object)a2, (Object)Util.readAddress(dis));
        UtilTest.assertEquals((Object)a3, (Object)Util.readAddress(dis));
        UtilTest.assertEquals((Object)a4, (Object)Util.readAddress(dis));
    }

    public void writeNullAddress() throws IOException, IllegalAccessException, InstantiationException {
        Address a1 = null;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeAddress(a1, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        UtilTest.assertNull((Object)Util.readAddress(dis));
    }

    public void testWriteByteBuffer() throws IOException {
        byte[] buf = new byte[1024];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeByteBuffer(buf, dos);
        dos.close();
        byte[] tmp = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(tmp);
        DataInputStream dis = new DataInputStream(instream);
        byte[] buf2 = Util.readByteBuffer(dis);
        UtilTest.assertNotNull((Object)buf2);
        UtilTest.assertEquals((int)buf.length, (int)buf2.length);
    }

    public void testMatch() {
        long[] a = new long[]{1L, 2L, 3L};
        long[] b = new long[]{2L, 3L, 4L};
        long[] c = null;
        long[] d = new long[]{1L, 2L, 3L, 4L};
        long[] e = new long[]{1L, 2L, 3L};
        UtilTest.assertTrue((boolean)Util.match(a, a));
        UtilTest.assertFalse((boolean)Util.match(a, b));
        UtilTest.assertFalse((boolean)Util.match(a, c));
        UtilTest.assertFalse((boolean)Util.match(a, d));
        UtilTest.assertTrue((boolean)Util.match(a, e));
        UtilTest.assertTrue((boolean)Util.match(c, c));
        UtilTest.assertFalse((boolean)Util.match(c, a));
    }

    public static Test suite() {
        TestSuite s = new TestSuite(UtilTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)UtilTest.suite());
    }

    static {
        try {
            ClassConfigurator.getInstance(true);
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
    }
}

