/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.protocols.Discovery;
import org.jgroups.util.Util;

public class PingSender
implements Runnable {
    Thread thread = null;
    final Lock lock = new ReentrantLock();
    double interval;
    int num_requests = 1;
    Discovery discovery_prot;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean trace = this.log.isTraceEnabled();

    public PingSender(long timeout, int num_requests, Discovery d) {
        this.num_requests = num_requests;
        this.discovery_prot = d;
        this.interval = (double)timeout / (double)num_requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(Util.getGlobalThreadGroup(), this, "PingSender");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            if (this.thread != null) {
                Thread tmp = this.thread;
                this.thread = null;
                try {
                    tmp.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        for (int i = 0; i < this.num_requests; ++i) {
            this.lock.lock();
            try {
                if (this.thread == null || !this.thread.equals(Thread.currentThread())) {
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"sending GET_MBRS_REQ");
            }
            this.discovery_prot.sendGetMembersRequest();
            Util.sleep((long)this.interval);
        }
    }
}

