/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcParameterMetaData;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.Message;
import org.h2.result.ResultInterface;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private CommandInterface command;
    private ObjectArray batchParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        try {
            ResultInterface resultInterface;
            int n = this.getNextId(4);
            if (this.debug()) {
                this.debugCodeAssign("ResultSet", 4, n, "executeQuery()");
            }
            this.checkClosed();
            this.closeOld();
            boolean bl = this.resultSetType != 1003;
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                try {
                    this.setExecutingStatement(this.command);
                    resultInterface = this.command.executeQuery(this.maxRows, bl);
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            this.resultSet = new JdbcResultSet(this.session, this.conn, this, resultInterface, n, this.closedByResultSet, bl);
            return this.resultSet;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            this.debugCodeCall("executeUpdate");
            this.checkClosed();
            return this.executeUpdateInternal();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal() throws SQLException {
        this.closeOld();
        SessionInterface sessionInterface = this.session;
        synchronized (sessionInterface) {
            try {
                this.setExecutingStatement(this.command);
                this.updateCount = this.command.executeUpdate();
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        try {
            boolean bl;
            int n = this.getNextId(4);
            if (this.debug()) {
                this.debugCodeCall("execute");
            }
            this.checkClosed();
            this.closeOld();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        bl = true;
                        boolean bl2 = this.resultSetType != 1003;
                        ResultInterface resultInterface = this.command.executeQuery(this.maxRows, bl2);
                        this.resultSet = new JdbcResultSet(this.session, this.conn, this, resultInterface, n, this.closedByResultSet, bl2);
                    } else {
                        bl = false;
                        this.updateCount = this.command.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.debugCodeCall("clearParameters");
            this.checkClosed();
            ObjectArray objectArray = this.command.getParameters();
            for (int i = 0; i < objectArray.size(); ++i) {
                ParameterInterface parameterInterface = (ParameterInterface)objectArray.get(i);
                parameterInterface.setValue(null);
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            this.debugCodeCall("executeQuery", string);
            throw Message.getSQLException(90130);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void addBatch(String string) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string);
            throw Message.getSQLException(90130);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string);
            throw Message.getSQLException(90130);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean execute(String string) throws SQLException {
        try {
            this.debugCodeCall("execute", string);
            throw Message.getSQLException(90130);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNull(" + n + ", " + n2 + ");");
            }
            this.setParameter(n, ValueNull.INSTANCE);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setInt(" + n + ", " + n2 + ");");
            }
            this.setParameter(n, ValueInt.get(n2));
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setString(int n, String string) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setString(" + n + ", " + this.quote(string) + ");");
            }
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBigDecimal(" + n + ", " + this.quoteBigDecimal(bigDecimal) + ");");
            }
            Value value = bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setDate(" + n + ", " + this.quoteDate(date) + ");");
            }
            Value value = date == null ? ValueNull.INSTANCE : ValueDate.get(date);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setTime(" + n + ", " + this.quoteTime(time) + ");");
            }
            Value value = time == null ? ValueNull.INSTANCE : ValueTime.get(time);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setTimestamp(" + n + ", " + this.quoteTimestamp(timestamp) + ");");
            }
            Value value = timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setObject(" + n + ", x);");
            }
            if (object == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DataType.convertToValue(this.session, object, -1));
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setObject(" + n + ", x, " + n2 + ");");
            }
            int n3 = DataType.convertSQLTypeToValueType(n2);
            if (object == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                Value value = DataType.convertToValue(this.session, object, n3);
                this.setParameter(n, value.convertTo(n3));
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setObject(" + n + ", x, " + n2 + ", " + n3 + ");");
            }
            this.setObject(n, object, n2);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBoolean(" + n + ", " + bl + ");");
            }
            this.setParameter(n, ValueBoolean.get(bl));
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setByte(" + n + ", " + by + ");");
            }
            this.setParameter(n, ValueByte.get(by));
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setShort(" + n + ", (short) " + s + ");");
            }
            this.setParameter(n, ValueShort.get(s));
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setLong(" + n + ", " + l + "L);");
            }
            this.setParameter(n, ValueLong.get(l));
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setFloat(" + n + ", " + f + "f);");
            }
            this.setParameter(n, ValueFloat.get(f));
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setDouble(" + n + ", " + d + "d);");
            }
            this.setParameter(n, ValueDouble.get(d));
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setRef(" + n + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setDate(" + n + ", " + this.quoteDate(date) + ", calendar);");
            }
            if (date == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DateTimeUtils.convertDateToUniversal(date, calendar));
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setTime(" + n + ", " + this.quoteTime(time) + ", calendar);");
            }
            if (time == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DateTimeUtils.convertTimeToUniversal(time, calendar));
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setTimestamp(" + n + ", " + this.quoteTimestamp(timestamp) + ", calendar);");
            }
            if (timestamp == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DateTimeUtils.convertTimestampToUniversal(timestamp, calendar));
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setUnicodeStream(" + n + ", x, " + n2 + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNull(" + n + ", " + n2 + ", " + this.quote(string) + ");");
            }
            this.setNull(n, n2);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBlob(" + n + ", x);");
            }
            this.checkClosed();
            Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBlob(" + n + ", x);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, -1L);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setClob(" + n + ", x);");
            }
            this.checkClosed();
            Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setClob(int n, Reader reader) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setClob(" + n + ", x);");
            }
            this.checkClosed();
            Value value = reader == null ? ValueNull.INSTANCE : this.conn.createClob(reader, -1L);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setArray(" + n + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBytes(" + n + ", " + this.quoteBytes(byArray) + ");");
            }
            Value value = byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBinaryStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, l);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, (long)n2);
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n, inputStream, -1);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream, (long)n2);
    }

    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setAsciiStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream), l);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.setAsciiStream(n, inputStream, -1);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(n, reader, (long)n2);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader, -1);
    }

    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setCharacterStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setURL(" + n + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.debugCodeCall("getMetaData");
            this.checkClosed();
            ResultInterface resultInterface = this.command.getMetaData();
            if (resultInterface == null) {
                return null;
            }
            int n = this.getNextId(5);
            if (this.debug()) {
                this.debugCodeAssign("ResultSetMetaData", 5, n, "getMetaData()");
            }
            String string = this.conn.getCatalog();
            JdbcResultSetMetaData jdbcResultSetMetaData = new JdbcResultSetMetaData(null, this, resultInterface, string, this.session.getTrace(), n);
            return jdbcResultSetMetaData;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchParameters = null;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void close() throws SQLException {
        try {
            super.close();
            if (this.command != null) {
                this.command.close();
                this.command = null;
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeBatch");
            this.checkClosed();
            if (this.batchParameters == null) {
                this.batchParameters = new ObjectArray();
            }
            int[] nArray = new int[this.batchParameters.size()];
            boolean bl = false;
            SQLException sQLException = null;
            for (int i = 0; i < this.batchParameters.size(); ++i) {
                ObjectArray objectArray = this.command.getParameters();
                Value[] valueArray = (Value[])this.batchParameters.get(i);
                for (int j = 0; j < valueArray.length; ++j) {
                    Value value = valueArray[j];
                    ParameterInterface parameterInterface = (ParameterInterface)objectArray.get(j);
                    parameterInterface.setValue(value);
                }
                try {
                    nArray[i] = this.executeUpdateInternal();
                    continue;
                }
                catch (SQLException sQLException2) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                    } else {
                        sQLException2.setNextException(sQLException);
                        sQLException = sQLException2;
                    }
                    this.logAndConvert(sQLException2);
                    nArray[i] = -3;
                    bl = true;
                }
            }
            this.batchParameters = null;
            if (bl) {
                JdbcBatchUpdateException jdbcBatchUpdateException = new JdbcBatchUpdateException(sQLException, nArray);
                jdbcBatchUpdateException.setNextException(sQLException);
                throw jdbcBatchUpdateException;
            }
            return nArray;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.debugCodeCall("addBatch");
            this.checkClosed();
            ObjectArray objectArray = this.command.getParameters();
            Value[] valueArray = new Value[objectArray.size()];
            for (int i = 0; i < objectArray.size(); ++i) {
                Value value;
                ParameterInterface parameterInterface = (ParameterInterface)objectArray.get(i);
                valueArray[i] = value = parameterInterface.getParamValue();
            }
            if (this.batchParameters == null) {
                this.batchParameters = new ObjectArray();
            }
            this.batchParameters.add(valueArray);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + n + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(string) + ", " + n + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            int n = this.getNextId(11);
            if (this.debug()) {
                this.debugCodeAssign("ParameterMetaData", 11, n, "getParameterMetaData()");
            }
            this.checkClosed();
            JdbcParameterMetaData jdbcParameterMetaData = new JdbcParameterMetaData(this.session, this, this.command, n);
            return jdbcParameterMetaData;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    JdbcPreparedStatement(SessionInterface sessionInterface, JdbcConnection jdbcConnection, String string, int n, int n2, boolean bl) throws SQLException {
        super(sessionInterface, jdbcConnection, n, n2, bl);
        this.setTrace(sessionInterface.getTrace(), 3, n2);
        this.command = jdbcConnection.prepareCommand(string, this.fetchSize);
    }

    private void setParameter(int n, Value value) throws SQLException {
        this.checkClosed();
        ObjectArray objectArray = this.command.getParameters();
        if (--n < 0 || n >= objectArray.size()) {
            throw Message.getInvalidValueException("" + (n + 1), "parameterIndex");
        }
        ParameterInterface parameterInterface = (ParameterInterface)objectArray.get(n);
        parameterInterface.setValue(value);
    }

    public void setNString(int n, String string) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNString(" + n + ", " + this.quote(string) + ");");
            }
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNCharacterStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setNCharacterStream(n, reader, -1L);
    }

    public void setNClob(int n, Reader reader) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNClob(" + n + ", x);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, -1L);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setClob(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBlob(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createBlob(inputStream, l);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNClob(" + n + ", x, " + l + "L);");
            }
            this.checkClosed();
            Value value = this.conn.createClob(reader, l);
            this.setParameter(n, value);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.command.toString();
    }
}

