/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.RspList;

public class MessageDispatcherShunTest
implements MembershipListener,
RequestHandler {
    JChannel channel;
    MessageDispatcher disp;

    public static void main(String[] args) {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-props")) {
                MessageDispatcherShunTest.help();
                return;
            }
            props = args[++i];
        }
        try {
            new MessageDispatcherShunTest().start(props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void start(String props) throws IOException, ChannelException {
        this.channel = new JChannel(props);
        this.channel.setOpt(5, Boolean.TRUE);
        this.disp = new MessageDispatcher(this.channel, null, this, this, false, true);
        this.channel.connect("MessageDispatcherTestGroup");
        this.mainLoop();
    }

    private void mainLoop() throws IOException {
        while (true) {
            System.in.skip(System.in.available());
            System.out.println("\n[1] Send [2] Shun [3] Print view [q] Quit");
            int c = System.in.read();
            switch (c) {
                case -1: {
                    break;
                }
                case 49: {
                    this.sendMessage();
                    break;
                }
                case 50: {
                    this.shun();
                    break;
                }
                case 51: {
                    View v = this.channel.getView();
                    System.out.println("View: " + v);
                    break;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
            }
        }
    }

    private void shun() {
        System.out.println("shunning this member");
        this.channel.up(new Event(46));
    }

    private void sendMessage() {
        Message msg = new Message(null, null, (Serializable)((Object)"Hello world"));
        View v = this.channel.getView();
        Vector members = new Vector(v.getMembers());
        System.out.println("sending to " + members);
        RspList rsp_list = this.disp.castMessage(members, msg, 2, 0L);
        System.out.println("responses:\n" + rsp_list);
    }

    private static void help() {
        System.out.println("MessageDispatcherShunTest [-help] [-props <props>]");
    }

    public Object handle(Message msg) {
        return "same to you";
    }

    public void viewAccepted(View new_view) {
        System.out.println("-- view: " + new_view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }
}

