/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.management.MBeanServer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.demos.DrawCommand;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Util;

public class Draw
extends ExtendedReceiverAdapter
implements ActionListener,
ChannelListener {
    String groupname = "DrawGroupDemo";
    private Channel channel = null;
    private int member_size = 1;
    static final boolean first = true;
    private JFrame mainFrame = null;
    private JPanel sub_panel = null;
    private DrawPanel panel = null;
    private JButton clear_button;
    private JButton leave_button;
    private final Random random = new Random(System.currentTimeMillis());
    private final Font default_font = new Font("Helvetica", 0, 12);
    private final Color draw_color = this.selectColor();
    private static final Color background_color = Color.white;
    boolean no_channel = false;
    boolean jmx;
    private boolean use_state = false;
    private long state_timeout = 5000L;

    public Draw(String props, boolean no_channel, boolean jmx, boolean use_state, long state_timeout) throws Exception {
        this.no_channel = no_channel;
        this.jmx = jmx;
        this.use_state = use_state;
        this.state_timeout = state_timeout;
        if (no_channel) {
            return;
        }
        this.channel = new JChannel(props);
        this.channel.setOpt(5, Boolean.TRUE);
        this.channel.setReceiver(this);
        this.channel.addChannelListener(this);
    }

    public Draw(Channel channel) throws Exception {
        this.channel = channel;
        channel.setOpt(5, Boolean.TRUE);
        channel.setReceiver(this);
        channel.addChannelListener(this);
    }

    public Draw(Channel channel, boolean use_state, long state_timeout) throws Exception {
        this.channel = channel;
        channel.setOpt(5, Boolean.TRUE);
        channel.setReceiver(this);
        channel.addChannelListener(this);
        this.use_state = use_state;
        this.state_timeout = state_timeout;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public void setGroupName(String groupname) {
        if (groupname != null) {
            this.groupname = groupname;
        }
    }

    public static void main(String[] args) {
        Draw draw = null;
        String props = null;
        boolean no_channel = false;
        boolean jmx = false;
        boolean use_state = false;
        String group_name = null;
        long state_timeout = 5000L;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                Draw.help();
                return;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-no_channel".equals(args[i])) {
                no_channel = true;
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = true;
                continue;
            }
            if ("-groupname".equals(args[i])) {
                group_name = args[++i];
                continue;
            }
            if ("-state".equals(args[i])) {
                use_state = true;
                continue;
            }
            if ("-timeout".equals(args[i])) {
                state_timeout = Long.parseLong(args[++i]);
                continue;
            }
            Draw.help();
            return;
        }
        try {
            draw = new Draw(props, no_channel, jmx, use_state, state_timeout);
            if (group_name != null) {
                draw.setGroupName(group_name);
            }
            draw.go();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    static void help() {
        System.out.println("\nDraw [-help] [-no_channel] [-props <protocol stack definition>] [-groupname <name>] [-state] [-timeout <state timeout>]");
        System.out.println("-no_channel: doesn't use JGroups at all, any drawing will be relected on the whiteboard directly");
        System.out.println("-props: argument can be an old-style protocol stack specification, or it can be a URL. In the latter case, the protocol specification will be read from the URL\n");
    }

    private Color selectColor() {
        int red = Math.abs(this.random.nextInt()) % 255;
        int green = Math.abs(this.random.nextInt()) % 255;
        int blue = Math.abs(this.random.nextInt()) % 255;
        return new Color(red, green, blue);
    }

    public void go() throws Exception {
        if (!this.no_channel) {
            this.channel.connect(this.groupname);
            if (this.jmx) {
                MBeanServer server = Util.getMBeanServer();
                if (server == null) {
                    throw new Exception("No MBeanServers found;\nDraw needs to be run with an MBeanServer present, or inside JDK 5");
                }
                JmxConfigurator.registerChannel((JChannel)this.channel, server, "jgroups", this.channel.getClusterName(), true);
            }
        }
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(3);
        this.panel = new DrawPanel(this.use_state);
        this.panel.setBackground(background_color);
        this.sub_panel = new JPanel();
        this.mainFrame.getContentPane().add("Center", this.panel);
        this.clear_button = new JButton("Clear");
        this.clear_button.setFont(this.default_font);
        this.clear_button.addActionListener(this);
        this.leave_button = new JButton("Leave");
        this.leave_button.setFont(this.default_font);
        this.leave_button.addActionListener(this);
        this.sub_panel.add("South", this.clear_button);
        this.sub_panel.add("South", this.leave_button);
        this.mainFrame.getContentPane().add("South", this.sub_panel);
        this.mainFrame.setBackground(background_color);
        this.clear_button.setForeground(Color.blue);
        this.leave_button.setForeground(Color.blue);
        this.setTitle();
        this.mainFrame.pack();
        this.mainFrame.setLocation(15, 25);
        this.mainFrame.setBounds(new Rectangle(250, 250));
        if (!this.no_channel && this.use_state) {
            this.channel.getState(null, this.state_timeout);
        }
        this.mainFrame.setVisible(true);
    }

    void setTitle(String title) {
        String tmp = "";
        if (this.no_channel) {
            this.mainFrame.setTitle(" Draw Demo ");
            return;
        }
        if (title != null) {
            this.mainFrame.setTitle(title);
        } else {
            if (this.channel.getLocalAddress() != null) {
                tmp = tmp + this.channel.getLocalAddress();
            }
            tmp = tmp + " (" + this.member_size + ")";
            this.mainFrame.setTitle(tmp);
        }
    }

    void setTitle() {
        this.setTitle(null);
    }

    public void receive(Message msg) {
        byte[] buf = msg.getRawBuffer();
        if (buf == null) {
            System.err.println("received null buffer from " + msg.getSrc() + ", headers: " + msg.printHeaders());
            return;
        }
        try {
            DrawCommand comm = (DrawCommand)Util.streamableFromByteBuffer(DrawCommand.class, buf, msg.getOffset(), msg.getLength());
            switch (comm.mode) {
                case 1: {
                    if (this.panel != null) {
                        this.panel.drawPoint(comm);
                    }
                    break;
                }
                case 2: {
                    this.clearPanel();
                    break;
                }
                default: {
                    System.err.println("***** received invalid draw command " + comm.mode);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void viewAccepted(View v) {
        if (v instanceof MergeView) {
            System.out.println("** MergeView=" + v);
        } else {
            System.out.println("** View=" + v);
        }
        this.member_size = v.size();
        if (this.mainFrame != null) {
            this.setTitle();
        }
    }

    public void block() {
        System.out.println("--  received BlockEvent");
    }

    public void unblock() {
        System.out.println("-- received UnblockEvent");
    }

    public byte[] getState() {
        return this.panel.getState();
    }

    public void setState(byte[] state) {
        this.panel.setState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(OutputStream ostream) {
        try {
            try {
                this.panel.writeState(ostream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            Util.close(ostream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(InputStream istream) {
        try {
            try {
                this.panel.readState(istream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            Util.close(istream);
        }
    }

    public void clearPanel() {
        if (this.panel != null) {
            this.panel.clear();
        }
    }

    public void sendClearPanelMsg() {
        int[] tmp = new int[]{0};
        DrawCommand comm = new DrawCommand(2);
        try {
            byte[] buf = Util.streamableToByteBuffer(comm);
            this.channel.send(new Message(null, null, buf));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Clear".equals(command)) {
            if (this.no_channel) {
                this.clearPanel();
                return;
            }
            this.sendClearPanelMsg();
        } else if ("Leave".equals(command)) {
            this.stop();
        } else {
            System.out.println("Unknown action");
        }
    }

    public void stop() {
        if (!this.no_channel) {
            try {
                this.channel.close();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
    }

    public void channelConnected(Channel channel) {
    }

    public void channelDisconnected(Channel channel) {
    }

    public void channelClosed(Channel channel) {
    }

    public void channelShunned() {
        System.out.println("-- received EXIT, waiting for ChannelReconnected callback");
        this.setTitle(" Draw Demo - shunned ");
    }

    public void channelReconnected(Address addr) {
        this.setTitle();
    }

    private class DrawPanel
    extends JPanel
    implements MouseMotionListener {
        final Dimension preferred_size = new Dimension(235, 170);
        Image img = null;
        Dimension d;
        Dimension imgsize = null;
        Graphics gr = null;
        final Map<Point, Color> state;

        public DrawPanel(boolean use_state) {
            this.state = use_state ? new LinkedHashMap<Point, Color>() : null;
            this.createOffscreenImage(false);
            this.addMouseMotionListener(this);
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    if (DrawPanel.this.getWidth() <= 0 || DrawPanel.this.getHeight() <= 0) {
                        return;
                    }
                    DrawPanel.this.createOffscreenImage(false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState() {
            byte[] retval = null;
            if (this.state == null) {
                return null;
            }
            Map<Point, Color> map = this.state;
            synchronized (map) {
                try {
                    retval = Util.objectToByteBuffer(this.state);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] buf) {
            Map<Point, Color> map = this.state;
            synchronized (map) {
                try {
                    Map tmp = (Map)Util.objectFromByteBuffer(buf);
                    this.state.clear();
                    this.state.putAll(tmp);
                    System.out.println("received state: " + buf.length + " bytes, " + this.state.size() + " entries");
                    this.createOffscreenImage(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeState(OutputStream outstream) throws IOException {
            Map<Point, Color> map = this.state;
            synchronized (map) {
                if (this.state != null) {
                    DataOutputStream dos = new DataOutputStream(outstream);
                    dos.writeInt(this.state.size());
                    for (Map.Entry<Point, Color> entry : this.state.entrySet()) {
                        Point point = entry.getKey();
                        Color col = entry.getValue();
                        dos.writeInt(point.x);
                        dos.writeInt(point.y);
                        dos.writeInt(col.getRGB());
                    }
                    dos.flush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readState(InputStream instream) throws IOException {
            DataInputStream in = new DataInputStream(instream);
            HashMap<Point, Color> new_state = new HashMap<Point, Color>();
            int num = in.readInt();
            for (int i = 0; i < num; ++i) {
                Point point = new Point(in.readInt(), in.readInt());
                Color col = new Color(in.readInt());
                new_state.put(point, col);
            }
            if (new_state != null) {
                Map<Point, Color> map = this.state;
                synchronized (map) {
                    this.state.clear();
                    this.state.putAll(new_state);
                    System.out.println("read state: " + this.state.size() + " entries");
                    this.createOffscreenImage(true);
                }
            }
        }

        final void createOffscreenImage(boolean discard_image) {
            this.d = this.getSize();
            if (discard_image) {
                this.img = null;
                this.imgsize = null;
            }
            if (this.img == null || this.imgsize == null || this.imgsize.width != this.d.width || this.imgsize.height != this.d.height) {
                this.img = this.createImage(this.d.width, this.d.height);
                if (this.img != null) {
                    this.gr = this.img.getGraphics();
                    if (this.gr != null && this.state != null) {
                        this.drawState();
                    }
                }
                this.imgsize = this.d;
            }
            this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            DrawCommand comm = new DrawCommand(1, x, y, Draw.this.draw_color.getRed(), Draw.this.draw_color.getGreen(), Draw.this.draw_color.getBlue());
            if (Draw.this.no_channel) {
                this.drawPoint(comm);
                return;
            }
            try {
                byte[] buf = Util.streamableToByteBuffer(comm);
                Draw.this.channel.send(new Message(null, null, buf));
                Thread.yield();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawPoint(DrawCommand c) {
            if (c == null || this.gr == null) {
                return;
            }
            Color col = new Color(c.r, c.g, c.b);
            this.gr.setColor(col);
            this.gr.fillOval(c.x, c.y, 10, 10);
            this.repaint();
            if (this.state != null) {
                Map<Point, Color> map = this.state;
                synchronized (map) {
                    this.state.put(new Point(c.x, c.y), col);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (this.gr == null) {
                return;
            }
            this.gr.clearRect(0, 0, this.getSize().width, this.getSize().height);
            this.repaint();
            if (this.state != null) {
                Map<Point, Color> map = this.state;
                synchronized (map) {
                    this.state.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawState() {
            Map<Point, Color> map = this.state;
            synchronized (map) {
                for (Map.Entry<Point, Color> entry : this.state.entrySet()) {
                    Point pt = entry.getKey();
                    Color col = entry.getValue();
                    this.gr.setColor(col);
                    this.gr.fillOval(pt.x, pt.y, 10, 10);
                }
            }
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return this.preferred_size;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img != null) {
                g.drawImage(this.img, 0, 0, null);
            }
        }
    }
}

