/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.activemq.broker.BrokerService;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.builder.help.KnowledgeBuilderHelper;
import org.drools.core.util.StringUtils;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.ResultHandlerFactory;
import org.drools.runtime.pipeline.Service;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.pipeline.impl.SimpleProducer;
import org.drools.runtime.rule.FactHandle;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class JaxbSimpleJmsMessengerTest {
    private SimpleProducer simpleProducer;
    private BrokerService broker;
    private String destinationName = "dynamicQueues/FOO.BAR";
    private String url = "vm://localhost:61616";
    private Properties props;

    @Test
    @Ignore
    public void testJmsWithJaxb() throws Exception {
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String[] classNames = KnowledgeBuilderHelper.addXsdModel((Resource)ResourceFactory.newClassPathResource((String)"order.xsd", this.getClass()), (KnowledgeBuilder)kbuilder, (Options)xjcOpts, (String)"xsd");
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_Jaxb.drl", this.getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Action resultHandlerStage = PipelineFactory.newExecuteResultHandler();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        insertStage.setReceiver((Receiver)resultHandlerStage);
        JAXBContext jaxbCtx = KnowledgeBuilderHelper.newJAXBContext((String[])classNames, (KnowledgeBase)kbase);
        Unmarshaller unmarshaller = jaxbCtx.createUnmarshaller();
        Transformer transformer = PipelineFactory.newJaxbFromXmlTransformer((Unmarshaller)unmarshaller);
        transformer.setReceiver((Receiver)insertStage);
        Action unwrapObjectStage = PipelineFactory.newJmsUnwrapMessageObject();
        unwrapObjectStage.setReceiver((Receiver)transformer);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)unwrapObjectStage);
        ResultHandleFactoryImpl factory = new ResultHandleFactoryImpl();
        Service feeder = PipelineFactory.newJmsMessenger((Pipeline)pipeline, (Properties)this.props, (String)this.destinationName, (ResultHandlerFactory)factory);
        feeder.start();
        String xml = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("order.xml")));
        this.simpleProducer.sendObject((Serializable)((Object)xml));
        for (int i = 0; i < 5 && factory.list.size() != 1; ++i) {
            Thread.sleep(5000L);
        }
        FactHandle factHandle = (FactHandle)((Map)((ResultHandlerImpl)factory.list.get(0)).getObject()).keySet().iterator().next();
        Assert.assertNotNull((Object)factHandle);
        Assert.assertEquals((long)1L, (long)factory.list.size());
        Action executeResult = PipelineFactory.newExecuteResultHandler();
        Action assignAsResult = PipelineFactory.newAssignObjectAsResult();
        assignAsResult.setReceiver((Receiver)executeResult);
        Marshaller marshaller = jaxbCtx.createMarshaller();
        transformer = PipelineFactory.newJaxbToXmlTransformer((Marshaller)marshaller);
        transformer.setReceiver((Receiver)assignAsResult);
        KnowledgeRuntimeCommand getObject = PipelineFactory.newStatefulKnowledgeSessionGetObject();
        getObject.setReceiver((Receiver)transformer);
        pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)getObject);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)factHandle, (ResultHandler)resultHandler);
        JaxbSimpleJmsMessengerTest.assertEqualsIgnoreWhitespace(xml, (String)resultHandler.getObject());
        feeder.stop();
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class ResultHandleFactoryImpl
    implements ResultHandlerFactory {
        List list = new ArrayList();

        public ResultHandler newResultHandler() {
            ResultHandlerImpl handler = new ResultHandlerImpl();
            this.list.add(handler);
            return handler;
        }
    }
}

