/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jxls.reader.ReaderBuilder;
import net.sf.jxls.reader.XLSReader;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.impl.KnowledgeBuilderImpl;
import org.drools.io.ResourceFactory;
import org.drools.runtime.pipeline.PipelineContext;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.pipeline.impl.BasePipelineContext;
import org.drools.runtime.pipeline.impl.CallableImpl;
import org.drools.runtime.pipeline.impl.Company;
import org.drools.runtime.pipeline.impl.Department;
import org.drools.util.CompositeClassLoader;
import org.junit.Assert;
import org.junit.Test;

public class JxlsTest {
    @Test
    public void test1() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        CompositeClassLoader cl = ((KnowledgeBuilderImpl)kbuilder).pkgBuilder.getRootClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        BufferedInputStream inputXLS = new BufferedInputStream(this.getClass().getResourceAsStream("departmentData.xls"));
        XLSReader mainReader = ReaderBuilder.buildFromXML((InputStream)ResourceFactory.newClassPathResource((String)"departments.xml", this.getClass()).getInputStream());
        Transformer transformer = PipelineFactory.newJxlsTransformer((XLSReader)mainReader, (String)"[ 'departments' : new java.util.ArrayList(), 'company' : new org.drools.runtime.pipeline.impl.Company() ]");
        CallableImpl callable = new CallableImpl();
        callable.setReceiver((Receiver)transformer);
        transformer.setReceiver((Receiver)callable);
        BasePipelineContext context = new BasePipelineContext(Thread.currentThread().getContextClassLoader());
        Map beans = (Map)callable.call((Object)inputXLS, (PipelineContext)context);
        Assert.assertEquals((Object)Company.class.getName(), (Object)beans.get("company").getClass().getName());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)beans.get("departments").getClass().getName());
        Company company = (Company)beans.get("company");
        Assert.assertEquals((Object)"A-Team", (Object)company.getName());
        Assert.assertEquals((long)4L, (long)company.getEmployee().size());
        List departments = (List)beans.get("departments");
        Assert.assertEquals((long)3L, (long)departments.size());
        Department department = (Department)departments.get(0);
        Assert.assertEquals((Object)"IT", (Object)department.getName());
        Assert.assertEquals((long)5L, (long)department.getStaff().size());
        department = (Department)departments.get(2);
        Assert.assertEquals((Object)"BA", (Object)department.getName());
        Assert.assertEquals((long)4L, (long)department.getStaff().size());
    }
}

