/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.Expression;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.pipeline.impl.SmookStatefulSessionTest;
import org.junit.Assert;
import org.junit.Test;
import org.milyn.Smooks;

public class SmookStatelessSessionTest {
    @Test
    public void testSmooksDirectRoot() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_SmooksDirectRoot.drl", SmookStatefulSessionTest.class), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        Action assignResult = PipelineFactory.newAssignObjectAsResult();
        assignResult.setReceiver((Receiver)executeResultHandler);
        KnowledgeRuntimeCommand batchExecution = PipelineFactory.newCommandExecutor();
        batchExecution.setReceiver((Receiver)assignResult);
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newInsertObjectCommand();
        insertStage.setReceiver((Receiver)batchExecution);
        Smooks smooks = new Smooks(this.getClass().getResourceAsStream("smooks-config.xml"));
        Transformer transformer = PipelineFactory.newSmooksFromSourceTransformer((Smooks)smooks, (String)"orderItem");
        transformer.setReceiver((Receiver)insertStage);
        Pipeline pipeline = PipelineFactory.newStatelessKnowledgeSessionPipeline((StatelessKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)new StreamSource(this.getClass().getResourceAsStream("SmooksDirectRoot.xml")), (ResultHandler)resultHandler);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"example.OrderItem", (Object)list.get(0).getClass().getName());
    }

    @Test
    public void testSmooksNestedIterable() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_SmooksNestedIterable.drl", SmookStatefulSessionTest.class), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        Action assignResult = PipelineFactory.newAssignObjectAsResult();
        assignResult.setReceiver((Receiver)executeResultHandler);
        KnowledgeRuntimeCommand batchExecution = PipelineFactory.newCommandExecutor();
        batchExecution.setReceiver((Receiver)assignResult);
        KnowledgeRuntimeCommand insertElementsStage = PipelineFactory.newInsertElementsCommand();
        insertElementsStage.setReceiver((Receiver)batchExecution);
        Expression mvelExpression = PipelineFactory.newMvelExpression((String)"this.children");
        mvelExpression.setReceiver((Receiver)insertElementsStage);
        Smooks smooks = new Smooks(this.getClass().getResourceAsStream("smooks-config.xml"));
        Transformer transformer = PipelineFactory.newSmooksFromSourceTransformer((Smooks)smooks, (String)"root");
        transformer.setReceiver((Receiver)mvelExpression);
        Pipeline pipeline = PipelineFactory.newStatelessKnowledgeSessionPipeline((StatelessKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)new StreamSource(this.getClass().getResourceAsStream("SmooksNestedIterable.xml")), (ResultHandler)resultHandler);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"example.OrderItem", (Object)list.get(0).getClass().getName());
        Assert.assertEquals((Object)"example.OrderItem", (Object)list.get(1).getClass().getName());
        Assert.assertNotSame(list.get(0), list.get(1));
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

