/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.Splitter;
import org.drools.runtime.pipeline.Transformer;
import org.junit.Assert;
import org.junit.Test;

public class XStreamStatefulSessionTest {
    @Test
    public void testDirectRoot() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_XStreamDirectRoot.drl", XStreamStatefulSessionTest.class), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        insertStage.setReceiver((Receiver)executeResultHandler);
        XStream xstream = new XStream();
        Transformer transformer = PipelineFactory.newXStreamFromXmlTransformer((XStream)xstream);
        transformer.setReceiver((Receiver)insertStage);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)this.getClass().getResourceAsStream("XStreamDirectRoot.xml"), (ResultHandler)resultHandler);
        ksession.fireAllRules();
        Map handles = (Map)resultHandler.getObject();
        Assert.assertEquals((long)1L, (long)handles.size());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"example.OrderItem", (Object)list.get(0).getClass().getName());
    }

    @Test
    public void testNestedIterable() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_XStreamNestedIterable.drl", XStreamStatefulSessionTest.class), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        insertStage.setReceiver((Receiver)executeResultHandler);
        Splitter splitter = PipelineFactory.newIterateSplitter();
        splitter.setReceiver((Receiver)insertStage);
        XStream xstream = new XStream();
        Transformer transformer = PipelineFactory.newXStreamFromXmlTransformer((XStream)xstream);
        transformer.setReceiver((Receiver)splitter);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)this.getClass().getResourceAsStream("XStreamNestedIterable.xml"), (ResultHandler)resultHandler);
        Map handles = (Map)resultHandler.getObject();
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)handles.size());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"example.OrderItem", (Object)list.get(0).getClass().getName());
        Assert.assertEquals((Object)"example.OrderItem", (Object)list.get(1).getClass().getName());
        Assert.assertNotSame(list.get(0), list.get(1));
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

