/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.JaxbConfiguration;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.builder.help.KnowledgeBuilderHelper;
import org.drools.core.util.StringUtils;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.rule.FactHandle;
import org.junit.Assert;
import org.junit.Test;

public class JaxbFactTest {
    @Test
    public void testFact() throws Exception {
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        JaxbConfiguration jaxbConf = KnowledgeBuilderFactory.newJaxbConfiguration((Options)xjcOpts, (String)"xsd");
        kbuilder.add(ResourceFactory.newClassPathResource((String)"order.xsd", this.getClass()), ResourceType.XSD, (ResourceConfiguration)jaxbConf);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_Jaxb.drl", this.getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        insertStage.setReceiver((Receiver)executeResultHandler);
        JAXBContext jaxbCtx = KnowledgeBuilderHelper.newJAXBContext((String[])jaxbConf.getClasses().toArray(new String[jaxbConf.getClasses().size()]), (KnowledgeBase)kbase);
        Unmarshaller unmarshaller = jaxbCtx.createUnmarshaller();
        Transformer transformer = PipelineFactory.newJaxbFromXmlTransformer((Unmarshaller)unmarshaller);
        transformer.setReceiver((Receiver)insertStage);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        String xml = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("order.xml")));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)xml, (ResultHandler)resultHandler);
        FactHandle factHandle = (FactHandle)((Map)resultHandler.getObject()).keySet().iterator().next();
        Assert.assertNotNull((Object)factHandle);
        Action executeResult = PipelineFactory.newExecuteResultHandler();
        Action assignAsResult = PipelineFactory.newAssignObjectAsResult();
        assignAsResult.setReceiver((Receiver)executeResult);
        Marshaller marshaller = jaxbCtx.createMarshaller();
        transformer = PipelineFactory.newJaxbToXmlTransformer((Marshaller)marshaller);
        transformer.setReceiver((Receiver)assignAsResult);
        KnowledgeRuntimeCommand getObject = PipelineFactory.newStatefulKnowledgeSessionGetObject();
        getObject.setReceiver((Receiver)transformer);
        pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)getObject);
        resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)factHandle, (ResultHandler)resultHandler);
        JaxbFactTest.assertEqualsIgnoreWhitespace(xml, (String)resultHandler.getObject());
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

