/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline;

import com.thoughtworks.xstream.XStream;
import java.util.Properties;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.sf.jxls.reader.XLSReader;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.CorePipelineProvider;
import org.drools.runtime.pipeline.Expression;
import org.drools.runtime.pipeline.JaxbTransformerProvider;
import org.drools.runtime.pipeline.JmsMessengerProvider;
import org.drools.runtime.pipeline.Join;
import org.drools.runtime.pipeline.JxlsTransformerProvider;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.ResultHandlerFactory;
import org.drools.runtime.pipeline.Service;
import org.drools.runtime.pipeline.SmooksTransformerProvider;
import org.drools.runtime.pipeline.Splitter;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.pipeline.XStreamTransformerProvider;
import org.milyn.Smooks;

public class PipelineFactory {
    private static CorePipelineProvider corePipelineProvider;
    private static JaxbTransformerProvider jaxbPipelineProvider;
    private static SmooksTransformerProvider smooksPipelineProvider;
    private static XStreamTransformerProvider xstreamPipelineProvider;
    private static JxlsTransformerProvider jxlsPipelineProvider;
    private static JmsMessengerProvider jmsMessengerProvider;

    public static Pipeline newStatefulKnowledgeSessionPipeline(StatefulKnowledgeSession ksession) {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionPipeline(ksession);
    }

    public static Pipeline newStatefulKnowledgeSessionPipeline(StatefulKnowledgeSession ksession, String entryPointName) {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionPipeline(ksession, entryPointName);
    }

    public static Pipeline newStatelessKnowledgeSessionPipeline(StatelessKnowledgeSession ksession) {
        return PipelineFactory.getCorePipelineProvider().newStatelessKnowledgeSessionPipeline(ksession);
    }

    public static KnowledgeRuntimeCommand newCommandExecutor() {
        return PipelineFactory.getCorePipelineProvider().newCommandExecutor();
    }

    public static KnowledgeRuntimeCommand newInsertElementsCommand() {
        return PipelineFactory.getCorePipelineProvider().newInsertElementsCommand();
    }

    public static KnowledgeRuntimeCommand newInsertObjectCommand() {
        return PipelineFactory.getCorePipelineProvider().newInsertObjectCommand();
    }

    public static KnowledgeRuntimeCommand newStatefulKnowledgeSessionInsert() {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionInsert();
    }

    public static KnowledgeRuntimeCommand newStatefulKnowledgeSessionGetGlobal() {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionGetGlobal();
    }

    public static KnowledgeRuntimeCommand newStatefulKnowledgeSessionSetGlobal() {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionSetGlobal();
    }

    public static KnowledgeRuntimeCommand newStatefulKnowledgeSessionGetObject() {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionGetObject();
    }

    public static KnowledgeRuntimeCommand newStatefulKnowledgeSessionSetGlobal(String identifier) {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionSetGlobal(identifier);
    }

    public static KnowledgeRuntimeCommand newStatefulKnowledgeSessionSignalEvent(String eventType) {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionSignalEvent(eventType);
    }

    public static KnowledgeRuntimeCommand newStatefulKnowledgeSessionSignalEvent(String eventType, long id) {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionSignalEvent(eventType, id);
    }

    public static KnowledgeRuntimeCommand newStatefulKnowledgeSessionStartProcess(String id) {
        return PipelineFactory.getCorePipelineProvider().newStatefulKnowledgeSessionStartProcess(id);
    }

    public static Action newAssignObjectAsResult() {
        return PipelineFactory.getCorePipelineProvider().newAssignObjectAsResult();
    }

    public static Action newExecuteResultHandler() {
        return PipelineFactory.getCorePipelineProvider().newExecuteResultHandler();
    }

    public static Action newMvelAction(String action) {
        return PipelineFactory.getCorePipelineProvider().newMvelAction(action);
    }

    public static Expression newMvelExpression(String expression) {
        return PipelineFactory.getCorePipelineProvider().newMvelExpression(expression);
    }

    public static Splitter newIterateSplitter() {
        return PipelineFactory.getCorePipelineProvider().newIterateSplitter();
    }

    public static Join newListCollectJoin() {
        return PipelineFactory.getCorePipelineProvider().newListCollectJoin();
    }

    public static Service newJmsMessenger(Pipeline pipeline, Properties properties, String destinationName, ResultHandlerFactory resultHandlerFactory) {
        return PipelineFactory.getJmsMessengerProvider().newJmsMessenger(pipeline, properties, destinationName, resultHandlerFactory);
    }

    public static Service newJmsMessenger(Pipeline pipeline, Properties properties, String connectionFactoryName, boolean useSecurityPrincipalForConnection, String destinationName, ResultHandlerFactory resultHandlerFactory) {
        return PipelineFactory.getJmsMessengerProvider().newJmsMessenger(pipeline, properties, connectionFactoryName, useSecurityPrincipalForConnection, destinationName, resultHandlerFactory);
    }

    public static Action newJmsUnwrapMessageObject() {
        return PipelineFactory.getJmsMessengerProvider().newJmsUnwrapMessageObject();
    }

    public static Transformer newSmooksFromSourceTransformer(Smooks smooks, String rootId) {
        return PipelineFactory.getSmooksPipelineProvider().newSmooksFromSourceTransformer(smooks, rootId);
    }

    public static Transformer newSmooksToSourceTransformer(Smooks smooks) {
        return PipelineFactory.getSmooksPipelineProvider().newSmooksToSourceTransformer(smooks);
    }

    public static Transformer newJaxbFromXmlTransformer(Unmarshaller unmarshaller) {
        return PipelineFactory.getJaxbPipelineProvider().newJaxbFromXmlTransformer(unmarshaller);
    }

    public static Transformer newJaxbToXmlTransformer(Marshaller marshaller) {
        return PipelineFactory.getJaxbPipelineProvider().newJaxbToXmlTransformer(marshaller);
    }

    public static Transformer newXStreamFromXmlTransformer(XStream xstream) {
        return PipelineFactory.getXStreamTransformerProvider().newXStreamFromXmlTransformer(xstream);
    }

    public static Transformer newXStreamToXmlTransformer(XStream xstream) {
        return PipelineFactory.getXStreamTransformerProvider().newXStreamToXmlTransformer(xstream);
    }

    public static Transformer newJxlsTransformer(XLSReader xlsReader, String text) {
        return PipelineFactory.getJxlsTransformerProvider().newJxlsTransformer(xlsReader, text);
    }

    private static synchronized void setCorePipelineProvider(CorePipelineProvider provider) {
        corePipelineProvider = provider;
    }

    private static synchronized CorePipelineProvider getCorePipelineProvider() {
        if (corePipelineProvider == null) {
            PipelineFactory.loadCorePipelineProvider();
        }
        return corePipelineProvider;
    }

    private static void loadCorePipelineProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.runtime.pipeline.impl.CorePipelineProviderImpl");
            PipelineFactory.setCorePipelineProvider((CorePipelineProvider)cls.newInstance());
        }
        catch (Exception e2) {
            throw new RuntimeException("org.drools.runtime.pipeline.impl.CorePipelineProviderImpl could not be set.", e2);
        }
    }

    private static synchronized void setJaxbTransformerProvider(JaxbTransformerProvider provider) {
        jaxbPipelineProvider = provider;
    }

    private static synchronized JaxbTransformerProvider getJaxbPipelineProvider() {
        if (jaxbPipelineProvider == null) {
            PipelineFactory.loadJaxbTransformerProvider();
        }
        return jaxbPipelineProvider;
    }

    private static void loadJaxbTransformerProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.runtime.pipeline.impl.JaxbTransformerProviderImpl");
            PipelineFactory.setJaxbTransformerProvider((JaxbTransformerProvider)cls.newInstance());
        }
        catch (Exception e2) {
            throw new RuntimeException("Provider org.drools.runtime.pipeline.impl.JaxbTransformerProviderImpl could not be set.", e2);
        }
    }

    private static synchronized void setSmooksTransformerProvider(SmooksTransformerProvider provider) {
        smooksPipelineProvider = provider;
    }

    private static synchronized SmooksTransformerProvider getSmooksPipelineProvider() {
        if (smooksPipelineProvider == null) {
            PipelineFactory.loadSmooksTransformerProvider();
        }
        return smooksPipelineProvider;
    }

    private static void loadSmooksTransformerProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.runtime.pipeline.impl.SmooksTransformerProviderImpl");
            PipelineFactory.setSmooksTransformerProvider((SmooksTransformerProvider)cls.newInstance());
        }
        catch (Exception e2) {
            throw new RuntimeException("Provider org.drools.runtime.pipeline.impl.SmooksTransformerProviderImpl could not be set.", e2);
        }
    }

    private static synchronized void setXStreamTransformerProvider(XStreamTransformerProvider provider) {
        xstreamPipelineProvider = provider;
    }

    private static synchronized XStreamTransformerProvider getXStreamTransformerProvider() {
        if (xstreamPipelineProvider == null) {
            PipelineFactory.loadXStreamTransformerProvider();
        }
        return xstreamPipelineProvider;
    }

    private static void loadXStreamTransformerProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.runtime.pipeline.impl.XStreamTransformerProviderImpl");
            PipelineFactory.setXStreamTransformerProvider((XStreamTransformerProvider)cls.newInstance());
        }
        catch (Exception e2) {
            throw new RuntimeException("Provider org.drools.runtime.pipeline.impl.XStreamTransformerProviderImpl could not be set.", e2);
        }
    }

    private static synchronized void setJxlsTransformerProvider(JxlsTransformerProvider provider) {
        jxlsPipelineProvider = provider;
    }

    private static synchronized JxlsTransformerProvider getJxlsTransformerProvider() {
        if (jxlsPipelineProvider == null) {
            PipelineFactory.loadJxlsTransformerProvider();
        }
        return jxlsPipelineProvider;
    }

    private static void loadJxlsTransformerProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.runtime.pipeline.impl.JxlsTransformer$JxlsTransformerProviderImpl");
            PipelineFactory.setJxlsTransformerProvider((JxlsTransformerProvider)cls.newInstance());
        }
        catch (Exception e2) {
            throw new RuntimeException("Provider org.drools.runtime.pipeline.impl.JxlsTransformer$JxlsTransformerProviderImpl could not be set.", e2);
        }
    }

    private static synchronized void setJmsMessengerProvider(JmsMessengerProvider provider) {
        jmsMessengerProvider = provider;
    }

    private static synchronized JmsMessengerProvider getJmsMessengerProvider() {
        if (jmsMessengerProvider == null) {
            PipelineFactory.loadJmsMessengerProvider();
        }
        return jmsMessengerProvider;
    }

    private static void loadJmsMessengerProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.runtime.pipeline.impl.JmsMessengerProviderImpl");
            PipelineFactory.setJmsMessengerProvider((JmsMessengerProvider)cls.newInstance());
        }
        catch (Exception e2) {
            throw new RuntimeException("Provider org.drools.runtime.pipeline.impl.JmsMessengerProviderImpl could not be set.", e2);
        }
    }
}

