/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2;

import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.io.ResourceFactory;

public class PMMLUsageDemoTest
extends DroolsAbstractPMMLTest {
    private static final String pmmlSource = "org/drools/pmml/pmml_4_2/mock_cold_simple.xml";

    @Test
    public void invokePmmlWithRawData() {
        KieSession kSession = this.getModelSession(pmmlSource, false);
        kSession.getEntryPoint("in_Temp").insert((Object)22.0);
        kSession.fireAllRules();
        QueryResults qrs = kSession.getQueryResults("Cold", new Object[]{"MockCold", Variable.v});
        Assert.assertTrue((boolean)qrs.iterator().hasNext());
        Object val = ((QueryResultsRow)qrs.iterator().next()).get("$result");
        Assert.assertEquals((Object)0.56, (Object)val);
        QueryResults qrs2 = kSession.getQueryResults("Cold", new Object[]{"MockCold", 0.56});
        Assert.assertTrue((boolean)qrs2.iterator().hasNext());
        QueryResults qrs3 = kSession.getQueryResults("Cold", new Object[]{"MockCold", 0.99});
        Assert.assertFalse((boolean)qrs3.iterator().hasNext());
    }

    @Test
    public void invokePmmlWithTrait() {
        String extraDrl = "package org.drools.pmml.pmml_4_2.test;import org.drools.core.factmodel.traits.Entity;rule \"Init\" when    $s : String( this == \"trigger\" ) then    System.out.println( \"Trig\" );    Entity o = new Entity();    insert( o ); \n   MockColdTrait input = don( o, MockColdTrait.class );    modify( input ) {        setTemp( 22.0 );   } end rule Log when $x : MockColdTrait() then System.out.println( \"IN \" + $x ); end rule Log2 when $x : Cold() then System.out.println( \"OUT \" + $x ); end ";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(ResourceFactory.newClassPathResource((String)pmmlSource).setResourceType(ResourceType.PMML));
        kfs.write(ResourceFactory.newByteArrayResource((byte[])extraDrl.getBytes()).setSourcePath("rules.drl").setResourceType(ResourceType.DRL));
        Results res = ks.newKieBuilder(kfs).buildAll().getResults();
        if (res.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            System.out.println(res.getMessages(new Message.Level[]{Message.Level.ERROR}));
        }
        Assert.assertEquals((long)0L, (long)res.getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        KieSession kSession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        kSession.insert((Object)"trigger");
        kSession.fireAllRules();
        System.out.println(this.reportWMObjects(kSession));
        QueryResults qrs = kSession.getQueryResults("Cold", new Object[]{"MockCold", Variable.v});
        Assert.assertTrue((boolean)qrs.iterator().hasNext());
        Object val = ((QueryResultsRow)qrs.iterator().next()).get("$result");
        Assert.assertEquals((Object)0.56, (Object)val);
    }

    @Test
    public void invokePmmlWithTraitMissing() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(ResourceFactory.newClassPathResource((String)pmmlSource).setResourceType(ResourceType.PMML));
        Results res = ks.newKieBuilder(kfs).buildAll().getResults();
        if (res.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            System.out.println(res.getMessages(new Message.Level[]{Message.Level.ERROR}));
        }
        Assert.assertEquals((long)0L, (long)res.getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        KieSession kSession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        kSession.insert((Object)"trigger");
        kSession.fireAllRules();
        System.out.println(this.reportWMObjects(kSession));
    }
}

