/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2.transformations;

import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.definition.type.FactType;

public class DiscretizeFieldsTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = false;
    private static final String source = "org/drools/pmml/pmml_4_2/test_derived_fields_discretize.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_2.test";

    @Before
    public void setUp() throws Exception {
        this.setKSession(this.getModelSession(source, false));
        this.setKbase(this.getKSession().getKieBase());
    }

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testDiscretize() throws Exception {
        FactType age = this.getKbase().getFactType(packageName, "Age");
        FactType cat = this.getKbase().getFactType(packageName, "AgeCategories");
        Assert.assertNotNull((Object)this.getKSession().getEntryPoint("in_Age"));
        this.getKSession().getEntryPoint("in_Age").insert((Object)-1);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, true, null, -1);
        this.checkFirstDataFieldOfTypeStatus(cat, true, false, null, "infant");
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Age").insert((Object)1);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, 1);
        this.checkFirstDataFieldOfTypeStatus(cat, true, false, null, "infant");
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Age").insert((Object)9);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, 9);
        this.checkFirstDataFieldOfTypeStatus(cat, true, false, null, "young");
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Age").insert((Object)30);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, 30);
        this.checkFirstDataFieldOfTypeStatus(cat, true, false, null, "mature");
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Age").insert((Object)90);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, 90);
        this.checkFirstDataFieldOfTypeStatus(cat, true, false, null, "ancient");
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Age").insert((Object)3000);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, 3000);
        this.checkFirstDataFieldOfTypeStatus(cat, true, false, null, "ancient");
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Age").insert((Object)19);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, 19);
        this.checkFirstDataFieldOfTypeStatus(cat, true, false, null, "ancient");
        this.checkGeneratedRules();
    }
}

