/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2.global;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.drools.pmml.pmml_4_2.PMML4Compiler;
import org.drools.pmml.pmml_4_2.PMML4Helper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieSession;

public class HeaderTest
extends DroolsAbstractPMMLTest {
    @Test
    public void testPMMLHeader() {
        String source = PMML4Helper.pmmlDefaultPackageName().replace(".", File.separator) + File.separator + "test_header.xml";
        boolean header = false;
        boolean timestamp = false;
        boolean appl = false;
        boolean descr = false;
        boolean copyright = false;
        boolean annotation = false;
        PMML4Compiler compiler = new PMML4Compiler();
        compiler.getHelper().setPack("org.drools.pmml.pmml_4_2.test");
        String theory = compiler.compile(source, null);
        BufferedReader reader = new BufferedReader(new StringReader(theory));
        try {
            String line = "";
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("// Imported PMML Model Theory")) {
                    header = true;
                    continue;
                }
                if (line.startsWith("// Creation timestamp :")) {
                    timestamp = line.contains("now");
                    continue;
                }
                if (line.startsWith("// Description :")) {
                    descr = line.contains("test");
                    continue;
                }
                if (line.startsWith("// Copyright :")) {
                    copyright = line.contains("opensource");
                    continue;
                }
                if (line.startsWith("// Annotation :")) {
                    annotation = line.contains("notes here");
                    continue;
                }
                if (!line.startsWith("// Trained with :")) continue;
                appl = line.contains("handmade");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Assert.fail();
        }
        Assert.assertTrue((boolean)header);
        Assert.assertTrue((boolean)timestamp);
        Assert.assertTrue((boolean)descr);
        Assert.assertTrue((boolean)copyright);
        Assert.assertTrue((boolean)annotation);
        Assert.assertTrue((boolean)appl);
        KieSession ksession = this.getSession(theory);
        KiePackage pack = ksession.getKieBase().getKiePackage("org.drools.pmml.pmml_4_2.test");
        Assert.assertNotNull((Object)pack);
        ksession.dispose();
    }
}

