/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2.predictive;

import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.junit.After;
import org.junit.Test;

public class MiningSchemaTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source = "org/drools/pmml/pmml_4_2/test_miningSchema.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_2.test";

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testSchemaWithValidValues() throws Exception {
        this.setKSession(this.getModelSession(source, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        this.getKSession().getEntryPoint("in_Feat1").insert((Object)2.2);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat1"), true, false, "Test_MLP", 2.2);
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Feat2").insert((Object)5);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat2"), true, false, "Test_MLP", 5);
        this.checkGeneratedRules();
    }

    @Test
    public void testSchemaWithOutliers() throws Exception {
        this.setKSession(this.getModelSession(source, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().getEntryPoint("in_Feat1").insert((Object)0.24);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat1"), true, false, "Test_MLP", 1.0);
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Feat1").insert((Object)999.9);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat1"), true, false, "Test_MLP", 6.9);
        this.checkGeneratedRules();
    }

    @Test
    public void testSchemaWithInvalid() throws Exception {
        this.setKSession(this.getModelSession(source, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().getEntryPoint("in_Feat1").insert((Object)-37.0);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat1"), false, false, null, -37.0);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat1"), true, false, "Test_MLP", 3.95);
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Feat2").insert((Object)-1);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat2"), false, false, null, -1);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat2"), true, false, "Test_MLP", 5);
        this.checkGeneratedRules();
    }

    @Test
    public void testSchemaWithMissing() throws Exception {
        this.setKSession(this.getModelSession(source, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().getEntryPoint("in_Feat2").insert((Object)0);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat2"), false, true, null, 0);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat2"), true, false, "Test_MLP", 5);
        this.checkGeneratedRules();
    }

    @Test
    public void testSchemaWithMixedIntervalAndValues() throws Exception {
        this.setKSession(this.getModelSession(source, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        this.getKSession().getEntryPoint("in_Feat3").insert((Object)4.0);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat3"), true, false, "Test_MLP", 4.0);
        this.getKSession().getEntryPoint("in_Feat3").insert((Object)7.78);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat3"), true, false, "Test_MLP", 7.78);
        this.getKSession().getEntryPoint("in_Feat3").insert((Object)6.2);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Feat3"), false, false, "Test_MLP", 6.2);
        this.checkGeneratedRules();
    }
}

