/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.util.Collection;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.reliability.core.CacheManagerFactory;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.test.domain.Person;

@ExtendWith(value={BeforeAllMethodExtension.class})
class CachePersistenceTest
extends ReliabilityTestBasics {
    private static final String EMPTY_RULE = "global java.util.List results;\nrule R when\nthen\nend";

    CachePersistenceTest() {
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void removeAllSessionCaches_shouldRemoveAllSessionCachesEvenAfterFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 10);
        this.failover();
        Assertions.assertThat((Collection)CacheManagerFactory.get().getCacheManager().getCacheNames()).contains((Object[])new String[]{"session_0_epDEFAULT", "session_0_globals"});
        CacheManagerFactory.get().getCacheManager().removeAllSessionCaches();
        this.restoreSession(EMPTY_RULE, strategy, new Option[0]);
        Optional<Person> toshiya = this.getPersonByName(this.session, "Toshiya");
        Assertions.assertThat(toshiya).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void ksessionDispose_shouldRemoveCache(PersistedSessionOption.Strategy strategy) {
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 10);
        this.disposeSession();
        Assertions.assertThat((Collection)CacheManagerFactory.get().getCacheManager().getCacheNames()).allMatch(name -> !name.startsWith("session_"));
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void missingDispose_shouldNotReuseOrphanedCache(PersistedSessionOption.Strategy strategy) {
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 10);
        this.failover();
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        Optional<Person> toshiya = this.getPersonByName(this.session, "Toshiya");
        Assertions.assertThat(toshiya).isEmpty();
        this.failover();
        this.restoreSession(EMPTY_RULE, strategy, new Option[0]);
        toshiya = this.getPersonByName(this.session, "Toshiya");
        Assertions.assertThat(toshiya).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void reliableSessionCounter_shouldNotHaveTheSameIdAsPreviousKsession(PersistedSessionOption.Strategy strategy) {
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        long firstSessionId = this.session.getIdentifier();
        this.failover();
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        long secondSessionId = this.session.getIdentifier();
        Assertions.assertThat((long)secondSessionId).isNotEqualTo(firstSessionId);
    }
}

