/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.api.Assertions;
import org.drools.reliability.core.CacheManagerFactory;
import org.drools.reliability.core.TestableCacheManager;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.InfinispanCacheManager;
import org.drools.util.Config;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.extension.ExtendWith;

@DisabledIf(value="isRemote")
@ExtendWith(value={BeforeAllMethodExtension.class})
class EmbeddedCacheManagerTest {
    EmbeddedCacheManagerTest() {
    }

    @AfterEach
    public void tearDown() {
        ((TestableCacheManager)CacheManagerFactory.get().getCacheManager()).restart();
    }

    private static boolean isRemote() {
        return "REMOTE".equalsIgnoreCase(Config.getConfig((String)"drools.reliability.cache.mode"));
    }

    @Test
    void removeAllSessionCaches_shouldLeaveNonSessionCache() {
        ((InfinispanCacheManager)CacheManagerFactory.get().getCacheManager()).setEmbeddedCacheManager((DefaultCacheManager)new FakeCacheManager());
        Assertions.assertThat((Collection)CacheManagerFactory.get().getCacheManager().getCacheNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "session_1_epDefault", "METADATA_0"});
        CacheManagerFactory.get().getCacheManager().removeAllSessionCaches();
        Assertions.assertThat((Collection)CacheManagerFactory.get().getCacheManager().getCacheNames()).containsExactly((Object[])new String[]{"METADATA_0"});
    }

    @Test
    void removeCachesBySessionId_shouldRemoveSpecifiedCacheOnly() {
        ((InfinispanCacheManager)CacheManagerFactory.get().getCacheManager()).setEmbeddedCacheManager((DefaultCacheManager)new FakeCacheManager());
        Assertions.assertThat((Collection)CacheManagerFactory.get().getCacheManager().getCacheNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "session_1_epDefault", "METADATA_0"});
        CacheManagerFactory.get().getCacheManager().removeCachesBySessionId("1");
        Assertions.assertThat((Collection)CacheManagerFactory.get().getCacheManager().getCacheNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "METADATA_0"});
    }

    static {
        System.setProperty("drools.reliability.cache.allowedpackages", "org.test.domain");
    }

    public static class FakeCacheManager
    extends DefaultCacheManager {
        private Map<String, Object> cacheMap = new ConcurrentHashMap<String, Object>();

        public FakeCacheManager() {
            this.cacheMap.put("session_0_epDefault", new Object());
            this.cacheMap.put("session_1_epDefault", new Object());
            this.cacheMap.put("METADATA_0", new Object());
        }

        public Set<String> getCacheNames() {
            return this.cacheMap.keySet();
        }

        public boolean cacheExists(String cacheName) {
            return this.cacheMap.containsKey(cacheName);
        }

        public void removeCache(String cacheName) {
            this.cacheMap.remove(cacheName);
        }

        public void stop() {
        }
    }
}

