/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import org.assertj.core.api.Assertions;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.test.domain.Person;

@ExtendWith(value={BeforeAllMethodExtension.class})
class ReliabilityTest
extends ReliabilityTestBasics {
    private static final String BASIC_RULE = "import " + Person.class.getCanonicalName() + ";global java.util.List results;rule X when\n  $s: String()\n  $p: Person( getName().startsWith($s) )\nthen\n  results.add( $p.getName() );\nend";

    ReliabilityTest() {
    }

    @Test
    void createAndUseOfNonReliableSession_shouldWorkNormally() {
        this.createSession(BASIC_RULE, null, new Option[0]);
        this.insertString("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.insertNonMatchingPerson("Toshiya", 35);
        this.insertMatchingPerson("Matching Person Two", 40);
        this.session.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void insertFailoverInsertFire_shouldRecoverFromFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insertString("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 35);
        this.insertMatchingPerson("Matching Person Two", 40);
        this.session.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void noFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insertString("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 41);
        this.insertMatchingPerson("Matching Person Two", 40);
        this.session.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void insertFireInsertFailoverInsertFire_shouldMatchFactInsertedBeforeFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insertString("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.session.fireAllRules();
        this.insertMatchingPerson("Matching Person Two", 40);
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        this.clearResults();
        this.insertNonMatchingPerson("Toshiya", 35);
        this.insertMatchingPerson("Matching Person Three", 41);
        this.session.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person Two", "Matching Person Three"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void insertFireFailoverInsertFire_shouldNotRepeatFiredMatch(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insertString("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.session.fireAllRules();
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 35);
        this.insertMatchingPerson("Matching Person Two", 40);
        this.session.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void updateBeforeFailover_shouldRecoverFromFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insertString("M");
        Person p1 = new Person("Mario", 49);
        FactHandle fh1 = this.session.insert((Object)p1);
        Person p2 = new Person("Toshiya", 45);
        FactHandle fh2 = this.session.insert((Object)p2);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Mario"});
        p1.setName("SuperMario");
        this.session.update(fh1, (Object)p1);
        p2.setName("MegaToshiya");
        this.session.update(fh2, (Object)p2);
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Mario", "MegaToshiya"});
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        this.clearResults();
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(0);
        Assertions.assertThat(this.getResults()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void deleteBeforeFailover_shouldRecoverFromFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        FactHandle fhString = this.insertString("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.insertNonMatchingPerson("Toshiya", 35);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One"});
        this.session.delete(fhString);
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        this.clearResults();
        this.insertMatchingPerson("Matching Person Two", 40);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(0);
        Assertions.assertThat(this.getResults()).isEmpty();
        this.insertString("T");
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Toshiya"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void updateByObjectBeforeFailover_shouldMatchUpdatedFact(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insertString("M");
        this.insertMatchingPerson("Mark", 37);
        FactHandle fhNicole = this.insertNonMatchingPerson("Nicole", 32);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        this.updateWithMatchingPerson(fhNicole, new Person("Mary", 32));
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        this.failover();
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(0);
    }
}

