/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import org.assertj.core.api.Assertions;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.test.domain.Person;

@ExtendWith(value={BeforeAllMethodExtension.class})
public class ReliabilityTestUpdateInDrl
extends ReliabilityTestBasics {
    private static final String RULE_UPDATE = "import " + Person.class.getCanonicalName() + ";global java.util.List results;rule X when\n  $s: String()\n  $p: Person( getName().startsWith($s), getAge()>17 )\nthen\n  results.add( $p.getAge() );\nend\nrule Birthday when\n  $a: Integer()\n  $p: Person( getAge() == $a )\nthen\n  $p.setAge( $a + 1 );\n  update($p);\nend";

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void updateInRHS_insertFireFailoverFire_shouldMatchUpdatesFromFirstSession(PersistedSessionOption.Strategy strategy) {
        this.createSession(RULE_UPDATE, strategy, new Option[0]);
        this.insertString("M");
        this.insertMatchingPerson("Mike", 22);
        this.insertNonMatchingPerson("Eleven", 17);
        this.insertInteger(17);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(2);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{22});
        this.failover();
        this.restoreSession(RULE_UPDATE, strategy, new Option[0]);
        this.clearResults();
        this.insertString("E");
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{18});
        this.failover();
        this.restoreSession(RULE_UPDATE, strategy, new Option[0]);
        this.clearResults();
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(0);
        Assertions.assertThat(this.getResults()).isEmpty();
    }
}

