/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan.example;

import java.util.ArrayList;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.internal.utils.KieHelper;
import org.test.domain.Person;

public class RemoteCacheManagerExample {
    public static final String BASIC_RULE = "import " + Person.class.getCanonicalName() + ";global java.util.List results;rule X when\n  $s: String()\n  $p: Person( getName().startsWith($s) )\nthen\n  results.add( $p.getName() );\nend";

    public static void main(String[] args) {
        KieSession session = RemoteCacheManagerExample.getKieSession(PersistedSessionOption.newSession((PersistedSessionOption.Strategy)PersistedSessionOption.Strategy.STORES_ONLY));
        long savedSessionId = session.getIdentifier();
        System.out.println("savedSessionId = " + savedSessionId);
        session.insert((Object)"M");
        session.insert((Object)new Person("Mario", 40));
        System.out.println("Simulating a crash");
    }

    public static KieSession getKieSession(PersistedSessionOption option) {
        System.setProperty("drools.reliability.cache.mode", "REMOTE");
        System.setProperty("drools.reliability.cache.remote.host", "localhost");
        System.setProperty("drools.reliability.cache.remote.port", "11222");
        System.setProperty("drools.reliability.cache.remote.user", "admin");
        System.setProperty("drools.reliability.cache.remote.pass", "secret");
        System.setProperty("drools.reliability.cache.allowedpackages", "org.test.domain");
        KieBase kbase = new KieHelper().addContent(BASIC_RULE, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSessionConfiguration conf = KieServices.get().newKieSessionConfiguration();
        conf.setOption((Option)option);
        KieSession session = kbase.newKieSession(conf, null);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        return session;
    }
}

