/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.drools.core.common.ReteEvaluator;
import org.drools.reliability.core.CacheManager;
import org.drools.reliability.infinispan.InfinispanCacheManager;
import org.drools.util.Config;
import org.drools.util.FileUtils;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedCacheManager
implements InfinispanCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedCacheManager.class);
    public static final String GLOBAL_STATE_DIR = Config.getConfig((String)"drools.reliability.cache.dir", (String)"global/state");
    static final EmbeddedCacheManager INSTANCE = new EmbeddedCacheManager();
    private DefaultCacheManager embeddedCacheManager;
    private Configuration cacheConfiguration;
    public static final String CACHE_DIR = "cache";

    private EmbeddedCacheManager() {
    }

    public void initCacheManager() {
        LOG.info("Using Embedded Cache Manager");
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.serialization().marshaller((Marshaller)new JavaSerializationMarshaller()).allowList().addRegexps(InfinispanCacheManager.getAllowedPackages());
        global.globalState().enable().persistentLocation(GLOBAL_STATE_DIR).configurationStorage(ConfigurationStorage.OVERLAY);
        global.metrics().gauges(false);
        this.embeddedCacheManager = new DefaultCacheManager(global.build());
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        ((SoftIndexFileStoreConfigurationBuilder)builder.persistence().passivation(false).addSoftIndexFileStore().shared(false)).dataLocation("cache/data").indexLocation("cache/index");
        builder.clustering().cacheMode(CacheMode.LOCAL);
        builder.unsafe().unreliableReturnValues(true);
        this.cacheConfiguration = builder.build();
    }

    public <k, V> Cache<k, V> getOrCreateCacheForSession(ReteEvaluator reteEvaluator, String cacheName) {
        return this.embeddedCacheManager.administration().getOrCreateCache(CacheManager.createCacheId((ReteEvaluator)reteEvaluator, (String)cacheName), this.cacheConfiguration);
    }

    public <k, V> BasicCache<k, V> getOrCreateSharedCache(String cacheName) {
        return this.embeddedCacheManager.administration().getOrCreateCache("shared_" + cacheName, this.cacheConfiguration);
    }

    public void close() {
        this.embeddedCacheManager.stop();
    }

    public void removeCache(String cacheName) {
        if (this.embeddedCacheManager.cacheExists(cacheName)) {
            this.embeddedCacheManager.removeCache(cacheName);
        }
    }

    public void removeCachesBySessionId(String sessionId) {
        this.embeddedCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_" + sessionId + "_")).forEach(this::removeCache);
    }

    public void removeAllSessionCaches() {
        this.embeddedCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_")).forEach(this::removeCache);
    }

    public Set<String> getCacheNames() {
        return this.embeddedCacheManager.getCacheNames();
    }

    @Override
    public void setRemoteCacheManager(RemoteCacheManager remoteCacheManager) {
        throw new UnsupportedOperationException("setRemoteCacheManager is not supported in " + this.getClass());
    }

    public void restart() {
        this.embeddedCacheManager.stop();
        this.embeddedCacheManager = null;
        this.cacheConfiguration = null;
        this.initCacheManager();
    }

    public void restartWithCleanUp() {
        this.embeddedCacheManager.stop();
        this.embeddedCacheManager = null;
        this.cacheConfiguration = null;
        EmbeddedCacheManager.cleanUpGlobalStateAndFileStore();
        this.initCacheManager();
    }

    @Override
    public void setEmbeddedCacheManager(DefaultCacheManager embeddedCacheManager) {
        if (this.embeddedCacheManager != null) {
            this.embeddedCacheManager.stop();
        }
        this.embeddedCacheManager = embeddedCacheManager;
    }

    private static void cleanUpGlobalStateAndFileStore() {
        FileUtils.deleteDirectory((Path)Paths.get(GLOBAL_STATE_DIR, new String[0]));
    }

    @Override
    public ConfigurationBuilder provideAdditionalRemoteConfigurationBuilder() {
        throw new UnsupportedOperationException("provideRemoteConfigurationBuilder is not supported in " + this.getClass());
    }

    public boolean isRemote() {
        return false;
    }
}

