/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.api.Assertions;
import org.drools.reliability.CacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

class CacheManagerTest {
    CacheManagerTest() {
    }

    @AfterEach
    public void tearDown() {
        CacheManager.INSTANCE.restart();
    }

    @Test
    void removeAllSessionCaches_shouldLeaveNonSessionCache() {
        CacheManager.INSTANCE.setCacheManager((DefaultCacheManager)new FakeCacheManager());
        Assertions.assertThat((Collection)CacheManager.INSTANCE.getCacheNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "session_1_epDefault", "METADATA_0"});
        CacheManager.INSTANCE.removeAllSessionCaches();
        Assertions.assertThat((Collection)CacheManager.INSTANCE.getCacheNames()).containsExactly((Object[])new String[]{"METADATA_0"});
    }

    public static class FakeCacheManager
    extends DefaultCacheManager {
        private Map<String, Object> cacheMap = new ConcurrentHashMap<String, Object>();

        public FakeCacheManager() {
            this.cacheMap.put("session_0_epDefault", new Object());
            this.cacheMap.put("session_1_epDefault", new Object());
            this.cacheMap.put("METADATA_0", new Object());
        }

        public Set<String> getCacheNames() {
            return this.cacheMap.keySet();
        }

        public boolean cacheExists(String cacheName) {
            return this.cacheMap.containsKey(cacheName);
        }

        public void removeCache(String cacheName) {
            this.cacheMap.remove(cacheName);
        }

        public void stop() {
        }
    }
}

