/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.reliability.BeforeAllMethodExtension;
import org.drools.reliability.CacheManager;
import org.drools.reliability.Person;
import org.drools.reliability.ReliabilityTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.utils.KieHelper;

@ExtendWith(value={BeforeAllMethodExtension.class})
class ReliabilityTest {
    private static final String BASIC_RULE = "import " + Person.class.getCanonicalName() + ";global java.util.List results;rule X when\n  $s: String()\n  $p: Person( getName().startsWith($s) )\nthen\n  results.add( $p.getName() );\nend";
    private long savedSessionId;
    private KieSession session;

    ReliabilityTest() {
    }

    static Stream<PersistedSessionOption.Strategy> strategyProvider() {
        return Stream.of(PersistedSessionOption.Strategy.STORES_ONLY, PersistedSessionOption.Strategy.FULL);
    }

    static Stream<PersistedSessionOption.Strategy> strategyProviderStoresOnly() {
        return Stream.of(PersistedSessionOption.Strategy.STORES_ONLY);
    }

    @AfterEach
    public void tearDown() {
        CacheManager.INSTANCE.removeAllSessionCaches();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void insertFailoverInsertFire_shouldRecoverFromFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy);
        this.insertString();
        this.insertMatchingPersonOne();
        ReliabilityTestUtils.failover();
        this.restoreSession(BASIC_RULE, strategy);
        this.insertNonMatchingPerson();
        this.insertMatchingPersonTwo();
        this.session.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProvider"})
    void noFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy);
        this.insertString();
        this.insertMatchingPersonOne();
        this.restoreSession(BASIC_RULE, strategy);
        this.insertNonMatchingPerson();
        this.insertMatchingPersonTwo();
        this.session.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void insertFireInsertFailoverInsertFire_shouldMatchFactInsertedBeforeFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy);
        this.insertString();
        this.insertMatchingPersonOne();
        this.session.fireAllRules();
        this.insertMatchingPersonTwo();
        ReliabilityTestUtils.failover();
        this.restoreSession(BASIC_RULE, strategy);
        this.insertNonMatchingPerson();
        this.insertMatchingPersonThree();
        this.session.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"Matching Person Two", "Matching Person Three"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void insertFireFailoverInsertFire_shouldNotRepeatFiredMatch(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy);
        this.insertString();
        this.insertMatchingPersonOne();
        this.session.fireAllRules();
        ReliabilityTestUtils.failover();
        this.restoreSession(BASIC_RULE, strategy);
        this.insertNonMatchingPerson();
        this.insertMatchingPersonTwo();
        this.session.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void updateBeforeFailover_shouldRecoverFromFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy);
        this.insertString();
        Person p1 = new Person("Mario", 49);
        FactHandle fh1 = this.session.insert((Object)p1);
        Person p2 = new Person("Toshiya", 45);
        FactHandle fh2 = this.session.insert((Object)p2);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"Mario"});
        p1.setName("SuperMario");
        this.session.update(fh1, (Object)p1);
        p2.setName("MegaToshiya");
        this.session.update(fh2, (Object)p2);
        ReliabilityTestUtils.failover();
        this.restoreSession(BASIC_RULE, strategy);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"MegaToshiya"});
        ReliabilityTestUtils.failover();
        this.restoreSession(BASIC_RULE, strategy);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(0);
        Assertions.assertThat(this.getResults()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void deleteBeforeFailover_shouldRecoverFromFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy);
        FactHandle fhString = this.insertString();
        this.insertMatchingPersonOne();
        this.insertNonMatchingPerson();
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"Matching Person One"});
        this.session.delete(fhString);
        ReliabilityTestUtils.failover();
        this.restoreSession(BASIC_RULE, strategy);
        this.insertMatchingPersonTwo();
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(0);
        Assertions.assertThat(this.getResults()).isEmpty();
        this.session.insert((Object)"T");
        ReliabilityTestUtils.failover();
        this.restoreSession(BASIC_RULE, strategy);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"Toshiya"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void updateByObjectBeforeFailover_shouldMatchUpdatedFact(PersistedSessionOption.Strategy strategy) {
        this.createSession(BASIC_RULE, strategy);
        this.session.insert((Object)"M");
        this.session.insert((Object)new Person("Mark", 37));
        FactHandle fhNicole = this.session.insert((Object)new Person("Nicole", 32));
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        this.session.update(fhNicole, (Object)new Person("Mary", 32));
        ReliabilityTestUtils.failover();
        this.restoreSession(BASIC_RULE, strategy);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        ReliabilityTestUtils.failover();
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(0);
    }

    private FactHandle insertString() {
        return this.session.insert((Object)"M");
    }

    private void insertMatchingPersonOne() {
        this.session.insert((Object)new Person("Matching Person One", 37));
    }

    private void insertMatchingPersonTwo() {
        this.session.insert((Object)new Person("Matching Person Two", 40));
    }

    private void insertMatchingPersonThree() {
        this.session.insert((Object)new Person("Matching Person Three", 41));
    }

    private void insertNonMatchingPerson() {
        this.session.insert((Object)new Person("Toshiya", 35));
    }

    private List<String> getResults() {
        return (List)this.session.getGlobal("results");
    }

    private KieSession createSession(String drl, PersistedSessionOption.Strategy strategy) {
        this.getKieSession(drl, PersistedSessionOption.newSession((PersistedSessionOption.Strategy)strategy));
        this.savedSessionId = this.session.getIdentifier();
        return this.session;
    }

    private KieSession restoreSession(String drl, PersistedSessionOption.Strategy strategy) {
        return this.getKieSession(drl, PersistedSessionOption.fromSession((long)this.savedSessionId, (PersistedSessionOption.Strategy)strategy));
    }

    private KieSession getKieSession(String drl, PersistedSessionOption option) {
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSessionConfiguration conf = KieServices.get().newKieSessionConfiguration();
        conf.setOption((Option)option);
        this.session = kbase.newKieSession(conf, null);
        ArrayList results = new ArrayList();
        this.session.setGlobal("results", results);
        return this.session;
    }
}

