/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.drools.core.ClassObjectFilter;
import org.drools.reliability.BeforeAllMethodExtension;
import org.drools.reliability.CacheManager;
import org.drools.reliability.Person;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.utils.KieHelper;

@ExtendWith(value={BeforeAllMethodExtension.class})
public abstract class ReliabilityTestBasics {
    protected long savedSessionId;
    protected KieSession session;

    static Stream<PersistedSessionOption.Strategy> strategyProvider() {
        return Stream.of(PersistedSessionOption.Strategy.STORES_ONLY, PersistedSessionOption.Strategy.FULL);
    }

    static Stream<PersistedSessionOption.Strategy> strategyProviderStoresOnly() {
        return Stream.of(PersistedSessionOption.Strategy.STORES_ONLY);
    }

    @AfterEach
    public void tearDown() {
        CacheManager.INSTANCE.removeAllSessionCaches();
    }

    protected FactHandle insertString(String str) {
        this.session.insert((Object)str);
        return null;
    }

    protected FactHandle insertInteger(Integer number) {
        this.session.insert((Object)number);
        return null;
    }

    protected FactHandle insertMatchingPerson(String name, Integer age) {
        return this.session.insert((Object)new Person(name, age));
    }

    protected void updateWithMatchingPerson(FactHandle nonMatching, Object matching) {
        this.session.update(nonMatching, matching);
    }

    protected void updateWithNonMatchingPerson(FactHandle matching, Object nonMatching) {
        this.session.update(matching, nonMatching);
    }

    protected FactHandle insertNonMatchingPerson(String name, Integer age) {
        return this.session.insert((Object)new Person(name, age));
    }

    protected List<Object> getResults() {
        return (List)this.session.getGlobal("results");
    }

    protected KieSession createSession(String drl, PersistedSessionOption.Strategy strategy) {
        this.getKieSession(drl, PersistedSessionOption.newSession((PersistedSessionOption.Strategy)strategy));
        this.savedSessionId = this.session.getIdentifier();
        return this.session;
    }

    protected KieSession restoreSession(String drl, PersistedSessionOption.Strategy strategy) {
        return this.getKieSession(drl, PersistedSessionOption.fromSession((long)this.savedSessionId, (PersistedSessionOption.Strategy)strategy));
    }

    protected KieSession getKieSession(String drl, PersistedSessionOption option) {
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSessionConfiguration conf = KieServices.get().newKieSessionConfiguration();
        conf.setOption((Option)option);
        this.session = kbase.newKieSession(conf, null);
        ArrayList results = new ArrayList();
        this.session.setGlobal("results", results);
        return this.session;
    }

    protected Optional<Person> getPersonByName(KieSession kieSession, String name) {
        return kieSession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)).stream().map(Person.class::cast).filter(p -> p.getName().equals(name)).findFirst();
    }
}

