/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import org.assertj.core.api.Assertions;
import org.drools.reliability.BeforeAllMethodExtension;
import org.drools.reliability.Person;
import org.drools.reliability.ReliabilityTestBasics;
import org.drools.reliability.ReliabilityTestUtils;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.runtime.conf.PersistedSessionOption;

@ExtendWith(value={BeforeAllMethodExtension.class})
public class ReliabilityTestUpdateInDrl
extends ReliabilityTestBasics {
    private static final String RULE_UPDATE = "import " + Person.class.getCanonicalName() + ";global java.util.List results;rule X when\n  $s: String()\n  $p: Person( getName().startsWith($s), getAge()>17 )\nthen\n  results.add( $p.getAge() );\nend\nrule Birthday when\n  $a: Integer()\n  $p: Person( getAge() == $a )\nthen\n  $p.setAge( $a + 1 );\n  update($p);\nend";

    @Disabled(value="fails in the 2nd assertion, will run successfully after PR#5093 is merged ")
    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void updateInRHS_insertFireFailoverFire_shouldMatchUpdatesFromFirstSession(PersistedSessionOption.Strategy strategy) {
        this.createSession(RULE_UPDATE, strategy);
        this.insertString("M");
        this.insertMatchingPerson("Mike", 22);
        this.insertNonMatchingPerson("Eleven", 17);
        this.insertInteger(17);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(2);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{22});
        ReliabilityTestUtils.failover();
        this.restoreSession(RULE_UPDATE, strategy);
        this.insertString("E");
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{18});
        ReliabilityTestUtils.failover();
        this.restoreSession(RULE_UPDATE, strategy);
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(0);
        Assertions.assertThat(this.getResults()).isEmpty();
    }
}

