/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.api.Assertions;
import org.drools.reliability.BeforeAllMethodExtension;
import org.drools.reliability.CacheManagerFactory;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.extension.ExtendWith;

@DisabledIf(value="isRemote")
@ExtendWith(value={BeforeAllMethodExtension.class})
class EmbeddedCacheManagerTest {
    EmbeddedCacheManagerTest() {
    }

    @AfterEach
    public void tearDown() {
        CacheManagerFactory.INSTANCE.getCacheManager().restart();
    }

    private static boolean isRemote() {
        return "REMOTE".equalsIgnoreCase(System.getProperty("drools.reliability.cache.mode"));
    }

    @Test
    void removeAllSessionCaches_shouldLeaveNonSessionCache() {
        CacheManagerFactory.INSTANCE.getCacheManager().setEmbeddedCacheManager((DefaultCacheManager)new FakeCacheManager());
        Assertions.assertThat((Collection)CacheManagerFactory.INSTANCE.getCacheManager().getCacheNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "session_1_epDefault", "METADATA_0"});
        CacheManagerFactory.INSTANCE.getCacheManager().removeAllSessionCaches();
        Assertions.assertThat((Collection)CacheManagerFactory.INSTANCE.getCacheManager().getCacheNames()).containsExactly((Object[])new String[]{"METADATA_0"});
    }

    @Test
    void removeCachesBySessionId_shouldRemoveSpecifiedCacheOnly() {
        CacheManagerFactory.INSTANCE.getCacheManager().setEmbeddedCacheManager((DefaultCacheManager)new FakeCacheManager());
        Assertions.assertThat((Collection)CacheManagerFactory.INSTANCE.getCacheManager().getCacheNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "session_1_epDefault", "METADATA_0"});
        CacheManagerFactory.INSTANCE.getCacheManager().removeCachesBySessionId("1");
        Assertions.assertThat((Collection)CacheManagerFactory.INSTANCE.getCacheManager().getCacheNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "METADATA_0"});
    }

    static {
        System.setProperty("drools.reliability.cache.allowedpackages", "org.test.domain");
    }

    public static class FakeCacheManager
    extends DefaultCacheManager {
        private Map<String, Object> cacheMap = new ConcurrentHashMap<String, Object>();

        public FakeCacheManager() {
            this.cacheMap.put("session_0_epDefault", new Object());
            this.cacheMap.put("session_1_epDefault", new Object());
            this.cacheMap.put("METADATA_0", new Object());
        }

        public Set<String> getCacheNames() {
            return this.cacheMap.keySet();
        }

        public boolean cacheExists(String cacheName) {
            return this.cacheMap.containsKey(cacheName);
        }

        public void removeCache(String cacheName) {
            this.cacheMap.remove(cacheName);
        }

        public void stop() {
        }
    }
}

