/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.reliability.BeforeAllMethodExtension;
import org.drools.reliability.ReliabilityTestBasics;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.time.SessionPseudoClock;
import org.test.domain.StockTick;

@ExtendWith(value={BeforeAllMethodExtension.class})
class ReliabilityCepTest
extends ReliabilityTestBasics {
    private static final String CEP_RULE = "import " + StockTick.class.getCanonicalName() + ";global java.util.List results;rule R when\n    $a : StockTick( company == \"DROO\" )\n    $b : StockTick( company == \"ACME\", this after[5s,8s] $a )\nthen\n    results.add(\"fired\");\nend\n";

    ReliabilityCepTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void insertAdvanceInsertFailoverFire_shouldRecoverFromFailover(PersistedSessionOption.Strategy strategy) {
        this.createSession(CEP_RULE, strategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        SessionPseudoClock clock = (SessionPseudoClock)this.session.getSessionClock();
        this.session.insert((Object)new StockTick("DROO"));
        clock.advanceTime(6L, TimeUnit.SECONDS);
        this.session.insert((Object)new StockTick("ACME"));
        this.failover();
        this.restoreSession(CEP_RULE, strategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        clock = (SessionPseudoClock)this.session.getSessionClock();
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"fired"});
        this.clearResults();
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.session.insert((Object)new StockTick("ACME"));
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"fired"});
        this.clearResults();
        clock.advanceTime(3L, TimeUnit.SECONDS);
        this.session.insert((Object)new StockTick("ACME"));
        Assertions.assertThat((int)this.session.fireAllRules()).isEqualTo(0);
        Assertions.assertThat(this.getResults()).isEmpty();
    }
}

