/*
 * Decompiled with CFR 0.152.
 */
package org.drools.resource;

import java.io.ByteArrayOutputStream;
import org.drools.resource.BaseResourceHandler;
import org.drools.resource.RepositoryBean;
import org.drools.resource.ResourceHandler;
import org.drools.resource.ResourceType;
import org.drools.resource.exception.ResourceAccessDeniedException;
import org.drools.resource.exception.ResourceTypeNotSupportedException;
import org.drools.resource.exception.ResourceUrlNotFoundException;
import org.drools.resource.util.SvnUtil;
import org.tmatesoft.svn.core.SVNException;

public class SvnResourceHandler
extends BaseResourceHandler
implements ResourceHandler {
    private String username = "";
    private String password = "";

    public boolean authenticate(String url) {
        return SvnUtil.authenticate(this.username, this.password, url);
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public ByteArrayOutputStream getResourceStream(RepositoryBean aRepositoryBean) throws ResourceUrlNotFoundException, ResourceTypeNotSupportedException, ResourceAccessDeniedException {
        ByteArrayOutputStream baos;
        String url = new String();
        try {
            url = this.getResourceURL(aRepositoryBean);
            if (!this.authenticate(url)) {
                throw new ResourceAccessDeniedException(url, this.username, this.password);
            }
            baos = SvnUtil.getFileContentsFromSvn(url, this.username, this.password, aRepositoryBean.getVersionInLong());
        }
        catch (SVNException e) {
            e.printStackTrace();
            throw new ResourceUrlNotFoundException(url);
        }
        catch (ResourceTypeNotSupportedException exc) {
            throw exc;
        }
        return baos;
    }

    public String getResourceURL(RepositoryBean aRepositoryBean) throws ResourceTypeNotSupportedException {
        StringBuffer urlBuf = new StringBuffer(this.repositoryUrl);
        if (aRepositoryBean.getResourceType() == ResourceType.DRL_FILE) {
            urlBuf.append("/drls/");
            urlBuf.append(aRepositoryBean.getName());
            urlBuf.append(".drl");
        } else if (aRepositoryBean.getResourceType() == ResourceType.FUNCTION) {
            urlBuf.append("/functions/");
            urlBuf.append(aRepositoryBean.getName());
            urlBuf.append(".function");
        } else if (aRepositoryBean.getResourceType() == ResourceType.RULE) {
            urlBuf.append("/rules/");
            urlBuf.append(aRepositoryBean.getName());
            urlBuf.append(".rule");
        } else if (aRepositoryBean.getResourceType() == ResourceType.DSL_FILE) {
            urlBuf.append("/dsls/");
            urlBuf.append(aRepositoryBean.getName());
            urlBuf.append(".dsl");
        } else if (aRepositoryBean.getResourceType() == ResourceType.XLS_FILE) {
            urlBuf.append("/spreadsheets/");
            urlBuf.append(aRepositoryBean.getName());
            urlBuf.append(".xls");
        } else {
            throw new ResourceTypeNotSupportedException(urlBuf.toString());
        }
        return urlBuf.toString();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setRepositoryUrl(String url) {
        this.repositoryUrl = url;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }
}

