/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;

public class ArchiveItemTest
extends TestCase {
    private RulesRepository getRepo() {
        return RepositorySessionUtil.getRepository();
    }

    private PackageItem getDefaultPackage() {
        return this.getRepo().loadDefaultPackage();
    }

    public void testFindArchivedAssets() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadDefaultPackage().addAsset("testFindArchivedAssets1", "X");
        repo.loadDefaultPackage().addAsset("testFindArchivedAssets2", "X");
        repo.loadDefaultPackage().addAsset("testFindArchivedAssets3", "X");
        repo.loadDefaultPackage().addAsset("testFindArchivedAssets4", "X");
        AssetItem item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testFindArchivedAssets1");
        ArchiveItemTest.assertFalse((boolean)item.isArchived());
        item.archiveItem(true);
        item.checkin("archiving item 1");
        item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testFindArchivedAssets1");
        ArchiveItemTest.assertTrue((boolean)item.isArchived());
        item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testFindArchivedAssets2");
        ArchiveItemTest.assertFalse((boolean)item.isArchived());
        item.archiveItem(true);
        item.checkin("archiving item 1");
        item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testFindArchivedAssets2");
        ArchiveItemTest.assertTrue((boolean)item.isArchived());
        item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testFindArchivedAssets3");
        ArchiveItemTest.assertFalse((boolean)item.isArchived());
        item.archiveItem(true);
        item.checkin("archiving item 1");
        item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testFindArchivedAssets3");
        ArchiveItemTest.assertTrue((boolean)item.isArchived());
        AssetItemIterator it = repo.findArchivedAssets();
        List list = this.iteratorToList((Iterator)it);
        ArchiveItemTest.assertEquals((int)3, (int)list.size());
    }

    public void testArchiveBooleanFlag() throws Exception {
        AssetItem item = RepositorySessionUtil.getRepository().loadDefaultPackage().addAsset("testArchiveBooleanFlag", "yeah");
        ArchiveItemTest.assertFalse((boolean)item.isArchived());
        item.archiveItem(true);
        ArchiveItemTest.assertFalse((boolean)item.getNode().hasProperty("drools:content"));
        ArchiveItemTest.assertTrue((boolean)item.getNode().hasProperty("drools:archive"));
        ArchiveItemTest.assertTrue((boolean)item.isArchived());
        item.checkin("lalalala");
    }

    public void testLoadArchivedAsset() throws Exception {
        AssetItem item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testArchiveBooleanFlag");
        System.out.println(item);
        ArchiveItemTest.assertTrue((boolean)item.isArchived());
    }

    public void testFindArchivedAssetsByCategory() {
        this.getRepo().loadCategory("/").addCategory("testFindRulesByCatArchive", "yeah");
        AssetItem as1 = this.getDefaultPackage().addAsset("testFindRulesByCategoryArch", "ya", "testFindRulesByCatArchive", "drl");
        this.getDefaultPackage().addAsset("testFindRulesByCategoryArch2", "ya", "testFindRulesByCatArchive", "txt").checkin("version0");
        as1.archiveItem(true);
        as1.checkin("version0");
        ArchiveItemTest.assertEquals((String)"drl", (String)as1.getFormat());
        List rules = this.getRepo().findAssetsByCategory("testFindRulesByCatArchive");
        ArchiveItemTest.assertEquals((int)1, (int)rules.size());
        List rules1 = this.getRepo().findAssetsByCategory("testFindRulesByCatArchive", true);
        ArchiveItemTest.assertEquals((int)2, (int)rules1.size());
    }

    List iteratorToList(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public void testLoadPackages() {
        RulesRepository repo = this.getRepo();
        PackageItem item = repo.createPackage("testListPackagesblah", "lalalala");
        ArchiveItemTest.assertNotNull((Object)item.getCreator());
        ArchiveItemTest.assertFalse((boolean)item.getCreator().equals(""));
        List list = this.iteratorToList(repo.listPackages());
        int prevSize = list.size();
        repo.createPackage("testListPackages2blah", "abc");
        repo.loadPackage("testListPackages2blah").archiveItem(true);
        repo.createPackage("testListPackages2blah1", "abc");
        repo.createPackage("testListPackages2blah3", "abc");
        repo.createPackage("testListPackages2blah7", "abc");
        PackageIterator localIterator = (PackageIterator)repo.listPackages();
        list = this.iteratorToList((Iterator)localIterator);
        ArchiveItemTest.assertEquals((int)(prevSize + 3), (int)list.size());
        localIterator = (PackageIterator)repo.listPackages();
        localIterator.setArchivedIterator(true);
        list = this.iteratorToList((Iterator)localIterator);
        ArchiveItemTest.assertEquals((int)(prevSize + 4), (int)list.size());
    }

    public void testFindRulesByNameArchived() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadDefaultPackage().addAsset("findRulesByNameArchived1", "X");
        repo.loadDefaultPackage().addAsset("findRulesByNameArchived2", "X");
        repo.save();
        AssetItem item2 = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("findRulesByNameArchived1");
        ArchiveItemTest.assertFalse((boolean)item2.isArchived());
        item2.archiveItem(true);
        List list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived1"));
        ArchiveItemTest.assertEquals((int)1, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived1", true));
        ArchiveItemTest.assertEquals((int)1, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived2"));
        ArchiveItemTest.assertEquals((int)1, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived%"));
        ArchiveItemTest.assertEquals((int)2, (int)list.size());
        repo.createPackageSnapshot("defaultPackage", "testFindRulesByName2");
        repo.save();
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived2"));
        AssetItem item = (AssetItem)list.get(0);
        ArchiveItemTest.assertEquals((String)"findRulesByNameArchived2", (String)item.getName());
        ArchiveItemTest.assertEquals((String)"X", (String)item.getDescription());
        ArchiveItemTest.assertEquals((int)1, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived1", true));
        ArchiveItemTest.assertEquals((int)1, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived1"));
        ArchiveItemTest.assertEquals((int)0, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived%"));
        ArchiveItemTest.assertEquals((int)1, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived%", true));
        ArchiveItemTest.assertEquals((int)2, (int)list.size());
    }

    public void testlistbyformatArchived() {
    }
}

