/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.Credentials;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import junit.framework.TestCase;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;

public class RulesRepositoryTest
extends TestCase {
    public void testDefaultPackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        Iterator it = repo.listPackages();
        boolean foundDefault = false;
        while (it.hasNext()) {
            PackageItem item = (PackageItem)it.next();
            if (!item.getName().equals("defaultPackage")) continue;
            foundDefault = true;
        }
        RulesRepositoryTest.assertTrue((boolean)foundDefault);
        PackageItem def = repo.loadDefaultPackage();
        RulesRepositoryTest.assertNotNull((Object)def);
        RulesRepositoryTest.assertEquals((String)"defaultPackage", (String)def.getName());
        String userId = repo.getSession().getUserID();
        RulesRepositoryTest.assertNotNull((Object)userId);
        RulesRepositoryTest.assertFalse((boolean)userId.equals(""));
    }

    public void testAddVersionARule() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pack = repo.createPackage("testAddVersionARule", "description");
        repo.save();
        AssetItem rule = pack.addAsset("my rule", "foobar");
        RulesRepositoryTest.assertEquals((String)"my rule", (String)rule.getName());
        rule.updateContent("foo foo");
        rule.checkin("version0");
        pack.addAsset("other rule", "description");
        rule.updateContent("foo bar");
        rule.checkin("version1");
        PackageItem pack2 = repo.loadPackage("testAddVersionARule");
        Iterator it = pack2.getAssets();
        it.next();
        it.next();
        RulesRepositoryTest.assertFalse((boolean)it.hasNext());
        AssetItem prev = (AssetItem)rule.getPrecedingVersion();
        RulesRepositoryTest.assertEquals((String)"foo bar", (String)rule.getContent());
        RulesRepositoryTest.assertEquals((String)"foo foo", (String)prev.getContent());
    }

    public void testFindRulesByName() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadDefaultPackage().addAsset("findRulesByNamex1", "X");
        repo.loadDefaultPackage().addAsset("findRulesByNamex2", "X");
        repo.save();
        List list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNamex1"));
        RulesRepositoryTest.assertEquals((int)1, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNamex2"));
        RulesRepositoryTest.assertEquals((int)1, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNamex%"));
        RulesRepositoryTest.assertEquals((int)2, (int)list.size());
        repo.createPackageSnapshot("defaultPackage", "testFindRulesByName");
        repo.save();
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNamex2"));
        AssetItem item = (AssetItem)list.get(0);
        RulesRepositoryTest.assertEquals((String)"findRulesByNamex2", (String)item.getName());
        RulesRepositoryTest.assertEquals((String)"X", (String)item.getDescription());
        RulesRepositoryTest.assertEquals((int)1, (int)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNamex%"));
        RulesRepositoryTest.assertEquals((int)2, (int)list.size());
    }

    public void testLoadRuleByUUIDWithConcurrentSessions() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem rulePackageItem = repo.loadDefaultPackage();
        AssetItem rule = rulePackageItem.addAsset("testLoadRuleByUUID", "this is a description");
        repo.save();
        String uuid = rule.getNode().getUUID();
        AssetItem loaded = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertNotNull((Object)loaded);
        RulesRepositoryTest.assertEquals((String)"testLoadRuleByUUID", (String)loaded.getName());
        RulesRepositoryTest.assertEquals((String)"this is a description", (String)loaded.getDescription());
        long oldVersionNumber = loaded.getVersionNumber();
        loaded.updateContent("xxx");
        loaded.checkin("woo");
        AssetItem reload = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"testLoadRuleByUUID", (String)reload.getName());
        RulesRepositoryTest.assertEquals((String)"xxx", (String)reload.getContent());
        System.out.println(reload.getVersionNumber());
        System.out.println(loaded.getVersionNumber());
        RulesRepositoryTest.assertFalse((reload.getVersionNumber() == oldVersionNumber ? 1 : 0) != 0);
        try {
            repo.loadAssetByUUID("01010101-0101-0101-0101-010101010101");
            RulesRepositoryTest.fail((String)"Exception not thrown loading rule package that was not created.");
        }
        catch (RulesRepositoryException e) {
            RulesRepositoryTest.assertNotNull((Object)e.getMessage());
        }
        AssetItem asset1 = repo.loadDefaultPackage().addAsset("testMultiSession", "description");
        asset1.updateContent("yeah");
        asset1.checkin("boo");
        uuid = asset1.getUUID();
        asset1.updateState("Draft");
        repo.save();
        Session s2 = repo.getSession().getRepository().login((Credentials)new SimpleCredentials("fdd", "password".toCharArray()));
        RulesRepository repo2 = new RulesRepository(s2);
        AssetItem asset2 = repo2.loadAssetByUUID(uuid);
        asset2.updateContent("yeah 42");
        asset2.checkin("yeah");
        asset1 = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"yeah 42", (String)asset1.getContent());
        asset1.updateContent("yeah 43");
        asset1.checkin("la");
        asset2 = repo2.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"yeah 43", (String)asset2.getContent());
    }

    public void testAddRuleCalendarWithDates() {
        RulesRepository rulesRepository = RepositorySessionUtil.getRepository();
        Calendar effectiveDate = Calendar.getInstance();
        Calendar expiredDate = Calendar.getInstance();
        expiredDate.setTimeInMillis(effectiveDate.getTimeInMillis() + 86400000L);
        AssetItem ruleItem1 = rulesRepository.loadDefaultPackage().addAsset("testAddRuleCalendarCalendar", "desc");
        ruleItem1.updateDateEffective(effectiveDate);
        ruleItem1.updateDateExpired(expiredDate);
        RulesRepositoryTest.assertNotNull((Object)ruleItem1);
        RulesRepositoryTest.assertNotNull((Object)ruleItem1.getNode());
        RulesRepositoryTest.assertEquals((Object)effectiveDate, (Object)ruleItem1.getDateEffective());
        RulesRepositoryTest.assertEquals((Object)expiredDate, (Object)ruleItem1.getDateExpired());
        ruleItem1.checkin("ho ");
    }

    public void testGetState() {
        RulesRepository rulesRepository = RepositorySessionUtil.getRepository();
        StateItem state0 = rulesRepository.createState("testGetState");
        RulesRepositoryTest.assertNotNull((Object)state0);
        RulesRepositoryTest.assertEquals((String)"testGetState", (String)state0.getName());
        StateItem stateItem1 = rulesRepository.getState("testGetState");
        RulesRepositoryTest.assertNotNull((Object)stateItem1);
        RulesRepositoryTest.assertEquals((String)"testGetState", (String)stateItem1.getName());
        StateItem stateItem2 = rulesRepository.getState("testGetState");
        RulesRepositoryTest.assertNotNull((Object)stateItem2);
        RulesRepositoryTest.assertEquals((String)"testGetState", (String)stateItem2.getName());
        RulesRepositoryTest.assertEquals((Object)stateItem1, (Object)stateItem2);
    }

    public void testGetTag() {
        RulesRepository rulesRepository = RepositorySessionUtil.getRepository();
        CategoryItem root = rulesRepository.loadCategory("/");
        CategoryItem tagItem1 = root.addCategory("testGetTag", "ho");
        RulesRepositoryTest.assertNotNull((Object)tagItem1);
        RulesRepositoryTest.assertEquals((String)"testGetTag", (String)tagItem1.getName());
        RulesRepositoryTest.assertEquals((String)"testGetTag", (String)tagItem1.getFullPath());
        CategoryItem tagItem2 = rulesRepository.loadCategory("testGetTag");
        RulesRepositoryTest.assertNotNull((Object)tagItem2);
        RulesRepositoryTest.assertEquals((String)"testGetTag", (String)tagItem2.getName());
        RulesRepositoryTest.assertEquals((Object)tagItem1, (Object)tagItem2);
        CategoryItem tagItem3 = tagItem2.addCategory("TestChildTag1", "ka");
        RulesRepositoryTest.assertNotNull((Object)tagItem3);
        RulesRepositoryTest.assertEquals((String)"TestChildTag1", (String)tagItem3.getName());
        RulesRepositoryTest.assertEquals((String)"testGetTag/TestChildTag1", (String)tagItem3.getFullPath());
    }

    public void testListPackages() {
        RulesRepository rulesRepository = RepositorySessionUtil.getRepository();
        rulesRepository.createPackage("testListPackages", "desc");
        RulesRepositoryTest.assertTrue((boolean)rulesRepository.containsPackage("testListPackages"));
        RulesRepositoryTest.assertFalse((boolean)rulesRepository.containsPackage("XXXXXXX"));
        Iterator it = rulesRepository.listPackages();
        RulesRepositoryTest.assertTrue((boolean)it.hasNext());
        boolean found = false;
        while (it.hasNext()) {
            PackageItem element = (PackageItem)it.next();
            if (element.getName().equals("testListPackages")) {
                found = true;
                break;
            }
            System.out.println(element.getName());
        }
        RulesRepositoryTest.assertTrue((boolean)found);
    }

    public void testCategoriesAndSnapshots() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadCategory("/").addCategory("testCategoriesAndSnapshots", "X");
        PackageItem pkg = repo.createPackage("testCategoriesAndSnapshots", "");
        pkg.addAsset("testCat1", "x", "/testCategoriesAndSnapshots", "drl");
        pkg.addAsset("testCat2", "x", "/testCategoriesAndSnapshots", "drl");
        repo.save();
        List items = repo.findAssetsByCategory("/testCategoriesAndSnapshots");
        RulesRepositoryTest.assertEquals((int)2, (int)items.size());
        repo.createPackageSnapshot("testCategoriesAndSnapshots", "SNAP 1");
        items = repo.findAssetsByCategory("testCategoriesAndSnapshots");
        RulesRepositoryTest.assertEquals((int)2, (int)items.size());
    }

    public void testMoveRulePackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testMove", "description");
        AssetItem r = pkg.addAsset("testMove", "description");
        r.checkin("version0");
        String uuid = r.getUUID();
        RulesRepositoryTest.assertEquals((String)"testMove", (String)r.getPackageName());
        repo.save();
        RulesRepositoryTest.assertEquals((int)1, (int)this.iteratorToList(pkg.getAssets()).size());
        repo.createPackage("testMove2", "description");
        repo.moveRuleItemPackage("testMove2", r.node.getUUID(), "explanation");
        pkg = repo.loadPackage("testMove");
        RulesRepositoryTest.assertEquals((int)0, (int)this.iteratorToList(pkg.getAssets()).size());
        pkg = repo.loadPackage("testMove2");
        RulesRepositoryTest.assertEquals((int)1, (int)this.iteratorToList(pkg.getAssets()).size());
        r = (AssetItem)pkg.getAssets().next();
        RulesRepositoryTest.assertEquals((String)"testMove", (String)r.getName());
        RulesRepositoryTest.assertEquals((String)"testMove2", (String)r.getPackageName());
        RulesRepositoryTest.assertEquals((String)"explanation", (String)r.getCheckinComment());
        AssetItem p = (AssetItem)r.getPrecedingVersion();
        RulesRepositoryTest.assertEquals((String)"testMove", (String)p.getPackageName());
        RulesRepositoryTest.assertEquals((String)"version0", (String)p.getCheckinComment());
        RulesRepositoryTest.assertEquals((String)uuid, (String)r.getUUID());
    }

    public void testCopyAsset() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.createPackage("testCopyAsset", "asset");
        AssetItem item = repo.loadDefaultPackage().addAsset("testCopyAssetSource", "desc");
        item.updateContent("la");
        item.checkin("");
        item.updateDescription("mmm");
        item.checkin("again");
        RulesRepositoryTest.assertEquals((long)2L, (long)item.getVersionNumber());
        String uuid = repo.copyAsset(item.getUUID(), "testCopyAsset", "testCopyAssetDestination");
        AssetItem dest = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"la", (String)dest.getContent());
        RulesRepositoryTest.assertEquals((String)"testCopyAsset", (String)dest.getPackageName());
        RulesRepositoryTest.assertFalse((boolean)uuid.equals(item.getUUID()));
        RulesRepositoryTest.assertEquals((long)1L, (long)dest.getVersionNumber());
    }

    public void testRenameAsset() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.createPackage("testRenameAsset", "asset");
        AssetItem item = repo.loadPackage("testRenameAsset").addAsset("testRenameAssetSource", "desc");
        item.updateContent("la");
        item.checkin("");
        String uuid = repo.renameAsset(item.getUUID(), "testRename2");
        item = repo.loadAssetByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"testRename2", (String)item.getName());
        RulesRepositoryTest.assertEquals((String)"testRename2", (String)item.getTitle());
        List assets = this.iteratorToList(repo.loadPackage("testRenameAsset").getAssets());
        RulesRepositoryTest.assertEquals((int)1, (int)assets.size());
        item = (AssetItem)assets.get(0);
        RulesRepositoryTest.assertEquals((String)"testRename2", (String)item.getName());
        RulesRepositoryTest.assertEquals((String)"la", (String)item.getContent());
    }

    public void testRenamePackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem original = repo.createPackage("testRenamePackage", "asset");
        List packagesOriginal = this.iteratorToList(repo.listPackages());
        AssetItem item = repo.loadPackage("testRenamePackage").addAsset("testRenameAssetSource", "desc");
        item.updateContent("la");
        item.checkin("");
        String uuid = repo.renamePackage(original.getUUID(), "testRenamePackage2");
        PackageItem pkg = repo.loadPackageByUUID(uuid);
        RulesRepositoryTest.assertEquals((String)"testRenamePackage2", (String)pkg.getName());
        List assets = this.iteratorToList(repo.loadPackage("testRenamePackage2").getAssets());
        RulesRepositoryTest.assertEquals((int)1, (int)assets.size());
        item = (AssetItem)assets.get(0);
        RulesRepositoryTest.assertEquals((String)"testRenameAssetSource", (String)item.getName());
        RulesRepositoryTest.assertEquals((String)"la", (String)item.getContent());
        RulesRepositoryTest.assertEquals((String)"testRenamePackage2", (String)item.getPackageName());
        List packageFinal = this.iteratorToList(repo.listPackages());
        RulesRepositoryTest.assertEquals((int)packagesOriginal.size(), (int)packageFinal.size());
    }

    public void testCopyPackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem source = repo.createPackage("testCopyPackage", "asset");
        AssetItem item = source.addAsset("testCopyPackage", "desc");
        item.updateContent("la");
        item.checkin("");
        repo.save();
        repo.copyPackage("testCopyPackage", "testCopyPackage2");
        PackageItem dest = repo.loadPackage("testCopyPackage2");
        RulesRepositoryTest.assertNotNull((Object)dest);
        RulesRepositoryTest.assertFalse((boolean)source.getUUID().equals(dest.getUUID()));
        RulesRepositoryTest.assertEquals((int)1, (int)this.iteratorToList(dest.getAssets()).size());
        AssetItem item2 = (AssetItem)dest.getAssets().next();
        RulesRepositoryTest.assertEquals((String)"testCopyPackage", (String)item.getPackageName());
        RulesRepositoryTest.assertEquals((String)"testCopyPackage2", (String)item2.getPackageName());
        item2.updateContent("goober choo");
        item2.checkin("yeah");
        RulesRepositoryTest.assertEquals((String)"la", (String)item.getContent());
        try {
            repo.copyPackage("testCopyPackage", "testCopyPackage2");
            RulesRepositoryTest.fail((String)"should not be able to copy when existing.");
        }
        catch (RulesRepositoryException e) {
            RulesRepositoryTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testListStates() {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        StateItem[] items = repo.listStates();
        RulesRepositoryTest.assertTrue((items.length > 0 ? 1 : 0) != 0);
        repo.createState("testListStates");
        StateItem[] items2 = repo.listStates();
        RulesRepositoryTest.assertEquals((int)(items.length + 1), (int)items2.length);
    }

    public void testImportExport() {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        try {
            byte[] repository_backup = repo.dumpRepositoryXml();
            RulesRepositoryTest.assertNotNull((Object)repository_backup);
            repo.createPackage("testImportExport", "nodescription");
            byte[] repository_unitest = repo.dumpRepositoryXml();
            repo.importRulesRepository(repository_backup);
            RulesRepositoryTest.assertFalse((boolean)repo.containsPackage("testImportExport"));
            repo.importRulesRepository(repository_unitest);
            RulesRepositoryTest.assertTrue((boolean)repo.containsPackage("testImportExport"));
        }
        catch (Exception e) {
            RulesRepositoryTest.fail((String)"Can't throw any exception.");
            e.printStackTrace();
        }
    }

    public void testExportZippedRepository() throws PathNotFoundException, IOException, RepositoryException {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        byte[] repository_unitest = repo.exportRulesRepository();
        ByteArrayInputStream bin = new ByteArrayInputStream(repository_unitest);
        ZipInputStream zis = new ZipInputStream(bin);
        ZipEntry entry = zis.getNextEntry();
        RulesRepositoryTest.assertEquals((String)entry.getName(), (String)"repository_export.xml");
        RulesRepositoryTest.assertFalse((boolean)entry.isDirectory());
    }

    List iteratorToList(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }
}

