/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scm.svn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.drools.scm.CompositeScmAction;
import org.drools.scm.ScmAction;
import org.drools.scm.ScmEntry;
import org.drools.scm.svn.SvnActionFactory;

public class SvnLogTest
extends TestCase {
    private static String svnUrl;

    public void setUp() throws IOException {
        URL url = ((Object)((Object)this)).getClass().getResource("/svn_repo_empty");
        SvnLogTest.assertNotNull((Object)url);
        File src = new File(url.getFile());
        File dst = new File(src.getParent(), "/copy_svn_repo_empty");
        SvnLogTest.delete(dst);
        SvnLogTest.copy(src, dst);
        svnUrl = "file:///" + dst.getAbsolutePath().replaceAll("\\\\", "/");
    }

    public void tearDown() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("/copy_svn_repo_empty");
        SvnLogTest.delete(new File(url.getFile()));
    }

    public void testHistory() throws Exception {
        SvnActionFactory svn = new SvnActionFactory(svnUrl, "mrtrout", "drools");
        CompositeScmAction actions = new CompositeScmAction();
        SvnActionFactory.AddDirectory addFolder = new SvnActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addFolder);
        byte[] content = new byte[]{1, 1, 1, 1};
        SvnActionFactory.AddFile addFile = new SvnActionFactory.AddFile("folder1", "file1.dat", content);
        actions.addScmAction((ScmAction)addFile);
        svn.execute((ScmAction)actions, "test message");
    }

    public static void copy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            dest.mkdirs();
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                String dest1 = dest.getPath() + File.separator + list[i];
                String src1 = src.getPath() + File.separator + list[i];
                SvnLogTest.copy(new File(src1), new File(dest1));
            }
        } else {
            int c;
            FileInputStream fin = new FileInputStream(src);
            FileOutputStream fout = new FileOutputStream(dest);
            while ((c = fin.read()) >= 0) {
                fout.write(c);
            }
            fin.close();
            fout.close();
        }
    }

    public static void delete(File src) throws IOException {
        if (src.isDirectory()) {
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                String src1 = src.getPath() + File.separator + list[i];
                SvnLogTest.delete(new File(src1));
            }
            src.delete();
        } else {
            src.delete();
        }
    }

    public static List convertToStringList(List list) {
        ArrayList<String> files = new ArrayList<String>(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ScmEntry entry = (ScmEntry)it.next();
            files.add(entry.getPath().equals("") ? entry.getName() : entry.getPath() + "/" + entry.getName());
        }
        return files;
    }
}

