/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scm.jcr;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.scm.CompositeScmAction;
import org.drools.scm.ScmAction;
import org.drools.scm.ScmEntry;
import org.drools.scm.jcr.JcrActionFactory;

public class JcrActionFactoryTest
extends TestCase {
    public void testMapPathNameToPackage() {
        JcrActionFactory fact = new JcrActionFactory(null);
        JcrActionFactoryTest.assertEquals((String)"org.foo.bar", (String)JcrActionFactory.toPackageName((String)"org/foo/bar"));
        JcrActionFactoryTest.assertEquals((String)"foo", (String)JcrActionFactory.toPackageName((String)"foo"));
        JcrActionFactoryTest.assertEquals((String)"FooBar", (String)JcrActionFactory.toPackageName((String)"FooBar"));
        JcrActionFactoryTest.assertEquals((String)"org/foo/bar", (String)JcrActionFactory.toDirectoryName((String)"org.foo.bar"));
        JcrActionFactoryTest.assertEquals((String)"foo", (String)JcrActionFactory.toDirectoryName((String)"foo"));
    }

    public void testAddDirectories() throws Exception {
        JcrActionFactory svn = new JcrActionFactory(RepositorySessionUtil.getRepository());
        CompositeScmAction actions = new CompositeScmAction();
        actions = new CompositeScmAction();
        JcrActionFactory.AddDirectory addDirectory = new JcrActionFactory.AddDirectory("", "folder1");
        actions.addScmAction((ScmAction)addDirectory);
        svn.execute((ScmAction)actions, "test message");
        actions = new CompositeScmAction();
        addDirectory = new JcrActionFactory.AddDirectory("folder1", "folder1_1");
        actions.addScmAction((ScmAction)addDirectory);
        addDirectory = new JcrActionFactory.AddDirectory("folder1/folder1_1", "folder1_1_1");
        actions.addScmAction((ScmAction)addDirectory);
        addDirectory = new JcrActionFactory.AddDirectory("folder1", "folder1_2");
        actions.addScmAction((ScmAction)addDirectory);
        addDirectory = new JcrActionFactory.AddDirectory("", "folder2/folder2_1");
        actions.addScmAction((ScmAction)addDirectory);
        addDirectory = new JcrActionFactory.AddDirectory("", "folder3/folder3_1/folder3_1_1/folder3_1_1_1");
        actions.addScmAction((ScmAction)addDirectory);
        svn.execute((ScmAction)actions, "test message");
        List list = JcrActionFactoryTest.convertToStringList(svn.listEntries(""));
        JcrActionFactoryTest.assertTrue((boolean)list.contains("folder1"));
        JcrActionFactoryTest.assertTrue((boolean)list.contains("folder1/folder1_1"));
        JcrActionFactoryTest.assertTrue((boolean)list.contains("folder1/folder1_2"));
        JcrActionFactoryTest.assertTrue((boolean)list.contains("folder2/folder2_1"));
        JcrActionFactoryTest.assertTrue((boolean)list.contains("folder3/folder3_1/folder3_1_1/folder3_1_1_1"));
    }

    public void testAddFiles() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.createPackage("testAddFiles.package", "just for testing");
        JcrActionFactory fact = new JcrActionFactory(repo);
        byte[] data = "this is content".getBytes();
        ScmAction action = fact.addFile("testAddFiles/package", "someFile.drl", data);
        fact.execute(action, "some message");
        PackageItem pk = repo.loadPackage("testAddFiles.package");
        AssetItem asset = pk.loadAsset("someFile");
        JcrActionFactoryTest.assertEquals((String)"drl", (String)asset.getFormat());
        JcrActionFactoryTest.assertEquals((String)"this is content", (String)asset.getContent());
        JcrActionFactoryTest.assertEquals((String)"some message", (String)asset.getDescription());
        JcrActionFactoryTest.assertEquals((String)"Draft", (String)asset.getStateDescription());
    }

    public void testUpdateFiles() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.loadDefaultPackage();
        AssetItem asset = pkg.addAsset("testUpdateFilesSVN", "something");
        asset.updateContent("lala");
        asset.checkin("yeah");
        long oldVersion = asset.getVersionNumber();
        JcrActionFactory fact = new JcrActionFactory(repo);
        ScmAction action = fact.updateFile("defaultPackage", "testUpdateFilesSVN.drl", "lala".getBytes(), "lala2".getBytes());
        fact.execute(action, "goo");
        AssetItem asset2 = pkg.loadAsset("testUpdateFilesSVN");
        JcrActionFactoryTest.assertFalse((oldVersion == asset2.getVersionNumber() ? 1 : 0) != 0);
        JcrActionFactoryTest.assertEquals((String)"lala2", (String)asset2.getContent());
        JcrActionFactoryTest.assertEquals((String)"goo", (String)asset2.getCheckinComment());
    }

    public static List convertToStringList(List list) {
        ArrayList<String> files = new ArrayList<String>(list.size());
        for (ScmEntry entry : list) {
            files.add(entry.getPath().equals("") ? entry.getName() : entry.getPath() + "/" + entry.getName());
        }
        return files;
    }
}

