/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.log4j.Logger;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.CategorisableItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionableItem;

public class AssetItem
extends CategorisableItem {
    private Logger log = Logger.getLogger(AssetItem.class);
    public static final String RULE_NODE_TYPE_NAME = "drools:assetNodeType";
    public static final String CONTENT_PROPERTY_NAME = "drools:content";
    public static final String CONTENT_PROPERTY_BINARY_NAME = "drools:binaryContent";
    public static final String CONTENT_PROPERTY_ATTACHMENT_FILENAME = "drools:attachmentFileName";
    public static final String DATE_EFFECTIVE_PROPERTY_NAME = "drools:dateEffective";
    public static final String DISABLED_PROPERTY_NAME = "drools:disabled";
    public static final String DATE_EXPIRED_PROPERTY_NAME = "drools:dateExpired";
    public static final String PACKAGE_NAME_PROPERTY = "drools:packageName";

    public AssetItem(RulesRepository rulesRepository, Node node) throws RulesRepositoryException {
        super(rulesRepository, node);
        try {
            if (!this.node.getPrimaryNodeType().getName().equals(RULE_NODE_TYPE_NAME) && !this.isHistoricalVersion()) {
                String message = this.node.getName() + " is not a node of type " + RULE_NODE_TYPE_NAME + " nor nt:version. It is a node of type: " + this.node.getPrimaryNodeType().getName();
                this.log.error((Object)message);
                throw new RulesRepositoryException(message);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItem() {
        super(null, null);
    }

    public String getContent() throws RulesRepositoryException {
        try {
            if (this.isBinary()) {
                return new String(this.getBinaryContentAsBytes());
            }
            Node ruleNode = this.getVersionContentNode();
            if (ruleNode.hasProperty(CONTENT_PROPERTY_NAME)) {
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_NAME);
                return data.getValue().getString();
            }
            return "";
        }
        catch (Exception e) {
            this.log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public long getContentLength() {
        try {
            Node ruleNode = this.getVersionContentNode();
            if (ruleNode.hasProperty(CONTENT_PROPERTY_BINARY_NAME)) {
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_BINARY_NAME);
                return data.getLength();
            }
            if (ruleNode.hasProperty(CONTENT_PROPERTY_NAME)) {
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_NAME);
                return data.getLength();
            }
            return 0L;
        }
        catch (RepositoryException e) {
            this.log.error((Object)e);
            throw new RulesRepositoryException(e);
        }
    }

    public boolean isBinary() {
        try {
            Node ruleNode = this.getVersionContentNode();
            return ruleNode.hasProperty(CONTENT_PROPERTY_BINARY_NAME);
        }
        catch (RepositoryException e) {
            this.log.error((Object)e);
            throw new RulesRepositoryException(e);
        }
    }

    public InputStream getBinaryContentAttachment() {
        try {
            Node ruleNode = this.getVersionContentNode();
            if (ruleNode.hasProperty(CONTENT_PROPERTY_BINARY_NAME)) {
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_BINARY_NAME);
                return data.getStream();
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String getBinaryContentAttachmentFileName() {
        return this.getStringProperty(CONTENT_PROPERTY_ATTACHMENT_FILENAME);
    }

    public byte[] getBinaryContentAsBytes() {
        try {
            Node ruleNode = this.getVersionContentNode();
            if (ruleNode.hasProperty(CONTENT_PROPERTY_BINARY_NAME)) {
                int offset;
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_BINARY_NAME);
                InputStream in = data.getStream();
                byte[] bytes = new byte[(int)data.getLength()];
                int numRead = 0;
                for (offset = 0; offset < bytes.length && (numRead = in.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
                if (offset < bytes.length) {
                    throw new RulesRepositoryException("Could not completely read asset " + this.getName());
                }
                in.close();
                return bytes;
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException(e);
        }
    }

    public Calendar getDateEffective() throws RulesRepositoryException {
        try {
            Node ruleNode = this.getVersionContentNode();
            Property dateEffectiveProperty = ruleNode.getProperty(DATE_EFFECTIVE_PROPERTY_NAME);
            return dateEffectiveProperty.getDate();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public boolean getDisabled() throws RulesRepositoryException {
        try {
            Node ruleNode = this.getVersionContentNode();
            Property disabled = ruleNode.getProperty(DISABLED_PROPERTY_NAME);
            return disabled.getBoolean();
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateDateEffective(Calendar newDateEffective) throws RulesRepositoryException {
        this.checkIsUpdateable();
        this.checkout();
        try {
            this.node.setProperty(DATE_EFFECTIVE_PROPERTY_NAME, newDateEffective);
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateDisabled(boolean disabled) throws RulesRepositoryException {
        this.checkIsUpdateable();
        this.checkout();
        try {
            this.node.setProperty(DISABLED_PROPERTY_NAME, disabled);
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public Calendar getDateExpired() throws RulesRepositoryException {
        try {
            Node ruleNode = this.getVersionContentNode();
            Property dateExpiredProperty = ruleNode.getProperty(DATE_EXPIRED_PROPERTY_NAME);
            return dateExpiredProperty.getDate();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateDateExpired(Calendar newDateExpired) throws RulesRepositoryException {
        this.checkout();
        try {
            this.node.setProperty(DATE_EXPIRED_PROPERTY_NAME, newDateExpired);
        }
        catch (Exception e) {
            this.log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItem updateContent(String newRuleContent) throws RulesRepositoryException {
        this.checkout();
        try {
            if (this.isBinary()) {
                this.updateBinaryContentAttachment(new ByteArrayInputStream(newRuleContent.getBytes()));
            }
            this.node.setProperty(CONTENT_PROPERTY_NAME, newRuleContent);
            return this;
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Unable to update the asset content", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItem updateBinaryContentAttachment(InputStream data) {
        this.checkout();
        try {
            this.node.setProperty(CONTENT_PROPERTY_BINARY_NAME, data);
            return this;
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Unable to update the assets binary content", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateBinaryContentAttachmentFileName(String name) {
        this.updateStringProperty(name, CONTENT_PROPERTY_ATTACHMENT_FILENAME);
    }

    public void updateUserProperty(String propertyName, String value) {
        if (propertyName.startsWith("drools:")) {
            throw new IllegalArgumentException("Can only set the pre defined fields using the appropriate methods.");
        }
        this.updateStringProperty(value, propertyName);
    }

    public String toString() {
        try {
            StringBuffer returnString = new StringBuffer();
            returnString.append("Content of rule item named '" + this.getName() + "':\n");
            returnString.append("Content: " + this.getContent() + "\n");
            returnString.append("------\n");
            returnString.append("Archived: " + this.isArchived() + "\n");
            returnString.append("------\n");
            returnString.append("Date Effective: " + this.getDateEffective() + "\n");
            returnString.append("Date Expired: " + this.getDateExpired() + "\n");
            returnString.append("------\n");
            returnString.append("Rule state: ");
            StateItem stateItem = this.getState();
            if (stateItem != null) {
                returnString.append(this.getState().getName() + "\n");
            } else {
                returnString.append("NO STATE SET FOR THIS NODE\n");
            }
            returnString.append("------\n");
            returnString.append("Rule tags:\n");
            for (CategoryItem currentTag : this.getCategories()) {
                returnString.append(currentTag.getName() + "\n");
            }
            returnString.append("--------------\n");
            return returnString.toString();
        }
        catch (Exception e) {
            throw new RulesRepositoryException(e);
        }
    }

    public VersionableItem getPrecedingVersion() throws RulesRepositoryException {
        try {
            Node precedingVersionNode = this.getPrecedingVersionNode();
            if (precedingVersionNode != null) {
                return new AssetItem(this.rulesRepository, precedingVersionNode);
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public VersionableItem getSucceedingVersion() throws RulesRepositoryException {
        try {
            Node succeedingVersionNode = this.getSucceedingVersionNode();
            if (succeedingVersionNode != null) {
                return new AssetItem(this.rulesRepository, succeedingVersionNode);
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String getPackageName() {
        return super.getStringProperty(PACKAGE_NAME_PROPERTY);
    }

    public String getUserProperty(String property) {
        return this.getStringProperty(property);
    }

    public void remove() {
        this.checkIsUpdateable();
        if (this.getDateExpired() != null && Calendar.getInstance().before(this.getDateExpired())) {
            throw new RulesRepositoryException("Can't delete an item before its expiry date.");
        }
        try {
            this.node.remove();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetHistoryIterator getHistory() {
        return new AssetHistoryIterator(this.rulesRepository, this.node);
    }

    public PackageItem getPackage() {
        try {
            if (this.isHistoricalVersion()) {
                return this.rulesRepository.loadPackage(this.getPackageName());
            }
            return new PackageItem(this.rulesRepository, this.node.getParent().getParent());
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public static String[] getAssetNameFromFileName(String fileName) {
        String[] r = new String[]{"", ""};
        char[] cs = fileName.toCharArray();
        boolean name = true;
        for (int i = 0; i < cs.length; ++i) {
            if (name && cs[i] == '.') {
                String rhs = fileName.substring(i);
                if (rhs.contains("_") || rhs.contains(" ")) {
                    r[0] = r[0] + '.';
                    continue;
                }
                name = false;
                continue;
            }
            if (name) {
                r[0] = r[0] + cs[i];
                continue;
            }
            r[1] = r[1] + cs[i];
        }
        return r;
    }
}

