/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.List;
import junit.framework.TestCase;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

public class CategoryItemTest
extends TestCase {
    public void testTagItem() throws Exception {
        CategoryItem root = this.getRepo().loadCategory("/");
        root.addCategory("TestTag", "nothing to see");
        CategoryItem tagItem1 = this.getRepo().loadCategory("TestTag");
        CategoryItemTest.assertNotNull((Object)tagItem1);
        CategoryItemTest.assertEquals((String)"TestTag", (String)tagItem1.getName());
        CategoryItem tagItem2 = this.getRepo().loadCategory("TestTag");
        CategoryItemTest.assertNotNull((Object)tagItem2);
        CategoryItemTest.assertEquals((String)"TestTag", (String)tagItem2.getName());
        CategoryItemTest.assertEquals((Object)tagItem1, (Object)tagItem2);
        List originalCats = this.getRepo().loadCategory("/").getChildTags();
        CategoryItemTest.assertTrue((originalCats.size() > 0 ? 1 : 0) != 0);
        CategoryItem rootCat = (CategoryItem)originalCats.get(0);
        CategoryItemTest.assertNotNull((Object)rootCat.getName());
        CategoryItemTest.assertNotNull((Object)rootCat.getFullPath());
        root.addCategory("FootestTagItem", "nothing");
        List cats = root.getChildTags();
        CategoryItemTest.assertEquals((int)(originalCats.size() + 1), (int)cats.size());
        boolean found = false;
        for (CategoryItem element : cats) {
            if (!element.getName().equals("FootestTagItem")) continue;
            found = true;
            break;
        }
        CategoryItemTest.assertTrue((boolean)found);
    }

    public void testCreateCateories() throws Exception {
        RulesRepository repo = this.getRepo();
        CategoryItem root = repo.loadCategory("/");
        CategoryItem item = root.addCategory("testCreateCategories", "this is a top level one");
        CategoryItemTest.assertEquals((String)"testCreateCategories", (String)item.getName());
        CategoryItemTest.assertEquals((String)"testCreateCategories", (String)item.getFullPath());
        item = repo.loadCategory("testCreateCategories");
        CategoryItemTest.assertEquals((String)"testCreateCategories", (String)item.getName());
        item.remove();
        repo.save();
        try {
            repo.loadCategory("testCreateCategories");
            CategoryItemTest.fail((String)"this should not exist");
        }
        catch (RulesRepositoryException e) {
            CategoryItemTest.assertNotNull((Object)e.getCause());
        }
    }

    public void testGetChildTags() {
        CategoryItem tagItem1 = this.getRepo().loadCategory("TestTag");
        CategoryItemTest.assertNotNull((Object)tagItem1);
        CategoryItemTest.assertEquals((String)"TestTag", (String)tagItem1.getName());
        List childTags = tagItem1.getChildTags();
        CategoryItemTest.assertNotNull((Object)childTags);
        CategoryItemTest.assertEquals((int)0, (int)childTags.size());
        tagItem1.addCategory("TestChildTag1", "description");
        childTags = tagItem1.getChildTags();
        CategoryItemTest.assertNotNull((Object)childTags);
        CategoryItemTest.assertEquals((int)1, (int)childTags.size());
        CategoryItemTest.assertEquals((String)"TestChildTag1", (String)((CategoryItem)childTags.get(0)).getName());
        tagItem1.addCategory("AnotherChild", "ignore me");
        childTags = tagItem1.getChildTags();
        CategoryItemTest.assertNotNull((Object)childTags);
        CategoryItemTest.assertEquals((int)2, (int)childTags.size());
    }

    public void testGetChildTag() {
        CategoryItem root = this.getRepo().loadCategory("/");
        CategoryItem tagItem1 = root.addCategory("testGetChildTag", "yeah");
        CategoryItemTest.assertNotNull((Object)tagItem1);
        CategoryItemTest.assertEquals((String)"testGetChildTag", (String)tagItem1.getName());
        List childTags = tagItem1.getChildTags();
        CategoryItemTest.assertNotNull((Object)childTags);
        CategoryItemTest.assertEquals((int)0, (int)childTags.size());
        CategoryItem childTagItem1 = tagItem1.addCategory("TestChildTag1", "woo");
        CategoryItemTest.assertNotNull((Object)childTagItem1);
        CategoryItemTest.assertEquals((String)"TestChildTag1", (String)childTagItem1.getName());
        CategoryItem childTagItem2 = this.getRepo().loadCategory("testGetChildTag/TestChildTag1");
        CategoryItemTest.assertNotNull((Object)childTagItem2);
        CategoryItemTest.assertEquals((String)"TestChildTag1", (String)childTagItem2.getName());
        CategoryItemTest.assertEquals((Object)childTagItem1, (Object)childTagItem2);
    }

    public void testGetFullPath() {
        CategoryItem root = this.getRepo().loadCategory("/");
        CategoryItem tagItem1 = root.addCategory("testGetFullPath", "foo");
        CategoryItemTest.assertNotNull((Object)tagItem1);
        CategoryItemTest.assertEquals((String)"testGetFullPath", (String)tagItem1.getFullPath());
        CategoryItem childTagItem1 = tagItem1.addCategory("TestChildTag1", "foo");
        CategoryItemTest.assertNotNull((Object)childTagItem1);
        CategoryItemTest.assertEquals((String)"testGetFullPath/TestChildTag1", (String)childTagItem1.getFullPath());
        CategoryItem childTagItem2 = childTagItem1.addCategory("TestChildTag2", "wee");
        CategoryItemTest.assertNotNull((Object)childTagItem2);
        CategoryItemTest.assertEquals((String)"testGetFullPath/TestChildTag1/TestChildTag2", (String)childTagItem2.getFullPath());
    }

    public void testRemoveCategoryUneeded() {
        RulesRepository repo = this.getRepo();
        repo.loadCategory("/").addCategory("testRemoveCat", "a");
        AssetItem as = repo.loadDefaultPackage().addAsset("testRemoveCategory", "a", "testRemoveCat", "drl");
        as.checkin("a");
        as.updateCategoryList(new String[0]);
        as.checkin("a");
        as = repo.loadDefaultPackage().loadAsset("testRemoveCategory");
        CategoryItemTest.assertEquals((int)0, (int)as.getCategories().size());
        repo.loadCategory("testRemoveCat").remove();
        repo.save();
    }

    public void testRemoveCategoryLinkedWithArchived() {
        RulesRepository repo = this.getRepo();
        repo.loadCategory("/").addCategory("testRemoveCategoryWithArchivedCat", "a");
        AssetItem as = repo.loadDefaultPackage().addAsset("testRemoveCategoryWithArchivedAsset", "a", "testRemoveCategoryWithArchivedCat", "drl");
        as.checkin("a");
        as.archiveItem(true);
        repo.loadCategory("testRemoveCategoryWithArchivedCat").remove();
        repo.save();
    }

    private RulesRepository getRepo() {
        return RepositorySessionUtil.getRepository();
    }
}

