/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import junit.framework.TestCase;
import org.drools.repository.AssetItem;
import org.drools.repository.JackrabbitRepositoryConfigurator;
import org.drools.repository.RulesRepository;

public class ScalabilityTest
extends TestCase {
    private static final int NUM = 5000;
    private RulesRepository repo;

    public void testDummy() {
    }

    public void xxtestRun() throws Exception {
        JackrabbitRepositoryConfigurator config = new JackrabbitRepositoryConfigurator();
        Session session = config.getJCRRepository("./scalabilityTestRepo").login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
        this.repo = new RulesRepository(session);
        long start = System.currentTimeMillis();
        System.out.println("time to add, version and tag 5000: " + (System.currentTimeMillis() - start));
        List list = this.listACat(this.repo);
        System.out.println("list size is: " + list.size());
        start = System.currentTimeMillis();
        AssetItem item = (AssetItem)list.get(0);
        item.updateContent("this is a description");
        item.checkin("newer");
        System.out.println("time to update and version: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        item = (AssetItem)list.get(42);
        item.updateContent("this is a description");
        item.updateContent("wooooooooooooooooooooooooooooooooooot");
        item.checkin("latest");
        System.out.println("time to update and version: " + (System.currentTimeMillis() - start));
    }

    private List listACat(RulesRepository repo) {
        long start = System.currentTimeMillis();
        List results = repo.findAssetsByCategory((String)"HR/CAT_1", (int)0, (int)-1).assets;
        System.out.println("Time for listing a cat: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        List results2 = repo.findAssetsByCategory((String)"HR/CAT_1", (int)0, (int)-1).assets;
        System.out.println("Time for listing a cat: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        results2 = repo.findAssetsByCategory((String)"HR/CAT_100", (int)0, (int)-1).assets;
        System.out.println("Time for listing a cat: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        results2 = repo.findAssetsByCategory((String)"HR/CAT_100", (int)0, (int)-1).assets;
        System.out.println("Time for listing a cat: " + (System.currentTimeMillis() - start));
        return results;
    }

    private void setupData(RulesRepository repo) throws Exception {
        int count = 1;
        ArrayList<AssetItem> list = new ArrayList<AssetItem>();
        String prefix = "HR/";
        String cat = prefix + "CAT_1";
        for (int i = 1; i <= 5000; ++i) {
            if (i % 500 == 0) {
                repo.getSession().save();
                for (AssetItem element : list) {
                    element.getNode().checkin();
                }
                list.clear();
            }
            if (i > 2500) {
                prefix = "FINANCE/";
            }
            if (count == 100) {
                count = 1;
                cat = prefix + "CAT_" + i;
                System.err.println("changing CAT");
                System.gc();
            } else {
                ++count;
            }
            String ruleName = "rule_" + i + "_" + System.currentTimeMillis();
            System.out.println("ADDING rule: " + ruleName);
            AssetItem item = repo.loadDefaultPackage().addAsset(ruleName, "Foo(bar == " + i + ")panic(" + i + ");");
            item.addCategory(cat);
            list.add(item);
        }
    }
}

