/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.migration;

import javax.jcr.Session;
import junit.framework.TestCase;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.migration.MigrateDroolsPackage;

public class MigrateDroolsPackageTest
extends TestCase {
    public void testMigrate() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        Session sess = repo.getSession();
        sess.getRootNode().getNode("drools:repository").getNode("drools.package.migrated").remove();
        sess.save();
        MigrateDroolsPackage mig = new MigrateDroolsPackage();
        PackageItem pkg = repo.createPackage("testMigratePackage", "");
        pkg.updateStringProperty("some header", "drools:header");
        sess.save();
        repo.createPackageSnapshot("testMigratePackage", "SNAP1");
        repo.createPackageSnapshot("testMigratePackage", "SNAP2");
        MigrateDroolsPackageTest.assertTrue((boolean)mig.needsMigration(repo));
        mig.migrate(repo);
        MigrateDroolsPackageTest.assertFalse((boolean)repo.getSession().hasPendingChanges());
        MigrateDroolsPackageTest.assertFalse((boolean)mig.needsMigration(repo));
        pkg = repo.loadPackage("testMigratePackage");
        MigrateDroolsPackageTest.assertTrue((boolean)pkg.containsAsset("drools"));
        AssetItem as = pkg.loadAsset("drools");
        MigrateDroolsPackageTest.assertEquals((String)"some header", (String)as.getContent());
        pkg = repo.loadPackageSnapshot("testMigratePackage", "SNAP1");
        MigrateDroolsPackageTest.assertTrue((boolean)pkg.containsAsset("drools"));
        as = pkg.loadAsset("drools");
        MigrateDroolsPackageTest.assertEquals((String)"some header", (String)as.getContent());
        pkg = repo.loadPackageSnapshot("testMigratePackage", "SNAP2");
        MigrateDroolsPackageTest.assertTrue((boolean)pkg.containsAsset("drools"));
        as = pkg.loadAsset("drools");
        MigrateDroolsPackageTest.assertEquals((String)"some header", (String)as.getContent());
    }
}

