/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.security;

import junit.framework.TestCase;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.security.DroolsRepositoryACLManager;
import org.jboss.security.identity.plugins.IdentityFactory;

public class AccessControlTest
extends TestCase {
    public void testSecurityACL() throws Exception {
        DroolsRepositoryACLManager droolssercurity = new DroolsRepositoryACLManager(IdentityFactory.createIdentity((String)"group1"));
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadDefaultPackage().addAsset("testsecurityASSET1", "X");
        repo.loadDefaultPackage().addAsset("testsecurityASSET2", "X");
        AssetItem item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testsecurityASSET1");
        droolssercurity.setPermission(item.getUUID(), 1);
        AccessControlTest.assertTrue((boolean)droolssercurity.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 1));
        AccessControlTest.assertFalse((boolean)droolssercurity.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 2));
        AccessControlTest.assertFalse((boolean)droolssercurity.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 4));
        item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testsecurityASSET2");
        droolssercurity.setPermission(item.getUUID(), 3);
        AccessControlTest.assertTrue((boolean)droolssercurity.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 3));
        AccessControlTest.assertTrue((boolean)droolssercurity.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 1));
        AccessControlTest.assertTrue((boolean)droolssercurity.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 2));
        AccessControlTest.assertFalse((boolean)droolssercurity.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 4));
    }

    public void testSecurityACLMultiUsers() throws Exception {
        DroolsRepositoryACLManager droolssercurity1 = new DroolsRepositoryACLManager(IdentityFactory.createIdentity((String)"group1"));
        DroolsRepositoryACLManager droolssercurity2 = new DroolsRepositoryACLManager(IdentityFactory.createIdentity((String)"group2"));
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadDefaultPackage().addAsset("testsecurityASSET3", "X");
        AssetItem item = RepositorySessionUtil.getRepository().loadDefaultPackage().loadAsset("testsecurityASSET3");
        droolssercurity2.setPermission(item.getUUID(), 1);
        AccessControlTest.assertFalse((boolean)droolssercurity1.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 1));
        AccessControlTest.assertFalse((boolean)droolssercurity1.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 2));
        AccessControlTest.assertFalse((boolean)droolssercurity1.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 4));
        AccessControlTest.assertTrue((boolean)droolssercurity2.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 1));
        AccessControlTest.assertFalse((boolean)droolssercurity2.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 2));
        AccessControlTest.assertFalse((boolean)droolssercurity2.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 4));
    }

    public void FIXME_testSecurityACLDeepPermission() throws Exception {
        DroolsRepositoryACLManager droolssercurity1 = new DroolsRepositoryACLManager(IdentityFactory.createIdentity((String)"group1"));
        DroolsRepositoryACLManager droolssercurity2 = new DroolsRepositoryACLManager(IdentityFactory.createIdentity((String)"group2"));
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem packageitem = repo.createPackage("testPackageSecurity", "lalalala");
        AssetItem item = packageitem.addAsset("testsecurityASSET3", "X");
        droolssercurity2.setPermission(item.getUUID(), 2);
        AccessControlTest.assertFalse((boolean)droolssercurity1.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 1));
        AccessControlTest.assertTrue((boolean)droolssercurity1.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 2));
        AccessControlTest.assertFalse((boolean)droolssercurity1.checkPermission((ItemId)NodeId.valueOf((String)item.getUUID()), 4));
    }
}

