/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.compact.CompactNodeTypeDefReader;
import org.apache.log4j.Logger;
import org.drools.repository.JCRRepositoryConfigurator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;

public class JackrabbitRepositoryConfigurator
implements JCRRepositoryConfigurator {
    private static final Logger log = Logger.getLogger(JackrabbitRepositoryConfigurator.class);

    public Repository getJCRRepository(String repoRootDir) {
        try {
            if (repoRootDir == null) {
                return new TransientRepository();
            }
            return new TransientRepository(repoRootDir + "/repository.xml", repoRootDir);
        }
        catch (IOException e) {
            throw new RulesRepositoryException("Unable to create a Repository instance.", e);
        }
    }

    public void setupRulesRepository(Session session) throws RulesRepositoryException {
        System.out.println("Setting up the repository, registering node types etc.");
        try {
            Node root = session.getRootNode();
            Workspace ws = session.getWorkspace();
            boolean registered = RulesRepositoryAdministrator.isNamespaceRegistered(session);
            if (!registered) {
                ws.getNamespaceRegistry().registerNamespace("drools", "http://www.jboss.org/drools-repository/1.0");
                this.registerNodeTypesFromCndFile("/node_type_definitions/tag_node_type.cnd", ws);
                this.registerNodeTypesFromCndFile("/node_type_definitions/state_node_type.cnd", ws);
                this.registerNodeTypesFromCndFile("/node_type_definitions/versionable_node_type.cnd", ws);
                this.registerNodeTypesFromCndFile("/node_type_definitions/versionable_asset_folder_node_type.cnd", ws);
                this.registerNodeTypesFromCndFile("/node_type_definitions/rule_node_type.cnd", ws);
                this.registerNodeTypesFromCndFile("/node_type_definitions/rulepackage_node_type.cnd", ws);
            }
            Node repositoryNode = RulesRepository.addNodeIfNew(root, "drools:repository", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode, "drools:package_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode, "drools:packagesnapshot_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode, "drools:tag_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode, "drools:state_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode.getNode("drools:state_area"), "Draft", "drools:stateNodeType");
            session.save();
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception", (Throwable)e);
            System.err.println(e.getMessage());
            throw new RulesRepositoryException(e);
        }
    }

    private void registerNodeTypesFromCndFile(String cndFileName, Workspace ws) throws RulesRepositoryException, InvalidNodeTypeDefException {
        try {
            InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream(cndFileName));
            CompactNodeTypeDefReader cndReader = new CompactNodeTypeDefReader((Reader)in, cndFileName);
            List ntdList = cndReader.getNodeTypeDefs();
            NodeTypeManagerImpl ntmgr = (NodeTypeManagerImpl)ws.getNodeTypeManager();
            NodeTypeRegistry ntreg = ntmgr.getNodeTypeRegistry();
            for (NodeTypeDef ntd : ntdList) {
                log.debug((Object)("Attempting to regsiter node type named: " + ntd.getName()));
                ntreg.registerNodeType(ntd);
            }
        }
        catch (InvalidNodeTypeDefException e) {
            log.warn((Object)("InvalidNodeTypeDefinitionException caught when trying to add node from CND file: " + cndFileName + ". This will happen if the node type was already registered. " + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }
}

