/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageIterator
implements Iterator<PackageItem> {
    private final NodeIterator packageNodeIterator;
    private final RulesRepository repository;
    private boolean searchArchived = false;
    private Node current = null;
    private Node next = null;

    public PackageIterator() {
        this(null, null);
    }

    public PackageIterator(RulesRepository repository, NodeIterator packageNodes) {
        this.packageNodeIterator = packageNodes;
        this.repository = repository;
    }

    @Override
    public boolean hasNext() {
        if (this.packageNodeIterator == null) {
            return false;
        }
        boolean hasnext = false;
        if (this.next == null) {
            while (this.packageNodeIterator.hasNext()) {
                Node element = (Node)this.packageNodeIterator.next();
                try {
                    if (!this.searchArchived && element.getProperty("drools:archive").getBoolean() || "globalArea".equals(element.getName())) continue;
                    hasnext = true;
                    this.next = element;
                    break;
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
            }
        } else {
            hasnext = true;
        }
        return hasnext;
    }

    @Override
    public PackageItem next() {
        if (this.next == null) {
            this.hasNext();
        }
        this.current = this.next;
        this.next = null;
        if (this.current == null) {
            throw new NoSuchElementException("No more elements to return");
        }
        return new PackageItem(this.repository, this.current);
    }

    public void setArchivedIterator(boolean search) {
        this.searchArchived = search;
    }

    public boolean isSetArchivedSearch() {
        return this.searchArchived;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("You can not remove items this way.");
    }
}

