/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.drools.repository.RulesRepository;
import org.drools.repository.security.PermissionManager;

public class UserInfo {
    Node userInfoNode;

    public UserInfo(RulesRepository repo) throws RepositoryException {
        this.init(repo, repo.getSession().getUserID());
    }

    UserInfo() {
    }

    public UserInfo(RulesRepository repo, String userName) throws RepositoryException {
        this.init(repo, userName);
    }

    void init(RulesRepository repo, String userName) throws RepositoryException {
        this.userInfoNode = PermissionManager.getUserInfoNode(userName, repo);
    }

    public void setProperty(String fileName, String propertyName, Val value) throws RepositoryException {
        Node inboxNode = PermissionManager.getNode(this.userInfoNode, fileName, "nt:file");
        if (inboxNode.hasNode("jcr:content")) {
            inboxNode.getNode("jcr:content").setProperty(propertyName, value.value);
        } else {
            inboxNode.addNode("jcr:content", "nt:unstructured").setProperty(propertyName, value.value);
        }
    }

    public Val getProperty(String fileName, String propertyName) throws RepositoryException {
        Node inboxNode = PermissionManager.getNode(this.userInfoNode, fileName, "nt:file");
        if (inboxNode.hasNode("jcr:content")) {
            if (inboxNode.getNode("jcr:content").hasProperty(propertyName)) {
                return new Val(inboxNode.getNode("jcr:content").getProperty(propertyName).getString());
            }
            return new Val("");
        }
        inboxNode.addNode("jcr:content", "nt:unstructured");
        return new Val("");
    }

    public static void eachUser(RulesRepository repository, Command c) throws RepositoryException {
        NodeIterator nit = PermissionManager.getUsersRootNode(PermissionManager.getRootNode(repository)).getNodes();
        while (nit.hasNext()) {
            c.process(nit.nextNode());
        }
    }

    public void save() throws RepositoryException {
        this.userInfoNode.getParent().getParent().save();
    }

    public static interface Command {
        public void process(Node var1) throws RepositoryException;
    }

    public static class Val {
        public String value;

        public Val(String s) {
            this.value = s;
        }
    }
}

