/*
 * Decompiled with CFR 0.152.
 */
package org.drools.server;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.Person;
import org.drools.QueryResult;
import org.drools.QueryResults;
import org.drools.RuleBase;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.agent.RuleAgent;
import org.drools.common.InternalRuleBase;
import org.drools.rule.CompositeClassLoader;
import org.drools.server.AnonFact;
import org.drools.server.ExampleFact;
import org.drools.server.InsertedFact;
import org.drools.server.NamedFact;
import org.drools.server.QueryType;
import org.drools.server.ServiceRequestMessage;
import org.drools.server.ServiceResponseMessage;

/*
 * Exception performing whole class analysis ignored.
 */
public class KnowledgeStatelessServlet
extends HttpServlet {
    private static final long serialVersionUID = -8239975288596976901L;
    static Map<String, RuleAgent> cachedAgents = new HashMap();
    static Pattern urlPattern = Pattern.compile(".*knowledgebase/(.*)");

    protected void doPost(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        String uri = request.getRequestURI();
        String contentType = request.getContentType();
        resp.setContentType(contentType);
        Matcher m = urlPattern.matcher(uri);
        if (!m.matches()) {
            resp.sendError(400, "URI needs to be of the form /knowledgebase/{configName}");
            return;
        }
        String conf = m.group(1);
        RuleBase rb = this.getRuleBase(conf);
        if (rb == null) {
            resp.sendError(404, "The rulebase [" + conf + "] was not found or not valid.");
            return;
        }
        try {
            if (contentType != null && contentType.indexOf("json") > -1) {
                this.doService(this.getInputStream(request), this.getOutputStream(resp), rb, true);
            } else {
                this.doService(this.getInputStream(request), this.getOutputStream(resp), rb, false);
            }
        }
        catch (ConversionException e) {
            e.printStackTrace();
            resp.sendError(406, "Unable to convert. Error: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            resp.sendError(406, "Unable to process request. Error: " + e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendRedirect("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RuleBase getRuleBase(String configName) {
        if (cachedAgents.containsKey(configName)) {
            return ((RuleAgent)cachedAgents.get(configName)).getRuleBase();
        }
        Map map = cachedAgents;
        synchronized (map) {
            if (!cachedAgents.containsKey(configName)) {
                try {
                    RuleAgent ag = RuleAgent.newRuleAgent((String)("/" + configName + ".properties"));
                    cachedAgents.put(configName, ag);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    return null;
                }
            }
            return ((RuleAgent)cachedAgents.get(configName)).getRuleBase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doService(InputStream inputStream, OutputStream outputStream, RuleBase rb, boolean json) {
        InternalRuleBase irb = (InternalRuleBase)rb;
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            CompositeClassLoader cl = irb.getRootClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            XStream xs = KnowledgeStatelessServlet.configureXStream((boolean)json);
            ServiceRequestMessage req = (ServiceRequestMessage)xs.fromXML(inputStream);
            StatelessSession session = rb.newStatelessSession();
            if (req.globals != null) {
                for (NamedFact nf : req.globals) {
                    session.setGlobal(nf.id, nf.fact);
                }
            }
            ArrayList<Object> facts = new ArrayList<Object>();
            if (req.inFacts != null) {
                for (AnonFact f : req.inFacts) {
                    facts.add(f.fact);
                }
            }
            if (req.inOutFacts != null) {
                for (NamedFact nf : req.inOutFacts) {
                    facts.add(nf.fact);
                }
            }
            session.execute(facts);
            StatelessSessionResult ssr = session.executeWithResults(facts);
            ServiceResponseMessage res = new ServiceResponseMessage();
            if (req.globals != null) {
                res.globals = req.globals;
            }
            if (req.inOutFacts != null) {
                res.inOutFacts = req.inOutFacts;
            }
            if (req.queries != null) {
                res.outFacts = this.processQueries(req.queries, ssr);
            }
            xs.toXML((Object)res, outputStream);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private NamedFact[] processQueries(QueryType[] queries, StatelessSessionResult ssr) throws IllegalArgumentException {
        ArrayList<NamedFact> queryFacts = new ArrayList<NamedFact>();
        for (QueryType qt : queries) {
            QueryResults qResults = ssr.getQueryResults(qt.queryName, qt.args);
            for (QueryResult qResult : qResults) {
                for (String factName : qt.factNames) {
                    queryFacts.add(new NamedFact(factName, qResult.get(factName)));
                }
            }
        }
        if (queryFacts.size() == 0) {
            return null;
        }
        return queryFacts.toArray(new NamedFact[queryFacts.size()]);
    }

    static XStream configureXStream(boolean json) {
        if (json) {
            XStream xs = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
            KnowledgeStatelessServlet.alias((XStream)xs);
            return xs;
        }
        XStream xs = new XStream();
        KnowledgeStatelessServlet.alias((XStream)xs);
        return xs;
    }

    private static void alias(XStream xs) {
        xs.alias("knowledgebase-request", ServiceRequestMessage.class);
        xs.alias("knowledgebase-response", ServiceResponseMessage.class);
        xs.alias("named-fact", NamedFact.class);
        xs.alias("anon-fact", AnonFact.class);
        xs.alias("query-type", QueryType.class);
    }

    OutputStream getOutputStream(HttpServletResponse resp) throws IOException {
        return resp.getOutputStream();
    }

    InputStream getInputStream(HttpServletRequest request) throws IOException {
        return request.getInputStream();
    }

    private void sample() {
        XStream xs = KnowledgeStatelessServlet.configureXStream((boolean)true);
        ServiceRequestMessage req = new ServiceRequestMessage();
        req.globals = new NamedFact[1];
        req.inFacts = new AnonFact[1];
        req.inOutFacts = new NamedFact[1];
        req.globals[0] = new NamedFact("jo", (Object)new Person("Jo", "Chocolote"));
        req.inFacts[0] = new AnonFact((Object)new Person("Mike", "wine"));
        req.inOutFacts[0] = new NamedFact("mark", (Object)new Person("Mark", "Cheese"));
        String requestMessage = xs.toXML((Object)req);
        ServiceRequestMessage req_ = (ServiceRequestMessage)xs.fromXML(requestMessage);
        String requestMessage_ = xs.toXML((Object)req_);
        System.out.println(requestMessage);
        if (!requestMessage_.equals(requestMessage)) {
            throw new RuntimeException("fail !");
        }
    }

    public static void main(String[] args) throws ServletException, IOException {
        KnowledgeStatelessServlet rs = new KnowledgeStatelessServlet();
        rs.sample();
    }

    public static String getRequestExample(boolean json) {
        ServiceRequestMessage req = new ServiceRequestMessage();
        req.queries = new QueryType[1];
        String[] nameFacts = new String[]{"ninsf"};
        Object[] args = new Object[]{new String("one"), new String("two")};
        req.queries[0] = new QueryType("Get named inserted fact", nameFacts, args);
        req.globals = new NamedFact[1];
        req.globals[0] = new NamedFact("myglobal", (Object)new ExampleFact("Saab", 42));
        req.inFacts = new AnonFact[2];
        req.inFacts[0] = new AnonFact((Object)new ExampleFact("Audi", 55));
        req.inFacts[1] = new AnonFact((Object)new ExampleFact("Mercedes", 65));
        req.inOutFacts = new NamedFact[1];
        req.inOutFacts[0] = new NamedFact("myfact", (Object)new ExampleFact("BMW", 50));
        return KnowledgeStatelessServlet.configureXStream((boolean)json).toXML((Object)req);
    }

    public static String getResponseExample(boolean json) {
        ServiceResponseMessage req = new ServiceResponseMessage();
        req.globals = new NamedFact[1];
        req.globals[0] = new NamedFact("myglobal", (Object)new ExampleFact("Saab", 42));
        req.inOutFacts = new NamedFact[1];
        req.inOutFacts[0] = new NamedFact("myfact", (Object)new ExampleFact("BMW", 50));
        req.outFacts = new NamedFact[2];
        req.outFacts[0] = new NamedFact("ninsf", (Object)new InsertedFact("one"));
        req.outFacts[1] = new NamedFact("ninsf", (Object)new InsertedFact("two"));
        return KnowledgeStatelessServlet.configureXStream((boolean)json).toXML((Object)req);
    }
}

