/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.migration.MigrateDroolsPackage;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesRepositoryTest
extends RepositoryTestCase {
    int running = 0;

    @Test
    public void testDefaultPackage() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageIterator it = repo.listPackages();
        boolean foundDefault = false;
        while (it.hasNext()) {
            PackageItem item = (PackageItem)it.next();
            if (!item.getName().equals("defaultPackage")) continue;
            foundDefault = true;
        }
        Assert.assertTrue((boolean)foundDefault);
        PackageItem def = repo.loadDefaultPackage();
        Assert.assertNotNull((Object)def);
        Assert.assertEquals((Object)"defaultPackage", (Object)def.getName());
        String userId = repo.getSession().getUserID();
        Assert.assertNotNull((Object)userId);
        Assert.assertFalse((boolean)userId.equals(""));
        MigrateDroolsPackage mig = new MigrateDroolsPackage();
        Assert.assertFalse((boolean)mig.needsMigration(repo));
        Assert.assertTrue((boolean)repo.initialized);
    }

    @Test
    public void testCategoryRename() throws Exception {
        RulesRepository repo = this.getRepo();
        CategoryItem root = repo.loadCategory("/");
        root.addCategory("testCatRename", "");
        repo.loadCategory("testCatRename").addCategory("testRename", "");
        repo.renameCategory("testCatRename/testRename", "testAnother");
        CategoryItem cat = repo.loadCategory("testCatRename/testAnother");
        Assert.assertNotNull((Object)cat);
        try {
            repo.loadCategory("testCatRename/testRename");
            Assert.fail((String)"should not exist.");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        PackageItem pkg = repo.createPackage("testCategoryRename", "");
        AssetItem asset = pkg.addAsset("fooBar", "");
        asset.addCategory("testCatRename");
        asset.addCategory("testCatRename/testAnother");
        asset.checkin("");
        cat = repo.loadCategory("testCatRename/testAnother");
        AssetItemPageResult as = repo.findAssetsByCategory("testCatRename/testAnother", 0, -1);
        Assert.assertEquals((Object)"fooBar", (Object)((AssetItem)as.assets.get(0)).getName());
        repo.renameCategory("testCatRename/testAnother", "testYetAnother");
        as = repo.findAssetsByCategory("testCatRename/testYetAnother", 0, -1);
        Assert.assertEquals((Object)"fooBar", (Object)((AssetItem)as.assets.get(0)).getName());
    }

    @Test
    public void testAddVersionARule() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pack = repo.createPackage("testAddVersionARule", "description");
        repo.save();
        AssetItem rule = pack.addAsset("my rule", "foobar");
        Assert.assertEquals((Object)"my rule", (Object)rule.getName());
        rule.updateContent("foo foo");
        rule.checkin("version0");
        pack.addAsset("other rule", "description");
        rule.updateContent("foo bar");
        rule.checkin("version1");
        PackageItem pack2 = repo.loadPackage("testAddVersionARule");
        Iterator it = pack2.getAssets();
        it.next();
        it.next();
        Assert.assertFalse((boolean)it.hasNext());
        AssetItem prev = (AssetItem)rule.getPrecedingVersion();
        Assert.assertEquals((Object)"foo bar", (Object)rule.getContent());
        Assert.assertEquals((Object)"foo foo", (Object)prev.getContent());
    }

    @Test
    public void testFindByState() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.createPackage("testFindByStatePackage", "heheheh");
        AssetItem asset1 = pkg.addAsset("asset1", "");
        AssetItem asset2 = pkg.addAsset("asset2", "");
        repo.createState("testFindByState");
        repo.save();
        asset1.updateState("testFindByState");
        asset2.updateState("testFindByState");
        asset1.checkin("");
        asset2.checkin("");
        AssetItemPageResult result = repo.findAssetsByState("testFindByState", true, 0, -1);
        Assert.assertEquals((long)2L, (long)result.assets.size());
    }

    @Test
    public void testFindRulesByName() throws Exception {
        RulesRepository repo = this.getRepo();
        repo.loadDefaultPackage().addAsset("findRulesByNamex1", "X");
        repo.loadDefaultPackage().addAsset("findRulesByNamex2", "X");
        repo.save();
        List list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex1"));
        Assert.assertEquals((long)1L, (long)list.size());
        list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex2"));
        Assert.assertEquals((long)1L, (long)list.size());
        list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex%"));
        Assert.assertEquals((long)2L, (long)list.size());
        repo.createPackageSnapshot("defaultPackage", "testFindRulesByName");
        repo.save();
        list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex2"));
        AssetItem item = (AssetItem)list.get(0);
        Assert.assertEquals((Object)"findRulesByNamex2", (Object)item.getName());
        Assert.assertEquals((Object)"X", (Object)item.getDescription());
        Assert.assertEquals((long)1L, (long)list.size());
        list = RulesRepositoryTest.iteratorToList(repo.findAssetsByName("findRulesByNamex%"));
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testQueryText() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.createPackage("testQueryTest", "");
        AssetItem asset = pkg.addAsset("asset1", "testQueryText1");
        asset.updateSubject("testQueryText42");
        asset.checkin("firstCheckintestQueryTest");
        asset.updateFormat("drl");
        asset.checkin("firstCheckintestQueryTest2");
        pkg.addAsset("asset2", "testQueryText2");
        repo.save();
        List ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("testQueryText*", false));
        Assert.assertEquals((long)2L, (long)ls.size());
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("firstCheckintestQueryTest2", false));
        Assert.assertEquals((long)1L, (long)ls.size());
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("firstCheckintestQueryTest", false));
        Assert.assertEquals((long)0L, (long)ls.size());
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("testQueryText*", false));
        Assert.assertEquals((long)2L, (long)ls.size());
        asset.archiveItem(true);
        asset.checkin("");
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("testQueryText*", false));
        Assert.assertEquals((long)1L, (long)ls.size());
        ls = RulesRepositoryTest.iteratorToList(repo.queryFullText("testQueryText*", true));
        Assert.assertEquals((long)2L, (long)ls.size());
    }

    @Test
    public void testQuery() throws Exception {
        RulesRepository repo = this.getRepo();
        AssetItem asset = repo.loadDefaultPackage().addAsset("testQuery", "wanklerotaryengine1cc");
        asset.updateContent("testingSearchWankle");
        asset.updateSubject("testQueryXXX42");
        asset.checkin("");
        HashMap<String, String[]> q = new HashMap<String, String[]>();
        q.put("drools:subject", new String[]{"testQueryXXX42"});
        AssetItemIterator asit = repo.query(q, false, null);
        List results = RulesRepositoryTest.iteratorToList(asit);
        Assert.assertEquals((long)1L, (long)results.size());
        AssetItem as = (AssetItem)results.get(0);
        Assert.assertEquals((Object)"testQuery", (Object)as.getName());
        asset.updateExternalSource("database");
        asset.checkin("");
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42"});
        q.put("drools:source", new String[]{"database"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, true, null));
        Assert.assertEquals((long)1L, (long)results.size());
        as = (AssetItem)results.get(0);
        Assert.assertEquals((Object)"testQuery", (Object)as.getName());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, null));
        Assert.assertEquals((long)1L, (long)results.size());
        as = (AssetItem)results.get(0);
        Assert.assertEquals((Object)"testQuery", (Object)as.getName());
        q = new HashMap();
        q.put("drools:subject", null);
        q.put("cruddy", new String[0]);
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, null));
        Assert.assertEquals((long)1L, (long)results.size());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", "1974-07-10T00:00:00.000-05:00", "3074-07-10T00:00:00.000-05:00")}));
        Assert.assertEquals((long)1L, (long)results.size());
        as = (AssetItem)results.get(0);
        Assert.assertEquals((Object)"testQuery", (Object)as.getName());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", "1974-07-10T00:00:00.000-05:00", null)}));
        Assert.assertEquals((long)1L, (long)results.size());
        as = (AssetItem)results.get(0);
        Assert.assertEquals((Object)"testQuery", (Object)as.getName());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", null, "3074-07-10T00:00:00.000-05:00")}));
        Assert.assertEquals((long)1L, (long)results.size());
        as = (AssetItem)results.get(0);
        Assert.assertEquals((Object)"testQuery", (Object)as.getName());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", "3074-07-10T00:00:00.000-05:00", null)}));
        Assert.assertEquals((long)0L, (long)results.size());
        q = new HashMap();
        q.put("drools:subject", new String[]{"testQueryXXX42", "wankle"});
        q.put("drools:source", new String[]{"database", "wankle"});
        results = RulesRepositoryTest.iteratorToList(repo.query(q, false, new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", null, "1974-07-10T00:00:00.000-05:00")}));
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testLoadRuleByUUIDWithConcurrentSessions() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem rulePackageItem = repo.loadDefaultPackage();
        AssetItem rule = rulePackageItem.addAsset("testLoadRuleByUUID", "this is a description");
        repo.save();
        String uuid = rule.getNode().getIdentifier();
        AssetItem loaded = repo.loadAssetByUUID(uuid);
        Assert.assertNotNull((Object)loaded);
        Assert.assertEquals((Object)"testLoadRuleByUUID", (Object)loaded.getName());
        Assert.assertEquals((Object)"this is a description", (Object)loaded.getDescription());
        long oldVersionNumber = loaded.getVersionNumber();
        loaded.updateContent("xxx");
        loaded.checkin("woo");
        AssetItem reload = repo.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)"testLoadRuleByUUID", (Object)reload.getName());
        Assert.assertEquals((Object)"xxx", (Object)reload.getContent());
        System.out.println(reload.getVersionNumber());
        System.out.println(loaded.getVersionNumber());
        Assert.assertFalse((reload.getVersionNumber() == oldVersionNumber ? 1 : 0) != 0);
        try {
            repo.loadAssetByUUID("01010101-0101-0101-0101-010101010101");
            Assert.fail((String)"Exception not thrown loading rule package that was not created.");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        AssetItem asset1 = repo.loadDefaultPackage().addAsset("testMultiSession", "description");
        asset1.updateContent("yeah");
        asset1.checkin("boo");
        uuid = asset1.getUUID();
        asset1.updateState("Draft");
        repo.save();
        Session s2 = repo.getSession().getRepository().login((Credentials)new SimpleCredentials("fdd", "password".toCharArray()));
        RulesRepository repo2 = new RulesRepository(s2);
        AssetItem asset2 = repo2.loadAssetByUUID(uuid);
        asset2.updateContent("yeah 42");
        asset2.checkin("yeah");
        asset1 = repo.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)"yeah 42", (Object)asset1.getContent());
        asset1.updateContent("yeah 43");
        asset1.checkin("la");
        asset2 = repo2.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)"yeah 43", (Object)asset2.getContent());
    }

    @Test
    public void testAddRuleCalendarWithDates() {
        RulesRepository rulesRepository = this.getRepo();
        Calendar effectiveDate = Calendar.getInstance();
        Calendar expiredDate = Calendar.getInstance();
        expiredDate.setTimeInMillis(effectiveDate.getTimeInMillis() + 86400000L);
        AssetItem ruleItem1 = rulesRepository.loadDefaultPackage().addAsset("testAddRuleCalendarCalendar", "desc");
        ruleItem1.updateDateEffective(effectiveDate);
        ruleItem1.updateDateExpired(expiredDate);
        Assert.assertNotNull((Object)ruleItem1);
        Assert.assertNotNull((Object)ruleItem1.getNode());
        Assert.assertEquals((Object)effectiveDate, (Object)ruleItem1.getDateEffective());
        Assert.assertEquals((Object)expiredDate, (Object)ruleItem1.getDateExpired());
        ruleItem1.checkin("ho ");
    }

    @Test
    public void testGetState() {
        RulesRepository rulesRepository = this.getRepo();
        StateItem state0 = rulesRepository.createState("testGetState");
        Assert.assertNotNull((Object)state0);
        Assert.assertEquals((Object)"testGetState", (Object)state0.getName());
        StateItem stateItem1 = rulesRepository.getState("testGetState");
        Assert.assertNotNull((Object)stateItem1);
        Assert.assertEquals((Object)"testGetState", (Object)stateItem1.getName());
        StateItem stateItem2 = rulesRepository.getState("testGetState");
        Assert.assertNotNull((Object)stateItem2);
        Assert.assertEquals((Object)"testGetState", (Object)stateItem2.getName());
        Assert.assertEquals((Object)stateItem1, (Object)stateItem2);
    }

    @Test
    public void testGetTag() {
        RulesRepository rulesRepository = this.getRepo();
        CategoryItem root = rulesRepository.loadCategory("/");
        CategoryItem tagItem1 = root.addCategory("testGetTag", "ho");
        Assert.assertNotNull((Object)tagItem1);
        Assert.assertEquals((Object)"testGetTag", (Object)tagItem1.getName());
        Assert.assertEquals((Object)"testGetTag", (Object)tagItem1.getFullPath());
        CategoryItem tagItem2 = rulesRepository.loadCategory("testGetTag");
        Assert.assertNotNull((Object)tagItem2);
        Assert.assertEquals((Object)"testGetTag", (Object)tagItem2.getName());
        Assert.assertEquals((Object)tagItem1, (Object)tagItem2);
        CategoryItem tagItem3 = tagItem2.addCategory("TestChildTag1", "ka");
        Assert.assertNotNull((Object)tagItem3);
        Assert.assertEquals((Object)"TestChildTag1", (Object)tagItem3.getName());
        Assert.assertEquals((Object)"testGetTag/TestChildTag1", (Object)tagItem3.getFullPath());
    }

    @Test
    public void testListPackages() {
        RulesRepository rulesRepository = this.getRepo();
        rulesRepository.createPackage("testListPackages", "desc");
        Assert.assertTrue((boolean)rulesRepository.containsPackage("testListPackages"));
        Assert.assertFalse((boolean)rulesRepository.containsPackage("XXXXXXX"));
        PackageIterator it = rulesRepository.listPackages();
        Assert.assertTrue((boolean)it.hasNext());
        boolean found = false;
        boolean foundGlobalArea = false;
        while (it.hasNext()) {
            PackageItem element = (PackageItem)it.next();
            if (element.getName().equals("testListPackages")) {
                found = true;
            }
            if (!element.getName().equals("globalArea")) continue;
            foundGlobalArea = true;
        }
        Assert.assertTrue((boolean)found);
        Assert.assertFalse((boolean)foundGlobalArea);
    }

    @Test
    public void testFindAssetsByState() throws Exception {
        RulesRepository repo = this.getRepo();
        repo.loadCategory("/").addCategory("testFindAssetsByStateCat", "X");
        PackageItem pkg = repo.createPackage("testFindAssetsByStatePac", "");
        pkg.addAsset("testCat1", "x", "/testFindAssetsByStateCat", "drl");
        pkg.addAsset("testCat2", "x", "/testFindAssetsByStateCat", "drl");
        repo.save();
        AssetItemPageResult apl = repo.findAssetsByState("Draft", false, 0, -1, new RepositoryFilter(){

            public boolean accept(Object artifact, String action) {
                if (!(artifact instanceof AssetItem)) {
                    return false;
                }
                return ((AssetItem)artifact).getName().equalsIgnoreCase("testCat1");
            }
        });
        Assert.assertEquals((long)1L, (long)apl.assets.size());
        Assert.assertEquals((Object)"testCat1", (Object)((AssetItem)apl.assets.get(0)).getName());
    }

    @Test
    public void testFindAssetsByCategory() throws Exception {
        RulesRepository repo = this.getRepo();
        repo.loadCategory("/").addCategory("testFindAssetsByCategoryUsingFilterCat", "X");
        PackageItem pkg = repo.createPackage("testFindAssetsByCategoryUsingFilterPack", "");
        pkg.addAsset("testCat1", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat2", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        repo.save();
        List items = repo.findAssetsByCategory((String)"/testFindAssetsByCategoryUsingFilterCat", (int)0, (int)-1).assets;
        Assert.assertEquals((long)2L, (long)items.size());
        AssetItemPageResult apl = repo.findAssetsByCategory("/testFindAssetsByCategoryUsingFilterCat", false, 0, -1, new RepositoryFilter(){

            public boolean accept(Object artifact, String action) {
                if (!(artifact instanceof AssetItem)) {
                    return false;
                }
                return ((AssetItem)artifact).getName().equalsIgnoreCase("testCat1");
            }
        });
        Assert.assertEquals((long)1L, (long)apl.assets.size());
        Assert.assertEquals((Object)"testCat1", (Object)((AssetItem)apl.assets.get(0)).getName());
        pkg.addAsset("testCat3", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat4", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat5", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat6", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat7", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.addAsset("testCat8", "x", "/testFindAssetsByCategoryUsingFilterCat", "drl");
        pkg.loadAsset("testCat1").archiveItem(true).checkin("");
        pkg.loadAsset("testCat2").archiveItem(true).checkin("");
        pkg.loadAsset("testCat3").archiveItem(true).checkin("");
        pkg.loadAsset("testCat4").archiveItem(true).checkin("");
        repo.save();
        apl = repo.findAssetsByCategory("/testFindAssetsByCategoryUsingFilterCat", 0, -1);
        Assert.assertEquals((long)4L, (long)apl.assets.size());
        ArrayList<String> names = new ArrayList<String>();
        for (AssetItem as : apl.assets) {
            if (names.contains(as.getName())) {
                Assert.fail((String)"dupe returned.");
            }
            names.add(as.getName());
        }
        names = new ArrayList();
        boolean hasNext = true;
        int skip = 0;
        while (hasNext) {
            apl = repo.findAssetsByCategory("/testFindAssetsByCategoryUsingFilterCat", skip, 2);
            for (AssetItem as : apl.assets) {
                if (names.contains(as.getName())) {
                    Assert.fail((String)"dupe returned");
                }
                names.add(as.getName());
            }
            skip = (int)(apl.currentPosition + (long)apl.assets.size() - 2L);
            hasNext = apl.hasNext;
        }
        Assert.assertEquals((long)4L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("testCat5"));
        Assert.assertTrue((boolean)names.contains("testCat6"));
        Assert.assertTrue((boolean)names.contains("testCat7"));
        Assert.assertTrue((boolean)names.contains("testCat8"));
    }

    @Test
    public void testFunnyOrdering() throws Exception {
    }

    @Test
    public void testCategoriesAndSnapshots() throws Exception {
        RulesRepository repo = this.getRepo();
        repo.loadCategory("/").addCategory("testCategoriesAndSnapshots", "X");
        PackageItem pkg = repo.createPackage("testCategoriesAndSnapshots", "");
        pkg.addAsset("testCat1", "x", "/testCategoriesAndSnapshots", "drl");
        pkg.addAsset("testCat2", "x", "/testCategoriesAndSnapshots", "drl");
        repo.save();
        List items = repo.findAssetsByCategory((String)"/testCategoriesAndSnapshots", (int)0, (int)-1).assets;
        Assert.assertEquals((long)2L, (long)items.size());
        repo.createPackageSnapshot("testCategoriesAndSnapshots", "SNAP 1");
        items = repo.findAssetsByCategory((String)"testCategoriesAndSnapshots", (int)0, (int)-1).assets;
        Assert.assertEquals((long)2L, (long)items.size());
        Assert.assertTrue((boolean)repo.containsSnapshot("testCategoriesAndSnapshots", "SNAP 1"));
        Assert.assertFalse((boolean)repo.containsSnapshot("testCategoriesAndSnapshots", "SNAP XXXX"));
        Assert.assertFalse((boolean)repo.containsSnapshot("gooberWhhewasssllllelelelelele", "SNAP"));
    }

    @Test
    public void testMoveRulePackage() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.createPackage("testMove", "description");
        AssetItem r = pkg.addAsset("testMove", "description");
        r.checkin("version0");
        String uuid = r.getUUID();
        Assert.assertEquals((Object)"testMove", (Object)r.getPackageName());
        repo.save();
        Assert.assertEquals((long)1L, (long)RulesRepositoryTest.iteratorToList(pkg.getAssets()).size());
        repo.createPackage("testMove2", "description");
        repo.moveRuleItemPackage("testMove2", r.node.getIdentifier(), "explanation");
        pkg = repo.loadPackage("testMove");
        Assert.assertEquals((long)0L, (long)RulesRepositoryTest.iteratorToList(pkg.getAssets()).size());
        pkg = repo.loadPackage("testMove2");
        Assert.assertEquals((long)1L, (long)RulesRepositoryTest.iteratorToList(pkg.getAssets()).size());
        r = (AssetItem)pkg.getAssets().next();
        Assert.assertEquals((Object)"testMove", (Object)r.getName());
        Assert.assertEquals((Object)"testMove2", (Object)r.getPackageName());
        Assert.assertEquals((Object)"explanation", (Object)r.getCheckinComment());
        AssetItem p = (AssetItem)r.getPrecedingVersion();
        Assert.assertEquals((Object)"testMove", (Object)p.getPackageName());
        Assert.assertEquals((Object)"version0", (Object)p.getCheckinComment());
        Assert.assertEquals((Object)uuid, (Object)r.getUUID());
    }

    @Test
    public void testCopyAsset() throws Exception {
        RulesRepository repo = this.getRepo();
        repo.createPackage("testCopyAsset", "asset");
        AssetItem item = repo.loadDefaultPackage().addAsset("testCopyAssetSource", "desc");
        item.updateContent("la");
        item.checkin("");
        item.updateDescription("mmm");
        item.checkin("again");
        Assert.assertEquals((long)2L, (long)item.getVersionNumber());
        String uuid = repo.copyAsset(item.getUUID(), "testCopyAsset", "testCopyAssetDestination");
        AssetItem dest = repo.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)dest.getName(), (Object)dest.getTitle());
        Assert.assertEquals((Object)"la", (Object)dest.getContent());
        Assert.assertEquals((Object)"testCopyAsset", (Object)dest.getPackageName());
        Assert.assertFalse((boolean)uuid.equals(item.getUUID()));
        Assert.assertEquals((long)1L, (long)dest.getVersionNumber());
    }

    @Test
    public void testRenameAsset() throws Exception {
        RulesRepository repo = this.getRepo();
        repo.createPackage("testRenameAsset", "asset");
        AssetItem item = repo.loadPackage("testRenameAsset").addAsset("testRenameAssetSource", "desc");
        item.updateContent("la");
        item.checkin("");
        String uuid = repo.renameAsset(item.getUUID(), "testRename2");
        item = repo.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)"testRename2", (Object)item.getName());
        Assert.assertEquals((Object)"testRename2", (Object)item.getTitle());
        List assets = RulesRepositoryTest.iteratorToList(repo.loadPackage("testRenameAsset").getAssets());
        Assert.assertEquals((long)1L, (long)assets.size());
        item = (AssetItem)assets.get(0);
        Assert.assertEquals((Object)"testRename2", (Object)item.getName());
        Assert.assertEquals((Object)"la", (Object)item.getContent());
    }

    @Test
    public void testRenamePackage() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem original = repo.createPackage("testRenamePackage", "asset");
        List packagesOriginal = RulesRepositoryTest.iteratorToList(repo.listPackages());
        AssetItem item = repo.loadPackage("testRenamePackage").addAsset("testRenameAssetSource", "desc");
        item.updateContent("la");
        item.checkin("");
        String uuid = repo.renamePackage(original.getUUID(), "testRenamePackage2");
        PackageItem pkg = repo.loadPackageByUUID(uuid);
        Assert.assertEquals((Object)"testRenamePackage2", (Object)pkg.getName());
        List assets = RulesRepositoryTest.iteratorToList(repo.loadPackage("testRenamePackage2").getAssets());
        Assert.assertEquals((long)1L, (long)assets.size());
        item = (AssetItem)assets.get(0);
        Assert.assertEquals((Object)"testRenameAssetSource", (Object)item.getName());
        Assert.assertEquals((Object)"la", (Object)item.getContent());
        Assert.assertEquals((Object)"testRenamePackage2", (Object)item.getPackageName());
        List packageFinal = RulesRepositoryTest.iteratorToList(repo.listPackages());
        Assert.assertEquals((long)packagesOriginal.size(), (long)packageFinal.size());
    }

    @Test
    public void testCopyPackage() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem source = repo.createPackage("testCopyPackage", "asset");
        AssetItem item = source.addAsset("testCopyPackage", "desc");
        item.updateContent("la");
        item.checkin("");
        repo.save();
        repo.copyPackage("testCopyPackage", "testCopyPackage2");
        PackageItem dest = repo.loadPackage("testCopyPackage2");
        Assert.assertNotNull((Object)dest);
        Assert.assertFalse((boolean)source.getUUID().equals(dest.getUUID()));
        Assert.assertEquals((long)1L, (long)RulesRepositoryTest.iteratorToList(dest.getAssets()).size());
        AssetItem item2 = (AssetItem)dest.getAssets().next();
        Assert.assertEquals((Object)"testCopyPackage", (Object)item.getPackageName());
        Assert.assertEquals((Object)"testCopyPackage2", (Object)item2.getPackageName());
        item2.updateContent("goober choo");
        item2.checkin("yeah");
        Assert.assertEquals((Object)"la", (Object)item.getContent());
        try {
            repo.copyPackage("testCopyPackage", "testCopyPackage2");
            Assert.fail((String)"should not be able to copy when existing.");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testListStates() {
        RulesRepository repo = this.getRepo();
        StateItem[] items = repo.listStates();
        Assert.assertTrue((items.length > 0 ? 1 : 0) != 0);
        repo.createState("testListStates");
        StateItem[] items2 = repo.listStates();
        Assert.assertEquals((long)(items.length + 1), (long)items2.length);
    }

    @Test
    public void testRenameState() {
        RulesRepository repo = this.getRepo();
        StateItem[] items = repo.listStates();
        Assert.assertTrue((items.length > 0 ? 1 : 0) != 0);
        String oldName = "stateThatHasALongNameAndWillBeRenamed";
        repo.createState("stateThatHasALongNameAndWillBeRenamed");
        StateItem[] items2 = repo.listStates();
        Assert.assertEquals((long)(items.length + 1), (long)items2.length);
        String newName = "stateThatHasALongNameAndWillBeRenamedNameAfterTheRenaming";
        repo.renameState("stateThatHasALongNameAndWillBeRenamed", "stateThatHasALongNameAndWillBeRenamedNameAfterTheRenaming");
        StateItem[] items3 = repo.listStates();
        Assert.assertEquals((long)items2.length, (long)items3.length);
        try {
            repo.loadState("stateThatHasALongNameAndWillBeRenamed");
            Assert.fail((String)"Should never be here. Old name is still used.");
        }
        catch (RulesRepositoryException e) {
            // empty catch block
        }
        Assert.assertNotNull((Object)repo.loadState("stateThatHasALongNameAndWillBeRenamedNameAfterTheRenaming"));
    }

    @Test
    public void testRemoveState() {
        RulesRepository repo = this.getRepo();
        StateItem[] items = repo.listStates();
        Assert.assertTrue((items.length > 0 ? 1 : 0) != 0);
        String name = "stateThatHasALongNameAndWillBeRenamed";
        repo.createState("stateThatHasALongNameAndWillBeRenamed");
        StateItem[] items2 = repo.listStates();
        Assert.assertEquals((long)(items.length + 1), (long)items2.length);
        repo.loadState("stateThatHasALongNameAndWillBeRenamed").remove();
        repo.save();
        StateItem[] items3 = repo.listStates();
        Assert.assertEquals((long)(items2.length - 1), (long)items3.length);
        try {
            repo.loadState("stateThatHasALongNameAndWillBeRenamed");
            Assert.fail((String)"Should never be here. Removed state still exists.");
        }
        catch (RulesRepositoryException e) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleImportExport() throws PathNotFoundException, IOException, RepositoryException {
        RulesRepository repo = this.getRepo();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Session session = this.getRepo().getSession();
        session.refresh(false);
        session.exportSystemView("/drools:repository", (OutputStream)bout, false, false);
        byte[] repository_backup = bout.toByteArray();
        repo.importRulesRepositoryFromStream((InputStream)new ByteArrayInputStream(repository_backup));
    }

    @Test
    public void testImportExport() {
        RulesRepository repo = this.getRepo();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        repo.exportRulesRepositoryToStream((OutputStream)bout);
        byte[] repository_backup = bout.toByteArray();
        Assert.assertNotNull((Object)repository_backup);
        repo.createPackage("testImportExport", "nodescription");
        bout = new ByteArrayOutputStream();
        repo.exportRulesRepositoryToStream((OutputStream)bout);
        byte[] repository_unitest = bout.toByteArray();
        repo.importRulesRepositoryFromStream((InputStream)new ByteArrayInputStream(repository_backup));
        Assert.assertFalse((boolean)repo.containsPackage("testImportExport"));
        repo.importRulesRepositoryFromStream((InputStream)new ByteArrayInputStream(repository_unitest));
        Assert.assertTrue((boolean)repo.containsPackage("testImportExport"));
        repo.importRepository((InputStream)new ByteArrayInputStream(repository_unitest));
        Assert.assertTrue((boolean)repo.containsPackage("testImportExport"));
    }

    @Test
    public void testSimpleShareableNodes() throws Exception {
        Node node = this.getRepo().getSession().getNode("/drools:repository/drools:package_area/globalArea/");
        Node assetNode = node.getNode("assets").addNode("testKurt", "drools:assetNodeType");
        assetNode.setProperty("drools:packageName", "one");
        assetNode.setProperty("drools:title", "title");
        assetNode.setProperty("drools:format", "format");
        assetNode.setProperty("drools:description", "description");
        Calendar lastModified = Calendar.getInstance();
        assetNode.setProperty("drools:lastModified", lastModified);
        this.getRepo().getSession().save();
        assetNode.checkin();
        assetNode.checkout();
        assetNode.addMixin("mix:shareable");
        this.getRepo().getSession().save();
        assetNode.checkin();
        Workspace workspace = this.getRepo().getSession().getWorkspace();
        String srcPath = "/drools:repository/drools:package_area/globalArea/assets/testKurt";
        String path = "/drools:repository/drools:package_area/defaultPackage/assets/testKurt";
        workspace.clone(workspace.getName(), srcPath, path, false);
        assetNode.remove();
    }

    @Test
    public void testShareableNodes() throws Exception {
        RulesRepository repo = this.getRepo();
        AssetItem item = repo.loadDefaultPackage().addAsset("testShareableNodeOriginal", "desc");
        item.updateContent("la");
        item.getNode().addMixin("mix:shareable");
        PackageItem source = repo.createPackage("testShareableNodesPackage", "desc");
        repo.save();
        source.checkout();
        Session session = repo.getSession();
        Workspace workspace = session.getWorkspace();
        String path = "/drools:repository/drools:package_area/testShareableNodesPackage/assets/testShareableNodeShared";
        workspace.clone(workspace.getName(), item.getNode().getPath(), path, false);
        repo.save();
        AssetItem originalItem = repo.loadDefaultPackage().loadAsset("testShareableNodeOriginal");
        AssetItem sharedItem = repo.loadPackage("testShareableNodesPackage").loadAsset("testShareableNodeShared");
        Assert.assertTrue((boolean)originalItem.getContent().equals("la"));
        Assert.assertTrue((boolean)sharedItem.getContent().equals("la"));
        originalItem.remove();
    }

    @Test
    public void testShareableNodesWithQuery() throws Exception {
        RulesRepository repo = this.getRepo();
        AssetItem item = repo.loadGlobalArea().addAsset("testShareableNodesWithQueryOriginal", "desc");
        item.updateFormat("xyz");
        item.getNode().addMixin("mix:shareable");
        PackageItem source = repo.createPackage("testShareableNodesWithQueryPackage", "desc");
        repo.save();
        AssetItemIterator it = repo.loadGlobalArea().queryAssets("drools:format='xyz'");
        List list = RulesRepositoryTest.iteratorToList(it);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AssetItem));
        source.checkout();
        Session session = repo.getSession();
        Workspace workspace = session.getWorkspace();
        String path = "/drools:repository/drools:package_area/testShareableNodesWithQueryPackage/assets/testShareableNodesWithQueryShared";
        workspace.clone(workspace.getName(), item.getNode().getPath(), path, false);
        repo.save();
        AssetItem originalItem = repo.loadGlobalArea().loadAsset("testShareableNodesWithQueryOriginal");
        AssetItem sharedItem = repo.loadPackage("testShareableNodesWithQueryPackage").loadAsset("testShareableNodesWithQueryShared");
        Assert.assertTrue((boolean)originalItem.getFormat().equals("xyz"));
        Assert.assertTrue((boolean)sharedItem.getFormat().equals("xyz"));
        it = repo.loadGlobalArea().queryAssets("drools:format='xyz'");
        list = RulesRepositoryTest.iteratorToList(it);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AssetItem));
    }

    @Test
    @Ignore
    public void testImportExportWithShareableNodes() throws Exception {
        RulesRepository repo = this.getRepo();
        AssetItem item = repo.loadDefaultPackage().addAsset("testImportExportShareableNodeOriginal", "desc");
        item.updateContent("la");
        item.getNode().addMixin("mix:shareable");
        PackageItem source = repo.createPackage("testImportExportShareableNodesPackage", "desc");
        repo.save();
        source.checkout();
        Session session = repo.getSession();
        Workspace workspace = session.getWorkspace();
        String path = "/drools:repository/drools:package_area/testImportExportShareableNodesPackage/assets/testImportExportShareableNodeShared";
        workspace.clone(workspace.getName(), item.getNode().getPath(), path, false);
        repo.save();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        repo.exportRulesRepositoryToStream((OutputStream)bout);
        byte[] repository_backup = bout.toByteArray();
        Assert.assertNotNull((Object)repository_backup);
        repo.importRulesRepositoryFromStream((InputStream)new ByteArrayInputStream(repository_backup));
        Assert.assertTrue((boolean)repo.containsPackage("testImportExportShareableNodesPackage"));
        Assert.assertTrue((boolean)repo.loadPackage("testImportExportShareableNodesPackage").containsAsset("testImportExportShareableNodeOriginal"));
    }

    @Test
    public void testConcurrentCopyPackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getMultiThreadedRepository();
        PackageItem source = repo.createPackage("testConcurrentCopyPackage", "asset");
        AssetItem item = source.addAsset("testCopyPackage", "desc");
        item.updateContent("la");
        item.checkin("");
        repo.save();
        int NUM_ITERATIONS = 40;
        int NUM_SESSIONS = 2;
        for (int n = 0; n < NUM_ITERATIONS; ++n) {
            int i;
            Node folderNode = repo.getAreaNode("drools:package_area");
            while (folderNode.hasNode("testConcurrentCopyPackage2")) {
                folderNode.getNode("testConcurrentCopyPackage2").remove();
                repo.save();
            }
            Thread[] threads = new Thread[NUM_SESSIONS];
            for (i = 0; i < threads.length; ++i) {
                String id = "session#" + i;
                ConcurrentCopySession ts = new ConcurrentCopySession(id);
                Thread t = new Thread(ts);
                t.setName(id);
                t.start();
                threads[i] = t;
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
            }
            folderNode.refresh(true);
            NodeIterator results = folderNode.getNodes("testConcurrentCopyPackage2");
            Assert.assertEquals((long)1L, (long)results.getSize());
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = RulesRepositoryTest.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static <T> List<T> iteratorToList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    class ConcurrentCopySession
    implements Runnable {
        String identity;
        Random r;
        RulesRepository localRepo;

        ConcurrentCopySession(String identity) {
            this.identity = identity;
            this.r = new Random();
            this.localRepo = RepositorySessionUtil.getMultiThreadedRepository();
        }

        private void randomSleep() {
            long l = this.r.nextInt(90) + 20;
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.localRepo.copyPackage("testConcurrentCopyPackage", "testConcurrentCopyPackage2");
                PackageItem dest = this.localRepo.loadPackage("testConcurrentCopyPackage2");
                Assert.assertNotNull((Object)dest);
                this.randomSleep();
            }
            catch (RulesRepositoryException rre) {
                System.out.println("Expected");
            }
        }
    }
}

