/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepository;
import org.drools.repository.UserInfo;
import org.drools.repository.security.PermissionManager;
import org.junit.Assert;
import org.junit.Test;

public class UserInfoTest {
    @Test
    public void testPersistence() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PermissionManager pm = new PermissionManager(repo);
        HashMap<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("wankle", (Map)perms);
        Map perms_ = pm.retrieveUserPermissions("wankle");
        UserInfo info = new UserInfo(repo);
        info.setProperty("inbox", "something", new UserInfo.Val("boo"));
        info.save();
        info.setProperty("inbox", "something", new UserInfo.Val("boo"));
        info.save();
        Assert.assertEquals((Object)"boo", (Object)info.getProperty((String)"inbox", (String)"something").value);
        info.setProperty("inbox", "something", new UserInfo.Val("boo2"));
        Assert.assertEquals((Object)"boo2", (Object)info.getProperty((String)"inbox", (String)"something").value);
        info.setProperty("inbox", "another", new UserInfo.Val("boo"));
        Assert.assertEquals((Object)"boo", (Object)info.getProperty((String)"inbox", (String)"another").value);
        info = new UserInfo(repo);
        info.init(repo, "wankle");
        info.setProperty("inbox", "something", new UserInfo.Val("boo"));
        Assert.assertEquals((Object)"boo", (Object)info.getProperty((String)"inbox", (String)"something").value);
        info.setProperty("inbox", "something", new UserInfo.Val("boo2"));
        Assert.assertEquals((Object)"boo2", (Object)info.getProperty((String)"inbox", (String)"something").value);
        info.setProperty("inbox", "another", new UserInfo.Val("boo"));
        Assert.assertEquals((Object)"boo", (Object)info.getProperty((String)"inbox", (String)"another").value);
        Assert.assertEquals((long)perms_.size(), (long)pm.retrieveUserPermissions("wankle").size());
        pm.updateUserPermissions("wankle", perms_);
        info = new UserInfo(repo);
        Assert.assertEquals((Object)"boo", (Object)info.getProperty((String)"inbox", (String)"another").value);
        pm.removeUserPermissions("wankle");
        info = new UserInfo(repo);
        Assert.assertEquals((Object)"boo", (Object)info.getProperty((String)"inbox", (String)"another").value);
        info = new UserInfo(repo);
        info.init(repo, "meee");
        info.setProperty("inbox", "whee", new UserInfo.Val("boo"));
        Assert.assertEquals((Object)"boo", (Object)info.getProperty((String)"inbox", (String)"whee").value);
        info = new UserInfo(repo);
        Assert.assertEquals((Object)"boo", (Object)info.getProperty((String)"inbox", (String)"another").value);
        info = new UserInfo();
        info.init(repo, "MrX");
        info.setProperty("inbox", "hi", new UserInfo.Val("42"));
        Assert.assertEquals((Object)"42", (Object)info.getProperty((String)"inbox", (String)"hi").value);
        info.init(repo, "MrsX");
        info.setProperty("inbox", "hi", new UserInfo.Val("43"));
        Assert.assertEquals((Object)"43", (Object)info.getProperty((String)"inbox", (String)"hi").value);
        info.init(repo, "MrX");
        info.setProperty("inbox", "hi", new UserInfo.Val("42"));
        Assert.assertEquals((Object)"42", (Object)info.getProperty((String)"inbox", (String)"hi").value);
        Assert.assertEquals((Object)"", (Object)info.getProperty((String)"inbox", (String)"qanno").value);
    }

    @Test
    public void testIterateOverUsers() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        final ArrayList names = new ArrayList();
        UserInfo uf = new UserInfo(repo);
        uf.init(repo, "michael");
        uf.setProperty("random", "property", new UserInfo.Val("hi"));
        UserInfo.eachUser((RulesRepository)repo, (UserInfo.Command)new UserInfo.Command(){

            public void process(String toUser) {
                names.add(toUser);
            }
        });
        Assert.assertTrue((names.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)names.contains("michael"));
    }
}

