/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.File;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryConfigurator;
import org.drools.repository.RulesRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositorySessionUtil {
    private static ThreadLocal<RulesRepository> repo = new ThreadLocal();
    private static Repository multiThreadedRepository;
    private static Session session;
    private static final Logger log;

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                if (RepositorySessionUtil.deleteDir(new File(dir, children[i]))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static RulesRepository getRepository() throws RulesRepositoryException {
        RulesRepository repoInstance = repo.get();
        if (repoInstance == null) {
            log.info("Creating a new Repository Instance..");
            File dir = new File("repository");
            log.info("DELETING test repo: " + dir.getAbsolutePath());
            RepositorySessionUtil.deleteDir(dir);
            log.info("TEST repo was deleted.");
            try {
                multiThreadedRepository = RulesRepositoryConfigurator.getInstance(null).getJCRRepository();
                session = multiThreadedRepository.login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
                RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(session);
                if (admin.isRepositoryInitialized()) {
                    admin.clearRulesRepository();
                }
                RulesRepositoryConfigurator.getInstance(null).setupRepository(session);
                repoInstance = new RulesRepository(session);
                multiThreadedRepository.login((Credentials)new SimpleCredentials("ADMINISTRATOR", "password".toCharArray()));
                repo.set(repoInstance);
            }
            catch (Exception e) {
                throw new RulesRepositoryException(e);
            }
        }
        return repoInstance;
    }

    public static synchronized RulesRepository getMultiThreadedRepository() throws RulesRepositoryException {
        if (multiThreadedRepository == null) {
            File dir = new File("repository");
            log.info("DELETING test repo: " + dir.getAbsolutePath());
            RepositorySessionUtil.deleteDir(dir);
            log.info("TEST repo was deleted.");
            try {
                multiThreadedRepository = RulesRepositoryConfigurator.getInstance(null).getJCRRepository();
                Session session = multiThreadedRepository.login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
                RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(session);
                if (admin.isRepositoryInitialized()) {
                    admin.clearRulesRepository();
                }
                RulesRepositoryConfigurator.getInstance(null).setupRepository(session);
            }
            catch (Exception e) {
                throw new RulesRepositoryException(e);
            }
        }
        try {
            Session session = multiThreadedRepository.login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
            RulesRepository threadLocalRepo = new RulesRepository(session);
            return threadLocalRepo;
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void shutdown() throws RepositoryException {
        RulesRepositoryConfigurator.getInstance(null).shutdown();
        repo.set(null);
        multiThreadedRepository = null;
    }

    static {
        session = null;
        log = LoggerFactory.getLogger(RepositorySessionUtil.class);
    }
}

